/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0007J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/PackagePartClassUtils;", "", "()V", "PART_CLASS_NAME_SUFFIX", "", "decapitalizeAsJavaClassName", "str", "getDefaultPartFqName", "Lorg/jetbrains/kotlin/name/FqName;", "facadeClassFqName", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileNameByFacadeName", "facadeClassName", "getFilePartShortName", "fileName", "getFilesWithCallables", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "", "getPackagePartFqName", "packageFqName", "getPathHashCode", "", "frontend.java"})
public final class PackagePartClassUtils {
    private static final String PART_CLASS_NAME_SUFFIX = "Kt";
    public static final PackagePartClassUtils INSTANCE;

    @JvmStatic
    public static final int getPathHashCode(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        String string = file2.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        return string4.hashCode();
    }

    @JvmStatic
    private static final String decapitalizeAsJavaClassName(String str) {
        String string;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            String string2;
            String string3 = str;
            int n = 0;
            int n2 = 1;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string2 = string5;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
            Locale locale2 = locale;
            n2 = 0;
            String string6 = string3;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toLowerCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
            string2 = string7;
            string3 = str;
            int n3 = 1;
            stringBuilder = stringBuilder.append(string2);
            n2 = 0;
            String string8 = string3;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            string2 = string9;
            string = stringBuilder.append(string2).toString();
        } else if (str.charAt(0) == '_') {
            String string10 = str;
            int n = 1;
            boolean bl = false;
            String string11 = string10;
            if (string11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string12 = string11.substring(n);
            string = string12;
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = str;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final FqName getDefaultPartFqName(@NotNull FqName facadeClassFqName, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)facadeClassFqName, (String)"facadeClassFqName");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        FqName fqName2 = facadeClassFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"facadeClassFqName.parent()");
        String string = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        return PackagePartClassUtils.getPackagePartFqName(fqName2, string);
    }

    @JvmStatic
    @NotNull
    public static final FqName getPackagePartFqName(@NotNull FqName packageFqName, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        String partClassName = PackagePartClassUtils.getFilePartShortName(fileName);
        FqName fqName2 = packageFqName.child(Name.identifier(partClassName));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName.child(Name\u2026dentifier(partClassName))");
        return fqName2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<KtFile> getFilesWithCallables(@NotNull Collection<? extends KtFile> files2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!it.hasTopLevelCallables()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final String getFilePartShortName(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        StringBuilder stringBuilder = new StringBuilder();
        String string = FileUtil.getNameWithoutExtension((String)fileName);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.getNameWithoutExtension(fileName)");
        return stringBuilder.append(NameUtils.getPackagePartClassNamePrefix(string)).append(PART_CLASS_NAME_SUFFIX).toString();
    }

    @JvmStatic
    @Nullable
    public static final String getFileNameByFacadeName(@NotNull String facadeClassName) {
        Intrinsics.checkParameterIsNotNull((Object)facadeClassName, (String)"facadeClassName");
        if (!StringsKt.endsWith$default((String)facadeClassName, (String)PART_CLASS_NAME_SUFFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        String string = facadeClassName;
        int n = 0;
        int n2 = facadeClassName.length() - PART_CLASS_NAME_SUFFIX.length();
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String baseName = string2;
        if (Intrinsics.areEqual((Object)baseName, (Object)"_")) {
            return null;
        }
        return PackagePartClassUtils.decapitalizeAsJavaClassName(baseName) + ".kt";
    }

    private PackagePartClassUtils() {
    }

    static {
        PackagePartClassUtils packagePartClassUtils;
        INSTANCE = packagePartClassUtils = new PackagePartClassUtils();
        PART_CLASS_NAME_SUFFIX = PART_CLASS_NAME_SUFFIX;
    }
}

