/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.nullabilityAnalysis;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.AnalysisContext;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.BoundType;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.BoundTypeTypeParameter;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.ClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.Constraint;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.ConstraintBound;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.DescriptorClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.EqualConstraint;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.JavaClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.KtClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.LiteralBound;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.LiteralClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.Namer;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.Printer$addTypeVariablesNames$;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.SubtypeConstraint;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeParameterClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariable;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariableBound;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariableBoundType;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.UnknownClassReference;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeElement;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\f\u001a\u00020\r*\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\n\u0010\u0010\u001a\u00020\b*\u00020\u0011J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\b*\u00020\u0012H\u0002J\f\u0010\u0010\u001a\u00020\b*\u00020\u0013H\u0002J\f\u0010\u0010\u001a\u00020\b*\u00020\u0014H\u0002J\u0017\u0010\u0015\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/Printer;", "", "analysisContext", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/AnalysisContext;", "(Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/AnalysisContext;)V", "namer", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/Namer;", "name", "", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/TypeVariable;", "getName$nj2k_services", "(Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/TypeVariable;)Ljava/lang/String;", "addTypeVariablesNames", "", "Lcom/intellij/psi/PsiElement;", "addTypeVariablesNames$nj2k_services", "asString", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/BoundType;", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/ClassReference;", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/Constraint;", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/ConstraintBound;", "listConstrains", "", "listConstrains$nj2k_services", "nj2k-services"})
public final class Printer {
    private final Namer namer;
    private final AnalysisContext analysisContext;

    @NotNull
    public final String getName$nj2k_services(@NotNull TypeVariable $this$name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$name, (String)"$this$name");
        return this.namer.name($this$name);
    }

    private final String asString(@NotNull ClassReference $this$asString) {
        String string;
        ClassReference classReference2 = $this$asString;
        if (classReference2 instanceof KtClassReference) {
            string = ((KtClassReference)$this$asString).getKlass().getName();
        } else if (classReference2 instanceof JavaClassReference) {
            string = ((JavaClassReference)$this$asString).getKlass().getName();
        } else if (classReference2 instanceof DescriptorClassReference) {
            string = ((DescriptorClassReference)$this$asString).getDescriptor().getName().toString();
        } else if (classReference2 instanceof TypeParameterClassReference) {
            string = ((TypeParameterClassReference)$this$asString).getTypeParameter().getName();
        } else if (classReference2 instanceof LiteralClassReference) {
            string = "LITERAL";
        } else if (classReference2 instanceof UnknownClassReference) {
            string = ((UnknownClassReference)$this$asString).getText();
        } else {
            String string2 = Reflection.getOrCreateKotlinClass($this$asString.getClass()).toString();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    @NotNull
    public final String asString(@NotNull BoundType $this$asString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$asString, (String)"$this$asString");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        if ($this$asString instanceof TypeVariableBoundType) {
            $this$buildString.append(this.getName$nj2k_services(((TypeVariableBoundType)$this$asString).getTypeVariable()));
            $this$buildString.append("@");
        }
        $this$buildString.append(this.asString($this$asString.getClassReference()));
        Collection collection = $this$asString.getTypeParameters();
        boolean bl5 = false;
        if (!collection.isEmpty()) {
            CollectionsKt.joinTo$default((Iterable)$this$asString.getTypeParameters(), (Appendable)$this$buildString, (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)((Function1)new Function1<BoundTypeTypeParameter, CharSequence>(this, $this$asString){
                final /* synthetic */ Printer this$0;
                final /* synthetic */ BoundType $this_asString$inlined;
                {
                    this.this$0 = printer;
                    this.$this_asString$inlined = boundType;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull BoundTypeTypeParameter it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.this$0.asString(it.getBoundType());
                }
            }), (int)48, null);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String asString(@NotNull Constraint $this$asString) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        Constraint constraint = $this$asString;
        if (constraint instanceof EqualConstraint) {
            string = this.asString(((EqualConstraint)$this$asString).getLeftBound()) + " := " + this.asString(((EqualConstraint)$this$asString).getRightBound());
        } else if (constraint instanceof SubtypeConstraint) {
            string = this.asString(((SubtypeConstraint)$this$asString).getLowerBound()) + " <: " + this.asString(((SubtypeConstraint)$this$asString).getUpperBound());
        } else {
            String string2 = "Unknown constraint " + Reflection.getOrCreateKotlinClass($this$asString.getClass()).getQualifiedName();
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return stringBuilder.append(string).append(", because of '").append((Object)$this$asString.getCameFrom()).append('\'').toString();
    }

    private final String asString(@NotNull ConstraintBound $this$asString) {
        String string;
        ConstraintBound constraintBound = $this$asString;
        if (constraintBound instanceof LiteralBound) {
            string = ((LiteralBound)$this$asString).getNullability().toString();
        } else if (constraintBound instanceof TypeVariableBound) {
            string = this.getName$nj2k_services(((TypeVariableBound)$this$asString).getTypeVariable());
        } else {
            String string2 = "Unknown constraint bound " + Reflection.getOrCreateKotlinClass($this$asString.getClass()).getQualifiedName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void addTypeVariablesNames$nj2k_services(@NotNull PsiElement $this$addTypeVariablesNames) {
        void $this$forEachDescendantOfType$iv$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$addTypeVariablesNames, (String)"$this$addTypeVariablesNames");
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default($this$addTypeVariablesNames, false, 2, null);
        PsiElement $this$collectDescendantsOfType$iv = $this$addTypeVariablesNames;
        Function1 predicate$iv = addTypeVariablesNames$$inlined$collectDescendantsOfType$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        ArrayList result$iv$iv = new ArrayList();
        PsiElement psiElement2 = $this$collectDescendantsOfType$iv$iv;
        Function1 action$iv$iv$iv = (Function1)new Function1<KtTypeElement, Unit>(predicate$iv, result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ ArrayList $result;
            {
                this.$predicate = function1;
                this.$result = arrayList;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$result.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
                if (element3 instanceof KtTypeElement) {
                    this.$action.invoke((Object)element3);
                }
            }
        });
        for (KtTypeElement typeElement : (List)result$iv$iv) {
            Object object = this.analysisContext.getTypeElementToTypeVariable().get(typeElement);
            if (object == null || (object = this.getName$nj2k_services((TypeVariable)object)) == null) {
                continue;
            }
            Object typeVariableName = object;
            PsiComment comment = factory2.createComment("/*" + (String)typeVariableName + "@*/");
            typeElement.getParent().addBefore((PsiElement)comment, (PsiElement)typeElement);
        }
    }

    @NotNull
    public final String listConstrains$nj2k_services(@NotNull List<? extends Constraint> $this$listConstrains) {
        Intrinsics.checkParameterIsNotNull($this$listConstrains, (String)"$this$listConstrains");
        return CollectionsKt.joinToString$default((Iterable)$this$listConstrains, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Constraint, CharSequence>(this){
            final /* synthetic */ Printer this$0;

            @NotNull
            public final CharSequence invoke(@NotNull Constraint it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Printer.access$asString(this.this$0, it);
            }
            {
                this.this$0 = printer;
                super(1);
            }
        }), (int)30, null);
    }

    public Printer(@NotNull AnalysisContext analysisContext) {
        Intrinsics.checkParameterIsNotNull((Object)analysisContext, (String)"analysisContext");
        this.analysisContext = analysisContext;
        this.namer = new Namer(this.analysisContext);
    }

    public static final /* synthetic */ String access$asString(Printer $this, Constraint $this$access_u24asString) {
        return $this.asString($this$access_u24asString);
    }
}

