/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.nullabilityAnalysis;

import com.intellij.psi.tree.IElementType;
import javaslang.control.Option;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.Nullability;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.UtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactoryImpl;
import org.jetbrains.kotlin.resolve.jvm.checkers.EnhancedNullabilityInfo;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityCheckerKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.javaslang.JavaslangAdaptersKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u000e\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u0001H\u0000\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0002\u001a\u001c\u0010\t\u001a\u00020\u0005*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\n\u0010\u000f\u001a\u00020\u0005*\u00020\u0001\u001a\f\u0010\u0010\u001a\u00020\u0005*\u00020\u0001H\u0000\u00a8\u0006\u0011"}, d2={"deepestReceiver", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getForcedNullability", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/Nullability;", "isComaprationWithNull", "", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isEqualsToken", "Lcom/intellij/psi/tree/IElementType;", "isExternallyAnnotatedNotNull", "Lorg/jetbrains/kotlin/types/KotlinType;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "dataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "isLiteral", "isNullable", "nj2k-services"})
public final class UtilsKt {
    @NotNull
    public static final KtExpression deepestReceiver(@NotNull KtExpression $this$deepestReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)$this$deepestReceiver, (String)"$this$deepestReceiver");
        return (KtExpression)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)$this$deepestReceiver, (Function1)deepestReceiver.1.INSTANCE));
    }

    public static final boolean isNullable(@NotNull KtExpression $this$isNullable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNullable, (String)"$this$isNullable");
        KotlinType kotlinType2 = CallUtilKt.getType($this$isNullable, ResolutionUtils.analyze$default($this$isNullable, null, 1, null));
        return kotlinType2 == null || KotlinTypeKt.isNullable(kotlinType2);
    }

    @Nullable
    public static final Nullability getForcedNullability(@NotNull KtExpression $this$getForcedNullability) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getForcedNullability, (String)"$this$getForcedNullability");
        BindingContext bindingContext2 = ResolutionUtils.analyze$default($this$getForcedNullability, null, 1, null);
        KotlinType kotlinType2 = CallUtilKt.getType($this$getForcedNullability, bindingContext2);
        if (kotlinType2 == null) {
            return null;
        }
        KotlinType type2 = kotlinType2;
        if (!KotlinTypeKt.isNullable(type2)) {
            return Nullability.NOT_NULL;
        }
        DataFlowValue dataFlowValue2 = new DataFlowValueFactoryImpl(LanguageVersionSettingsImpl.DEFAULT).createDataFlowValue($this$getForcedNullability, type2, bindingContext2, ResolutionUtils.getResolutionFacade($this$getForcedNullability).getModuleDescriptor());
        Object object = (KotlinTypeInfo)ResolutionUtils.analyze$default($this$getForcedNullability, null, 1, null).get(BindingContext.EXPRESSION_TYPE_INFO, $this$getForcedNullability);
        if (object == null || (object = ((KotlinTypeInfo)object).getDataFlowInfo()) == null) {
            return null;
        }
        Object dataFlowInfo = object;
        Option option = dataFlowInfo.getCompleteNullabilityInfo().get((Object)dataFlowValue2);
        return (option != null ? (org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability)((Object)JavaslangAdaptersKt.getOrNull(option)) : null) == org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability.NOT_NULL ? Nullability.NOT_NULL : (UtilsKt.isExternallyAnnotatedNotNull(type2, (DataFlowInfo)dataFlowInfo, dataFlowValue2) ? Nullability.NOT_NULL : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isExternallyAnnotatedNotNull(@NotNull KotlinType $this$isExternallyAnnotatedNotNull, DataFlowInfo dataFlowInfo, DataFlowValue dataFlowValue2) {
        EnhancedNullabilityInfo enhancedNullabilityInfo = JavaNullabilityCheckerKt.mustNotBeNull($this$isExternallyAnnotatedNotNull);
        if (enhancedNullabilityInfo == null) return false;
        if (!enhancedNullabilityInfo.isFromJava()) return false;
        if (!dataFlowInfo.getStableNullability(dataFlowValue2).canBeNull()) return false;
        return true;
    }

    private static final boolean isEqualsToken(@NotNull IElementType $this$isEqualsToken) {
        return Intrinsics.areEqual((Object)$this$isEqualsToken, (Object)((Object)KtTokens.EQEQ)) || Intrinsics.areEqual((Object)$this$isEqualsToken, (Object)((Object)KtTokens.EXCLEQ)) || Intrinsics.areEqual((Object)$this$isEqualsToken, (Object)((Object)KtTokens.EQEQEQ)) || Intrinsics.areEqual((Object)$this$isEqualsToken, (Object)((Object)KtTokens.EXCLEQEQEQ));
    }

    public static final boolean isComaprationWithNull(@NotNull KtBinaryExpression $this$isComaprationWithNull) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isComaprationWithNull, (String)"$this$isComaprationWithNull");
        IElementType iElementType = $this$isComaprationWithNull.getOperationToken();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"operationToken");
        return UtilsKt.isEqualsToken(iElementType) && (IfThenUtilsKt.isNullExpression($this$isComaprationWithNull.getLeft()) || IfThenUtilsKt.isNullExpression($this$isComaprationWithNull.getRight()));
    }

    public static final boolean isLiteral(@NotNull KtExpression $this$isLiteral) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isLiteral, (String)"$this$isLiteral");
        return $this$isLiteral instanceof KtStringTemplateExpression || $this$isLiteral instanceof KtLiteralStringTemplateEntry || $this$isLiteral instanceof KtConstantExpression || IfThenUtilsKt.isNullExpression($this$isLiteral);
    }
}

