/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.protobuf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.kotlin.protobuf.ByteString;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.CodedOutputStream;
import org.jetbrains.kotlin.protobuf.Descriptors;
import org.jetbrains.kotlin.protobuf.ExtensionRegistry;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.protobuf.FieldSet;
import org.jetbrains.kotlin.protobuf.LazyField;
import org.jetbrains.kotlin.protobuf.Message;
import org.jetbrains.kotlin.protobuf.MessageOrBuilder;
import org.jetbrains.kotlin.protobuf.UnknownFieldSet;
import org.jetbrains.kotlin.protobuf.WireFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageReflection {
    MessageReflection() {
    }

    static void writeMessageTo(Message message2, CodedOutputStream output, boolean alwaysWriteRequiredFields) throws IOException {
        boolean isMessageSet = message2.getDescriptorForType().getOptions().getMessageSetWireFormat();
        Map<Descriptors.FieldDescriptor, Object> fields2 = message2.getAllFields();
        if (alwaysWriteRequiredFields) {
            fields2 = new TreeMap<Descriptors.FieldDescriptor, Object>(fields2);
            for (Descriptors.FieldDescriptor field2 : message2.getDescriptorForType().getFields()) {
                if (!field2.isRequired() || fields2.containsKey(field2)) continue;
                fields2.put(field2, message2.getField(field2));
            }
        }
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : fields2.entrySet()) {
            Descriptors.FieldDescriptor field3 = entry.getKey();
            Object value2 = entry.getValue();
            if (isMessageSet && field3.isExtension() && field3.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !field3.isRepeated()) {
                output.writeMessageSetExtension(field3.getNumber(), (Message)value2);
                continue;
            }
            FieldSet.writeField(field3, value2, output);
        }
        UnknownFieldSet unknownFields = message2.getUnknownFields();
        if (isMessageSet) {
            unknownFields.writeAsMessageSetTo(output);
        } else {
            unknownFields.writeTo(output);
        }
    }

    static int getSerializedSize(Message message2) {
        int size = 0;
        boolean isMessageSet = message2.getDescriptorForType().getOptions().getMessageSetWireFormat();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : message2.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field2 = entry.getKey();
            Object value2 = entry.getValue();
            if (isMessageSet && field2.isExtension() && field2.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !field2.isRepeated()) {
                size += CodedOutputStream.computeMessageSetExtensionSize(field2.getNumber(), (Message)value2);
                continue;
            }
            size += FieldSet.computeFieldSize(field2, value2);
        }
        UnknownFieldSet unknownFields = message2.getUnknownFields();
        size = isMessageSet ? (size += unknownFields.getSerializedSizeAsMessageSet()) : (size += unknownFields.getSerializedSize());
        return size;
    }

    static String delimitWithCommas(List<String> parts) {
        StringBuilder result2 = new StringBuilder();
        for (String part : parts) {
            if (result2.length() > 0) {
                result2.append(", ");
            }
            result2.append(part);
        }
        return result2.toString();
    }

    static boolean isInitialized(MessageOrBuilder message2) {
        for (Descriptors.FieldDescriptor fieldDescriptor : message2.getDescriptorForType().getFields()) {
            if (!fieldDescriptor.isRequired() || message2.hasField(fieldDescriptor)) continue;
            return false;
        }
        for (Map.Entry entry : message2.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field3 = (Descriptors.FieldDescriptor)entry.getKey();
            if (field3.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            if (field3.isRepeated()) {
                for (Message element3 : (List)entry.getValue()) {
                    if (element3.isInitialized()) continue;
                    return false;
                }
                continue;
            }
            if (((Message)entry.getValue()).isInitialized()) continue;
            return false;
        }
        return true;
    }

    private static String subMessagePrefix(String prefix, Descriptors.FieldDescriptor field2, int index2) {
        StringBuilder result2 = new StringBuilder(prefix);
        if (field2.isExtension()) {
            result2.append('(').append(field2.getFullName()).append(')');
        } else {
            result2.append(field2.getName());
        }
        if (index2 != -1) {
            result2.append('[').append(index2).append(']');
        }
        result2.append('.');
        return result2.toString();
    }

    private static void findMissingFields(MessageOrBuilder message2, String prefix, List<String> results2) {
        for (Descriptors.FieldDescriptor fieldDescriptor : message2.getDescriptorForType().getFields()) {
            if (!fieldDescriptor.isRequired() || message2.hasField(fieldDescriptor)) continue;
            String string = String.valueOf(prefix);
            String string2 = String.valueOf(fieldDescriptor.getName());
            results2.add(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        for (Map.Entry entry : message2.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field3 = (Descriptors.FieldDescriptor)entry.getKey();
            Object value2 = entry.getValue();
            if (field3.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            if (field3.isRepeated()) {
                int i2 = 0;
                for (Object element3 : (List)value2) {
                    MessageReflection.findMissingFields((MessageOrBuilder)element3, MessageReflection.subMessagePrefix(prefix, field3, i2++), results2);
                }
                continue;
            }
            if (!message2.hasField(field3)) continue;
            MessageReflection.findMissingFields((MessageOrBuilder)value2, MessageReflection.subMessagePrefix(prefix, field3, -1), results2);
        }
    }

    static List<String> findMissingFields(MessageOrBuilder message2) {
        ArrayList<String> results2 = new ArrayList<String>();
        MessageReflection.findMissingFields(message2, "", results2);
        return results2;
    }

    static boolean mergeFieldFrom(CodedInputStream input, UnknownFieldSet.Builder unknownFields, ExtensionRegistryLite extensionRegistry, Descriptors.Descriptor type2, MergeTarget target, int tag) throws IOException {
        Descriptors.FieldDescriptor field2;
        if (type2.getOptions().getMessageSetWireFormat() && tag == WireFormat.MESSAGE_SET_ITEM_TAG) {
            MessageReflection.mergeMessageSetExtensionFromCodedStream(input, unknownFields, extensionRegistry, type2, target);
            return true;
        }
        int wireType = WireFormat.getTagWireType(tag);
        int fieldNumber = WireFormat.getTagFieldNumber(tag);
        Message defaultInstance = null;
        if (type2.isExtensionNumber(fieldNumber)) {
            if (extensionRegistry instanceof ExtensionRegistry) {
                ExtensionRegistry.ExtensionInfo extension = target.findExtensionByNumber((ExtensionRegistry)extensionRegistry, type2, fieldNumber);
                if (extension == null) {
                    field2 = null;
                } else {
                    field2 = extension.descriptor;
                    defaultInstance = extension.defaultInstance;
                    if (defaultInstance == null && field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                        String string = String.valueOf(field2.getFullName());
                        throw new IllegalStateException(string.length() != 0 ? "Message-typed extension lacked default instance: ".concat(string) : new String("Message-typed extension lacked default instance: "));
                    }
                }
            } else {
                field2 = null;
            }
        } else {
            field2 = target.getContainerType() == MergeTarget.ContainerType.MESSAGE ? type2.findFieldByNumber(fieldNumber) : null;
        }
        boolean unknown = false;
        boolean packed = false;
        if (field2 == null) {
            unknown = true;
        } else if (wireType == FieldSet.getWireFormatForFieldType(field2.getLiteType(), false)) {
            packed = false;
        } else if (field2.isPackable() && wireType == FieldSet.getWireFormatForFieldType(field2.getLiteType(), true)) {
            packed = true;
        } else {
            unknown = true;
        }
        if (unknown) {
            return unknownFields.mergeFieldFrom(tag, input);
        }
        if (packed) {
            int length = input.readRawVarint32();
            int limit = input.pushLimit(length);
            if (field2.getLiteType() == WireFormat.FieldType.ENUM) {
                while (input.getBytesUntilLimit() > 0) {
                    int rawValue = input.readEnum();
                    Descriptors.EnumValueDescriptor value2 = field2.getEnumType().findValueByNumber(rawValue);
                    if (value2 == null) {
                        return true;
                    }
                    target.addRepeatedField(field2, value2);
                }
            } else {
                while (input.getBytesUntilLimit() > 0) {
                    Object value3 = target.readPrimitiveField(input, field2.getLiteType(), field2.needsUtf8Check());
                    target.addRepeatedField(field2, value3);
                }
            }
            input.popLimit(limit);
        } else {
            Object value4;
            switch (field2.getType()) {
                case GROUP: {
                    value4 = target.parseGroup(input, extensionRegistry, field2, defaultInstance);
                    break;
                }
                case MESSAGE: {
                    value4 = target.parseMessage(input, extensionRegistry, field2, defaultInstance);
                    break;
                }
                case ENUM: {
                    int rawValue = input.readEnum();
                    value4 = field2.getEnumType().findValueByNumber(rawValue);
                    if (value4 != null) break;
                    unknownFields.mergeVarintField(fieldNumber, rawValue);
                    return true;
                }
                default: {
                    value4 = target.readPrimitiveField(input, field2.getLiteType(), field2.needsUtf8Check());
                }
            }
            if (field2.isRepeated()) {
                target.addRepeatedField(field2, value4);
            } else {
                target.setField(field2, value4);
            }
        }
        return true;
    }

    private static void mergeMessageSetExtensionFromCodedStream(CodedInputStream input, UnknownFieldSet.Builder unknownFields, ExtensionRegistryLite extensionRegistry, Descriptors.Descriptor type2, MergeTarget target) throws IOException {
        int tag;
        int typeId = 0;
        ByteString rawBytes = null;
        ExtensionRegistry.ExtensionInfo extension = null;
        while ((tag = input.readTag()) != 0) {
            if (tag == WireFormat.MESSAGE_SET_TYPE_ID_TAG) {
                typeId = input.readUInt32();
                if (typeId == 0 || !(extensionRegistry instanceof ExtensionRegistry)) continue;
                extension = target.findExtensionByNumber((ExtensionRegistry)extensionRegistry, type2, typeId);
                continue;
            }
            if (tag == WireFormat.MESSAGE_SET_MESSAGE_TAG) {
                if (typeId != 0 && extension != null && ExtensionRegistryLite.isEagerlyParseMessageSets()) {
                    MessageReflection.eagerlyMergeMessageSetExtension(input, extension, extensionRegistry, target);
                    rawBytes = null;
                    continue;
                }
                rawBytes = input.readBytes();
                continue;
            }
            if (input.skipField(tag)) continue;
            break;
        }
        input.checkLastTagWas(WireFormat.MESSAGE_SET_ITEM_END_TAG);
        if (rawBytes != null && typeId != 0) {
            if (extension != null) {
                MessageReflection.mergeMessageSetExtensionFromBytes(rawBytes, extension, extensionRegistry, target);
            } else if (rawBytes != null) {
                unknownFields.mergeField(typeId, UnknownFieldSet.Field.newBuilder().addLengthDelimited(rawBytes).build());
            }
        }
    }

    private static void mergeMessageSetExtensionFromBytes(ByteString rawBytes, ExtensionRegistry.ExtensionInfo extension, ExtensionRegistryLite extensionRegistry, MergeTarget target) throws IOException {
        Descriptors.FieldDescriptor field2 = extension.descriptor;
        boolean hasOriginalValue = target.hasField(field2);
        if (hasOriginalValue || ExtensionRegistryLite.isEagerlyParseMessageSets()) {
            Object value2 = target.parseMessageFromBytes(rawBytes, extensionRegistry, field2, extension.defaultInstance);
            target.setField(field2, value2);
        } else {
            LazyField lazyField = new LazyField(extension.defaultInstance, extensionRegistry, rawBytes);
            target.setField(field2, lazyField);
        }
    }

    private static void eagerlyMergeMessageSetExtension(CodedInputStream input, ExtensionRegistry.ExtensionInfo extension, ExtensionRegistryLite extensionRegistry, MergeTarget target) throws IOException {
        Descriptors.FieldDescriptor field2 = extension.descriptor;
        Object value2 = target.parseMessage(input, extensionRegistry, field2, extension.defaultInstance);
        target.setField(field2, value2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExtensionAdapter
    implements MergeTarget {
        private final FieldSet<Descriptors.FieldDescriptor> extensions;

        ExtensionAdapter(FieldSet<Descriptors.FieldDescriptor> extensions) {
            this.extensions = extensions;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            throw new UnsupportedOperationException("getDescriptorForType() called on FieldSet object");
        }

        @Override
        public Object getField(Descriptors.FieldDescriptor field2) {
            return this.extensions.getField(field2);
        }

        @Override
        public boolean hasField(Descriptors.FieldDescriptor field2) {
            return this.extensions.hasField(field2);
        }

        @Override
        public MergeTarget setField(Descriptors.FieldDescriptor field2, Object value2) {
            this.extensions.setField(field2, value2);
            return this;
        }

        @Override
        public MergeTarget clearField(Descriptors.FieldDescriptor field2) {
            this.extensions.clearField(field2);
            return this;
        }

        @Override
        public MergeTarget setRepeatedField(Descriptors.FieldDescriptor field2, int index2, Object value2) {
            this.extensions.setRepeatedField(field2, index2, value2);
            return this;
        }

        @Override
        public MergeTarget addRepeatedField(Descriptors.FieldDescriptor field2, Object value2) {
            this.extensions.addRepeatedField(field2, value2);
            return this;
        }

        @Override
        public boolean hasOneof(Descriptors.OneofDescriptor oneof) {
            return false;
        }

        @Override
        public MergeTarget clearOneof(Descriptors.OneofDescriptor oneof) {
            return this;
        }

        @Override
        public Descriptors.FieldDescriptor getOneofFieldDescriptor(Descriptors.OneofDescriptor oneof) {
            return null;
        }

        @Override
        public MergeTarget.ContainerType getContainerType() {
            return MergeTarget.ContainerType.EXTENSION_SET;
        }

        @Override
        public ExtensionRegistry.ExtensionInfo findExtensionByName(ExtensionRegistry registry, String name2) {
            return registry.findImmutableExtensionByName(name2);
        }

        @Override
        public ExtensionRegistry.ExtensionInfo findExtensionByNumber(ExtensionRegistry registry, Descriptors.Descriptor containingType, int fieldNumber) {
            return registry.findImmutableExtensionByNumber(containingType, fieldNumber);
        }

        @Override
        public Object parseGroup(CodedInputStream input, ExtensionRegistryLite registry, Descriptors.FieldDescriptor field2, Message defaultInstance) throws IOException {
            Message originalMessage;
            Message.Builder subBuilder = defaultInstance.newBuilderForType();
            if (!field2.isRepeated() && (originalMessage = (Message)this.getField(field2)) != null) {
                subBuilder.mergeFrom(originalMessage);
            }
            input.readGroup(field2.getNumber(), subBuilder, registry);
            return subBuilder.buildPartial();
        }

        @Override
        public Object parseMessage(CodedInputStream input, ExtensionRegistryLite registry, Descriptors.FieldDescriptor field2, Message defaultInstance) throws IOException {
            Message originalMessage;
            Message.Builder subBuilder = defaultInstance.newBuilderForType();
            if (!field2.isRepeated() && (originalMessage = (Message)this.getField(field2)) != null) {
                subBuilder.mergeFrom(originalMessage);
            }
            input.readMessage(subBuilder, registry);
            return subBuilder.buildPartial();
        }

        @Override
        public Object parseMessageFromBytes(ByteString bytes2, ExtensionRegistryLite registry, Descriptors.FieldDescriptor field2, Message defaultInstance) throws IOException {
            Message originalMessage;
            Message.Builder subBuilder = defaultInstance.newBuilderForType();
            if (!field2.isRepeated() && (originalMessage = (Message)this.getField(field2)) != null) {
                subBuilder.mergeFrom(originalMessage);
            }
            subBuilder.mergeFrom(bytes2, registry);
            return subBuilder.buildPartial();
        }

        @Override
        public MergeTarget newMergeTargetForField(Descriptors.FieldDescriptor descriptor2, Message defaultInstance) {
            throw new UnsupportedOperationException("newMergeTargetForField() called on FieldSet object");
        }

        @Override
        public Object readPrimitiveField(CodedInputStream input, WireFormat.FieldType type2, boolean checkUtf8) throws IOException {
            return FieldSet.readPrimitiveField(input, type2, checkUtf8);
        }

        @Override
        public Object finish() {
            throw new UnsupportedOperationException("finish() called on FieldSet object");
        }
    }

    static class BuilderAdapter
    implements MergeTarget {
        private final Message.Builder builder;

        public Descriptors.Descriptor getDescriptorForType() {
            return this.builder.getDescriptorForType();
        }

        public BuilderAdapter(Message.Builder builder) {
            this.builder = builder;
        }

        public Object getField(Descriptors.FieldDescriptor field2) {
            return this.builder.getField(field2);
        }

        public boolean hasField(Descriptors.FieldDescriptor field2) {
            return this.builder.hasField(field2);
        }

        public MergeTarget setField(Descriptors.FieldDescriptor field2, Object value2) {
            this.builder.setField(field2, value2);
            return this;
        }

        public MergeTarget clearField(Descriptors.FieldDescriptor field2) {
            this.builder.clearField(field2);
            return this;
        }

        public MergeTarget setRepeatedField(Descriptors.FieldDescriptor field2, int index2, Object value2) {
            this.builder.setRepeatedField(field2, index2, value2);
            return this;
        }

        public MergeTarget addRepeatedField(Descriptors.FieldDescriptor field2, Object value2) {
            this.builder.addRepeatedField(field2, value2);
            return this;
        }

        public boolean hasOneof(Descriptors.OneofDescriptor oneof) {
            return this.builder.hasOneof(oneof);
        }

        public MergeTarget clearOneof(Descriptors.OneofDescriptor oneof) {
            this.builder.clearOneof(oneof);
            return this;
        }

        public Descriptors.FieldDescriptor getOneofFieldDescriptor(Descriptors.OneofDescriptor oneof) {
            return this.builder.getOneofFieldDescriptor(oneof);
        }

        public MergeTarget.ContainerType getContainerType() {
            return MergeTarget.ContainerType.MESSAGE;
        }

        public ExtensionRegistry.ExtensionInfo findExtensionByName(ExtensionRegistry registry, String name2) {
            return registry.findImmutableExtensionByName(name2);
        }

        public ExtensionRegistry.ExtensionInfo findExtensionByNumber(ExtensionRegistry registry, Descriptors.Descriptor containingType, int fieldNumber) {
            return registry.findImmutableExtensionByNumber(containingType, fieldNumber);
        }

        public Object parseGroup(CodedInputStream input, ExtensionRegistryLite extensionRegistry, Descriptors.FieldDescriptor field2, Message defaultInstance) throws IOException {
            Message originalMessage;
            Message.Builder subBuilder = defaultInstance != null ? defaultInstance.newBuilderForType() : this.builder.newBuilderForField(field2);
            if (!field2.isRepeated() && (originalMessage = (Message)this.getField(field2)) != null) {
                subBuilder.mergeFrom(originalMessage);
            }
            input.readGroup(field2.getNumber(), subBuilder, extensionRegistry);
            return subBuilder.buildPartial();
        }

        public Object parseMessage(CodedInputStream input, ExtensionRegistryLite extensionRegistry, Descriptors.FieldDescriptor field2, Message defaultInstance) throws IOException {
            Message originalMessage;
            Message.Builder subBuilder = defaultInstance != null ? defaultInstance.newBuilderForType() : this.builder.newBuilderForField(field2);
            if (!field2.isRepeated() && (originalMessage = (Message)this.getField(field2)) != null) {
                subBuilder.mergeFrom(originalMessage);
            }
            input.readMessage(subBuilder, extensionRegistry);
            return subBuilder.buildPartial();
        }

        public Object parseMessageFromBytes(ByteString bytes2, ExtensionRegistryLite extensionRegistry, Descriptors.FieldDescriptor field2, Message defaultInstance) throws IOException {
            Message originalMessage;
            Message.Builder subBuilder = defaultInstance != null ? defaultInstance.newBuilderForType() : this.builder.newBuilderForField(field2);
            if (!field2.isRepeated() && (originalMessage = (Message)this.getField(field2)) != null) {
                subBuilder.mergeFrom(originalMessage);
            }
            subBuilder.mergeFrom(bytes2, extensionRegistry);
            return subBuilder.buildPartial();
        }

        public MergeTarget newMergeTargetForField(Descriptors.FieldDescriptor field2, Message defaultInstance) {
            if (defaultInstance != null) {
                return new BuilderAdapter(defaultInstance.newBuilderForType());
            }
            return new BuilderAdapter(this.builder.newBuilderForField(field2));
        }

        public Object readPrimitiveField(CodedInputStream input, WireFormat.FieldType type2, boolean checkUtf8) throws IOException {
            return FieldSet.readPrimitiveField(input, type2, checkUtf8);
        }

        public Object finish() {
            return this.builder.buildPartial();
        }
    }

    static interface MergeTarget {
        public Descriptors.Descriptor getDescriptorForType();

        public ContainerType getContainerType();

        public ExtensionRegistry.ExtensionInfo findExtensionByName(ExtensionRegistry var1, String var2);

        public ExtensionRegistry.ExtensionInfo findExtensionByNumber(ExtensionRegistry var1, Descriptors.Descriptor var2, int var3);

        public Object getField(Descriptors.FieldDescriptor var1);

        public boolean hasField(Descriptors.FieldDescriptor var1);

        public MergeTarget setField(Descriptors.FieldDescriptor var1, Object var2);

        public MergeTarget clearField(Descriptors.FieldDescriptor var1);

        public MergeTarget setRepeatedField(Descriptors.FieldDescriptor var1, int var2, Object var3);

        public MergeTarget addRepeatedField(Descriptors.FieldDescriptor var1, Object var2);

        public boolean hasOneof(Descriptors.OneofDescriptor var1);

        public MergeTarget clearOneof(Descriptors.OneofDescriptor var1);

        public Descriptors.FieldDescriptor getOneofFieldDescriptor(Descriptors.OneofDescriptor var1);

        public Object parseGroup(CodedInputStream var1, ExtensionRegistryLite var2, Descriptors.FieldDescriptor var3, Message var4) throws IOException;

        public Object parseMessage(CodedInputStream var1, ExtensionRegistryLite var2, Descriptors.FieldDescriptor var3, Message var4) throws IOException;

        public Object parseMessageFromBytes(ByteString var1, ExtensionRegistryLite var2, Descriptors.FieldDescriptor var3, Message var4) throws IOException;

        public Object readPrimitiveField(CodedInputStream var1, WireFormat.FieldType var2, boolean var3) throws IOException;

        public MergeTarget newMergeTargetForField(Descriptors.FieldDescriptor var1, Message var2);

        public Object finish();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ContainerType {
            MESSAGE,
            EXTENSION_SET;

        }
    }
}

