/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.stubs.KotlinCallableStubBase;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubBaseImplKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 \u0017*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0017B#\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0010\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\rH\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinStubBaseImpl;", "T", "Lorg/jetbrains/kotlin/psi/KtElementImplStub;", "Lcom/intellij/psi/stubs/StubBase;", "parent", "Lcom/intellij/psi/stubs/StubElement;", "elementType", "Lcom/intellij/psi/stubs/IStubElementType;", "(Lcom/intellij/psi/stubs/StubElement;Lcom/intellij/psi/stubs/IStubElementType;)V", "collectProperties", "", "Ljava/lang/reflect/Method;", "stubInterface", "Ljava/lang/Class;", "getPropertyName", "", "method", "renderProperty", "property", "renderPropertyValues", "", "", "toString", "Companion", "psi"})
public class KotlinStubBaseImpl<T extends KtElementImplStub<?>>
extends StubBase<T> {
    private static final Logger LOGGER;
    private static final List<Class<? extends NamedStub<?>>> BASE_STUB_INTERFACES;
    public static final Companion Companion;

    @NotNull
    public String toString() {
        Class<?> stubInterface;
        Class<?>[] classArray = ((Object)((Object)this)).getClass().getInterfaces();
        Intrinsics.checkExpressionValueIsNotNull(classArray, (String)"this::class.java.interfaces");
        Class<?>[] $this$single$iv = classArray;
        boolean $i$f$single = false;
        Class<?> single$iv = null;
        boolean found$iv = false;
        Class<?>[] classArray2 = $this$single$iv;
        int n = classArray2.length;
        for (int j = 0; j < n; ++j) {
            Class<?> element$iv;
            Class<?> it = element$iv = classArray2[j];
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Stub", (boolean)false, (int)2, null)) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Array contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
        }
        Class<?> clazz = stubInterface = single$iv;
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"stubInterface");
        List<String> propertiesValues = this.renderPropertyValues(clazz);
        if (propertiesValues.isEmpty()) {
            return KotlinStubBaseImplKt.getSTUB_TO_STRING_PREFIX() + this.getStubType();
        }
        String properties2 = CollectionsKt.joinToString$default((Iterable)propertiesValues, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
        return KotlinStubBaseImplKt.getSTUB_TO_STRING_PREFIX() + this.getStubType() + properties2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> renderPropertyValues(Class<? extends Object> stubInterface) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.collectProperties(stubInterface);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Method property2 = (Method)element$iv$iv;
            boolean bl2 = false;
            if (this.renderProperty(property2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Method> collectProperties(Class<?> stubInterface) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        ArrayList<Method> result2 = new ArrayList<Method>();
        Method[] methodArray = stubInterface.getDeclaredMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"stubInterface.declaredMethods");
        Method[] methodArray2 = methodArray;
        ArrayList<Method> arrayList = result2;
        boolean $i$f$filter = false;
        Class<?>[] classArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var8_10 = $this$filterTo$iv$iv;
        int n = ((void)var8_10).length;
        for (int j = 0; j < n; ++j) {
            Class<?>[] classArray2;
            void element$iv$iv;
            void it = element$iv$iv = var8_10[j];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (v1.getParameterTypes() == null) {
                Intrinsics.throwNpe();
            }
            boolean bl2 = false;
            if (!(classArray2.length == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        arrayList.addAll(list2);
        for (Class<?> baseInterface : stubInterface.getInterfaces()) {
            Iterable iterable = BASE_STUB_INTERFACES;
            Class<?> clazz = baseInterface;
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"baseInterface");
            if (!CollectionsKt.contains((Iterable)iterable, clazz)) continue;
            result2.addAll(this.collectProperties(baseInterface));
        }
        return result2;
    }

    private final String renderProperty(Method property2) {
        String string;
        try {
            Object value2 = property2.invoke((Object)this, new Object[0]);
            String name2 = this.getPropertyName(property2);
            string = name2 + '=' + value2;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            string = null;
        }
        return string;
    }

    private final String getPropertyName(Method method) {
        String methodName2;
        String string = method.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if (StringsKt.startsWith$default((String)(methodName2 = string), (String)"get", (boolean)false, (int)2, null)) {
            String string2 = methodName2;
            int n = 3;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            return StringsKt.decapitalize((String)string4);
        }
        return methodName2;
    }

    public KotlinStubBaseImpl(@Nullable StubElement<?> parent2, @NotNull IStubElementType<?, ?> elementType) {
        Intrinsics.checkParameterIsNotNull(elementType, (String)"elementType");
        super(parent2, elementType);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinStubBaseImpl.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(KotlinStubBaseImpl::class.java)");
        LOGGER = logger;
        BASE_STUB_INTERFACES = CollectionsKt.listOf((Object[])new Class[]{KotlinStubWithFqName.class, KotlinClassOrObjectStub.class, NamedStub.class, KotlinCallableStubBase.class});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinStubBaseImpl$Companion;", "", "()V", "BASE_STUB_INTERFACES", "", "Ljava/lang/Class;", "Lcom/intellij/psi/stubs/NamedStub;", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

