/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ImplicitNothingAsTypeParameterCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "SPECIAL_FUNCTION_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "kotlin.jvm.PlatformType", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ImplicitNothingAsTypeParameterCallChecker
implements CallChecker {
    private static final Set<Name> SPECIAL_FUNCTION_NAMES;
    public static final ImplicitNothingAsTypeParameterCallChecker INSTANCE;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        void $this$mapTo$iv$iv;
        ValueParameterDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Object resultingDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Object obj = resultingDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resultingDescriptor");
        KotlinType inferredReturnType = obj.getReturnType();
        Object obj2 = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj2, (String)"resolvedCall.resultingDescriptor");
        Object object = obj2.getDispatchReceiverParameter();
        boolean isBuiltinFunctionalType = object != null && (object = object.getValue()) != null && (object = object.getType()) != null && FunctionTypesKt.isBuiltinFunctionalType((KotlinType)object);
        if (inferredReturnType instanceof DeferredType) return;
        if (isBuiltinFunctionalType) {
            return;
        }
        if (SPECIAL_FUNCTION_NAMES.contains(resultingDescriptor.getName())) return;
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        if (!call2.getTypeArguments().isEmpty()) return;
        Object obj3 = resolvedCall2.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj3, (String)"resolvedCall.candidateDescriptor");
        List<ValueParameterDescriptor> list2 = obj3.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedCall.candidateDescriptor.valueParameters");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl = false;
            ValueParameterDescriptor valueParameterDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
            KotlinType kotlinType2 = valueParameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"it.type");
            if (!FunctionTypesKt.isFunctionType(kotlinType2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ValueParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ValueParameterDescriptor valueParameterDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
            Object object2 = valueParameterDescriptor.getReturnType();
            KotlinType kotlinType3 = object2 != null && (object2 = ((KotlinType)object2).getArguments()) != null && (object2 = (TypeProjection)CollectionsKt.last((List)object2)) != null ? object2.getType() : null;
            collection.add(kotlinType3);
        }
        Set lambdasFromArgumentsReturnTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        CallableDescriptor callableDescriptor = resultingDescriptor.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"resultingDescriptor.original");
        KotlinType unsubstitutedReturnType = callableDescriptor.getReturnType();
        KotlinType kotlinType4 = context2.getResolutionContext().expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"context.resolutionContext.expectedType");
        KotlinType expectedType = kotlinType4;
        KotlinType kotlinType5 = inferredReturnType;
        if (kotlinType5 == null) return;
        if (!TypeUtilsKt.isNothing(kotlinType5)) return;
        KotlinType kotlinType6 = unsubstitutedReturnType;
        if (kotlinType6 == null) return;
        if (!TypeUtilsKt.isTypeParameter(kotlinType6)) return;
        if (!TypeUtils.noExpectedType(expectedType)) {
            if (TypeUtilsKt.isNothing(expectedType)) return;
        }
        boolean bl = true;
        boolean hasImplicitNothing = bl;
        if (!hasImplicitNothing) return;
        if (lambdasFromArgumentsReturnTypes.contains(unsubstitutedReturnType)) return;
        context2.getTrace().report(Errors.IMPLICIT_NOTHING_AS_TYPE_PARAMETER.on(reportOn));
    }

    private ImplicitNothingAsTypeParameterCallChecker() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapTo$iv$iv;
        ImplicitNothingAsTypeParameterCallChecker implicitNothingAsTypeParameterCallChecker;
        INSTANCE = implicitNothingAsTypeParameterCallChecker = new ImplicitNothingAsTypeParameterCallChecker();
        ControlStructureTypingUtils.ResolveConstruct[] $this$map$iv = ControlStructureTypingUtils.ResolveConstruct.values();
        boolean $i$f$map = false;
        ControlStructureTypingUtils.ResolveConstruct[] resolveConstructArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        int n = ((void)var6_6).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = var6_6[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Name name2 = it.getSpecialFunctionName();
            collection.add(name2);
        }
        SPECIAL_FUNCTION_NAMES = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

