/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.platform;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.MultiTargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformConfigurator;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformConfigurator;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/platform/JvmPlatform;", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "()V", "defaultLowPriorityImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "getDefaultLowPriorityImports", "()Ljava/util/List;", "multiTargetPlatform", "Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform$Specific;", "getMultiTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform$Specific;", "platformConfigurator", "Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "getPlatformConfigurator", "()Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "computePlatformSpecificDefaultImports", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "result", "", "frontend.java"})
public final class JvmPlatform
extends TargetPlatform {
    @NotNull
    private static final List<ImportPath> defaultLowPriorityImports;
    @NotNull
    private static final PlatformConfigurator platformConfigurator;
    @NotNull
    private static final MultiTargetPlatform.Specific multiTargetPlatform;
    public static final JvmPlatform INSTANCE;

    @Override
    protected void computePlatformSpecificDefaultImports(@NotNull StorageManager storageManager, @NotNull List<ImportPath> result2) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        result2.add(ImportPath.Companion.fromString("kotlin.jvm.*"));
        Function1<MemberScope, Unit> $fun$addAllClassifiersFromScope$1 = new Function1<MemberScope, Unit>(result2){
            final /* synthetic */ List $result;

            public final void invoke(@NotNull MemberScope scope2) {
                Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
                for (DeclarationDescriptor descriptor2 : scope2.getContributedDescriptors(DescriptorKindFilter.CLASSIFIERS, MemberScope.Companion.getALL_NAME_FILTER())) {
                    FqName fqName2 = DescriptorUtils.getFqNameSafe(descriptor2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"DescriptorUtils.getFqNameSafe(descriptor)");
                    this.$result.add(new ImportPath(fqName2, false, null, 4, null));
                }
            }
            {
                this.$result = list2;
                super(1);
            }
        };
        for (PackageViewDescriptor builtInPackage : new JvmBuiltIns(storageManager, JvmBuiltIns.Kind.FROM_CLASS_LOADER).getBuiltInPackagesImportedByDefault()) {
            $fun$addAllClassifiersFromScope$1.invoke(builtInPackage.getMemberScope());
        }
    }

    @Override
    @NotNull
    public List<ImportPath> getDefaultLowPriorityImports() {
        return defaultLowPriorityImports;
    }

    @Override
    @NotNull
    public PlatformConfigurator getPlatformConfigurator() {
        return platformConfigurator;
    }

    @Override
    @NotNull
    public MultiTargetPlatform.Specific getMultiTargetPlatform() {
        return multiTargetPlatform;
    }

    private JvmPlatform() {
        super("JVM");
    }

    static {
        JvmPlatform jvmPlatform;
        INSTANCE = jvmPlatform = new JvmPlatform();
        defaultLowPriorityImports = CollectionsKt.listOf((Object)ImportPath.Companion.fromString("java.lang.*"));
        platformConfigurator = JvmPlatformConfigurator.INSTANCE;
        multiTargetPlatform = new MultiTargetPlatform.Specific(jvmPlatform.getPlatformName());
    }
}

