/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.JsLibrary;
import org.jetbrains.kotlin.utils.JsLibraryUtils;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0007J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/utils/KotlinJavascriptMetadataUtils;", "", "()V", "JS_EXT", "", "JS_MAP_EXT", "KOTLIN_JAVASCRIPT_METHOD_NAME", "KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN", "Ljava/util/regex/Pattern;", "METADATA_PATTERN", "META_JS_SUFFIX", "formatMetadataAsString", "moduleName", "content", "", "metadataVersion", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "hasMetadata", "", "text", "loadMetadata", "", "Lorg/jetbrains/kotlin/utils/KotlinJavascriptMetadata;", "file", "Ljava/io/File;", "path", "parseMetadata", "", "", "metadataList", "", "replaceSuffix", "filePath", "util"})
public final class KotlinJavascriptMetadataUtils {
    @NotNull
    public static final String JS_EXT = ".js";
    @NotNull
    public static final String META_JS_SUFFIX = ".meta.js";
    @NotNull
    public static final String JS_MAP_EXT = ".js.map";
    private static final String KOTLIN_JAVASCRIPT_METHOD_NAME = "kotlin_module_metadata";
    private static final Pattern KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN;
    private static final Pattern METADATA_PATTERN;
    public static final KotlinJavascriptMetadataUtils INSTANCE;

    @NotNull
    public final String replaceSuffix(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return StringsKt.substringBeforeLast$default((String)filePath, (String)JS_EXT, null, (int)2, null) + META_JS_SUFFIX;
    }

    @JvmStatic
    public static final boolean hasMetadata(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        return KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN.matcher(text2).find() && METADATA_PATTERN.matcher(text2).find();
    }

    @NotNull
    public final String formatMetadataAsString(@NotNull String moduleName2, @NotNull byte[] content2, @NotNull JsMetadataVersion metadataVersion) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName2, (String)"moduleName");
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)metadataVersion, (String)"metadataVersion");
        return "// Kotlin." + KOTLIN_JAVASCRIPT_METHOD_NAME + '(' + metadataVersion.toInteger() + ", \"" + moduleName2 + "\", " + '\"' + Base64.getEncoder().encodeToString(content2) + "\");\n";
    }

    @JvmStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@NotNull File file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        boolean bl = file2.exists();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Library " + file2 + " not found";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl2 = false;
        ArrayList metadataList = new ArrayList();
        JsLibraryUtils.traverseJsLibrary(file2, (Function1<? super JsLibrary, Unit>)((Function1)new Function1<JsLibrary, Unit>(metadataList){
            final /* synthetic */ ArrayList $metadataList;

            public final void invoke(@NotNull JsLibrary library2) {
                Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
                KotlinJavascriptMetadataUtils.parseMetadata(library2.getContent(), this.$metadataList);
            }
            {
                this.$metadataList = arrayList;
                super(1);
            }
        }));
        return metadataList;
    }

    @JvmStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@NotNull String path2) {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        return KotlinJavascriptMetadataUtils.loadMetadata(new File(path2));
    }

    @JvmStatic
    public static final void parseMetadata(@NotNull CharSequence text2, @NotNull List<KotlinJavascriptMetadata> metadataList) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull(metadataList, (String)"metadataList");
        if (!KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN.matcher(text2).find()) {
            return;
        }
        Matcher matcher2 = METADATA_PATTERN.matcher(text2);
        while (matcher2.find()) {
            String string;
            Intrinsics.checkExpressionValueIsNotNull((Object)matcher2.group(1), (String)"matcher.group(1)");
            JsMetadataVersion.Companion companion = JsMetadataVersion.Companion;
            boolean bl = false;
            int n = Integer.parseInt(string);
            JsMetadataVersion abiVersion = companion.fromInteger(n);
            String moduleName2 = matcher2.group(3);
            String data = matcher2.group(5);
            String string2 = moduleName2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"moduleName");
            byte[] byArray = Base64.getDecoder().decode(data);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().decode(data)");
            metadataList.add(new KotlinJavascriptMetadata(abiVersion, string2, byArray));
        }
    }

    private KotlinJavascriptMetadataUtils() {
    }

    static {
        KotlinJavascriptMetadataUtils kotlinJavascriptMetadataUtils;
        INSTANCE = kotlinJavascriptMetadataUtils = new KotlinJavascriptMetadataUtils();
        KOTLIN_JAVASCRIPT_METHOD_NAME = KOTLIN_JAVASCRIPT_METHOD_NAME;
        String string = "\\.kotlin_module_metadata\\(";
        int n = 0;
        boolean bl = false;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"java.util.regex.Pattern.compile(this, flags)");
        KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN = pattern;
        string = "(?m)\\w+\\." + KOTLIN_JAVASCRIPT_METHOD_NAME + "\\((\\d+),\\s*(['\"])([^'\"]*)\\2,\\s*(['\"])([^'\"]*)\\4\\)";
        n = 0;
        bl = false;
        Pattern pattern2 = Pattern.compile(string, n);
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern2, (String)"java.util.regex.Pattern.compile(this, flags)");
        METADATA_PATTERN = pattern2;
    }
}

