/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.repository.io.FileOp;
import com.android.repository.io.impl.FileOpImpl;
import java.io.File;

public class AndroidSysroot {
    private static String[] ourRequiredFiles = new String[]{"android/log.h"};
    private static String[] ourForbiddenFiles = new String[]{"objc/Object.h", "NSSystemDirectories.h", "MacTypes.h", "winsock.h", "winnt.h"};

    public static boolean isValidAndroidSysroot(File sysrootDirectory) {
        return AndroidSysroot.isValidAndroidSysroot(sysrootDirectory, (FileOp)new FileOpImpl());
    }

    public static boolean isValidAndroidSysrootUsrInclude(File includeDirectory) {
        return AndroidSysroot.isValidAndroidSysrootUsrInclude(includeDirectory, (FileOp)new FileOpImpl());
    }

    public static boolean isPotentialNonAndroidSysrootUsrInclude(File includeDirectory) {
        return AndroidSysroot.isPotentialNonAndroidSysrootUsrInclude(includeDirectory, (FileOp)new FileOpImpl());
    }

    static boolean isValidAndroidSysroot(File sysrootDirectory, FileOp fileOp) {
        File includeRoot = new File(sysrootDirectory, "usr/include");
        return AndroidSysroot.containsAllFiles(ourRequiredFiles, includeRoot, fileOp) && !AndroidSysroot.containsAtLeastOneFile(ourForbiddenFiles, includeRoot, fileOp);
    }

    static boolean isValidAndroidSysrootUsrInclude(File includeDirectory, FileOp fileOp) {
        return AndroidSysroot.containsAllFiles(ourRequiredFiles, includeDirectory, fileOp) && !AndroidSysroot.containsAtLeastOneFile(ourForbiddenFiles, includeDirectory, fileOp);
    }

    static boolean isPotentialNonAndroidSysrootUsrInclude(File includeDirectory, FileOp fileOp) {
        return AndroidSysroot.containsAtLeastOneFile(ourForbiddenFiles, includeDirectory, fileOp);
    }

    private static boolean containsAllFiles(String[] requiredFiles, File includeDirectory, FileOp fileOp) {
        for (String filename : requiredFiles) {
            File file = new File(includeDirectory, filename);
            if (fileOp.exists(file)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsAtLeastOneFile(String[] forbiddenFiles, File includeDirectory, FileOp fileOp) {
        for (String filename : forbiddenFiles) {
            File file = new File(includeDirectory, filename);
            if (!fileOp.exists(file)) continue;
            return true;
        }
        return false;
    }
}

