/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/ndk/ClangTidyInspection;", "Lcom/jetbrains/cidr/lang/inspections/ClangTidyInspection;", "()V", "createOptionsPanel", "Ljavax/swing/JComponent;", "getClangTidyChecks", "", "getDefaultChecksConfiguration", "", "getShortName", "getStaticDescription", "isEnabledByDefault", "", "removeExecutableHyperlink", "", "component", "Ljava/awt/Component;", "Companion", "android-ndk"})
public final class ClangTidyInspection
extends com.jetbrains.cidr.lang.inspections.ClangTidyInspection {
    @NotNull
    public static final String staticShortName = "ClangTidyInspection";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getClangTidyChecks() {
        return StringUtil.join((Collection)this.getDefaultChecksConfiguration(), (String)", ");
    }

    @NotNull
    public String getStaticDescription() {
        return "<html>\n<body>\nThis inspection performs checks related to core C++ modernization and readability guidelines, and performance-related issues. <br/>\nAndroid Studio's default configuration is described <a href=\"https://confluence.jetbrains.com/display/CLION/Clang-Tidy+in+CLion%3A+default+configuration\">here</a>. <br/>\nFor more information, please visit the official <a href=\"http://clang.llvm.org/extra/clang-tidy/\">Clang-Tidy</a> page.\n</body>\n</html>\n  ";
    }

    @NotNull
    public String getShortName() {
        return staticShortName;
    }

    private final List<String> getDefaultChecksConfiguration() {
        List<String> configuration2 = Arrays.asList("*", "android-*", "-bugprone-bool-pointer-implicit-conversion", "-cert-env33-c", "-cert-dcl50-cpp", "-cert-dcl59-cpp", "-cppcoreguidelines-no-malloc", "-cppcoreguidelines-owning-memory", "-cppcoreguidelines-pro-bounds-array-to-pointer-decay", "-cppcoreguidelines-pro-bounds-constant-array-index", "-cppcoreguidelines-pro-bounds-pointer-arithmetic", "-cppcoreguidelines-pro-type-const-cast", "-cppcoreguidelines-pro-type-cstyle-cast", "-cppcoreguidelines-pro-type-reinterpret-cast", "-cppcoreguidelines-pro-type-union-access", "-cppcoreguidelines-pro-type-vararg", "-cppcoreguidelines-special-member-functions", "-fuchsia-*", "-google-*", "google-default-arguments", "google-explicit-constructor", "google-runtime-member-string-references", "google-runtime-operator", "-hicpp-braces-around-statements", "-hicpp-named-parameter", "-hicpp-no-array-decay", "-hicpp-no-assembler", "-hicpp-no-malloc", "-hicpp-function-size", "-hicpp-special-member-functions", "-hicpp-vararg", "-llvm-*", "-objc-*", "-readability-else-after-return", "-readability-implicit-bool-conversion", "-readability-named-parameter", "-readability-simplify-boolean-expr", "-readability-braces-around-statements", "-readability-identifier-naming", "-readability-function-size", "-readability-redundant-member-init", "-misc-bool-pointer-implicit-conversion", "-misc-definitions-in-headers", "-misc-unused-alias-decls", "-misc-unused-parameters", "-misc-unused-using-decls", "-modernize-use-using", "-modernize-use-default-member-init", "-clang-diagnostic-*", "-clang-analyzer-*");
        return ContainerUtil.newUnmodifiableList(configuration2);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JComponent jComponent = super.createOptionsPanel();
        if (jComponent == null) {
            return null;
        }
        JComponent panel = jComponent;
        this.removeExecutableHyperlink(panel);
        return panel;
    }

    private final void removeExecutableHyperlink(Component component) {
        if (component instanceof JPanel) {
            Component[] $receiver$iv;
            Component[] componentArray = $receiver$iv = ((JPanel)component).getComponents();
            int n = componentArray.length;
            for (int i = 0; i < n; ++i) {
                Component element$iv;
                Component it = element$iv = componentArray[i];
                boolean bl = false;
                if (it instanceof HyperlinkLabel && StringsKt.contains$default((CharSequence)((HyperlinkLabel)it).getText(), (CharSequence)"executable", (boolean)false, (int)2, null)) {
                    ((JPanel)component).remove(it);
                    component.revalidate();
                    return;
                }
                this.removeExecutableHyperlink(it);
            }
        }
    }

    public ClangTidyInspection() {
        this.setClangTidyChecks(this.getClangTidyChecks());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/ndk/ClangTidyInspection$Companion;", "", "()V", "staticShortName", "", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

