/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0007\u001a\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0007\u00a8\u0006\n"}, d2={"findAncestorBarrierFolder", "", "barrierFolderPaths", "", "sourceFolderPath", "findCommonAncestorsWithRespectToBarrierFolders", "barrierFolderUrls", "sourceFolderUrls", "findDistinctBarrierFolders", "paths", "android-ndk"})
public final class ContentRootFinderKt {
    @VisibleForTesting
    @NotNull
    public static final Set<String> findDistinctBarrierFolders(@NotNull Set<String> paths) {
        Set result = new LinkedHashSet();
        for (String child : paths) {
            boolean hadParent = false;
            for (String parent : paths) {
                if (!FileUtil.isAncestor((String)parent, (String)child, (boolean)true)) continue;
                hadParent = true;
                break;
            }
            if (hadParent) continue;
            Collection collection = result;
            collection.add(child);
        }
        return result;
    }

    @VisibleForTesting
    @NotNull
    public static final String findAncestorBarrierFolder(@NotNull Set<String> barrierFolderPaths, @NotNull String sourceFolderPath) {
        for (String uncrossableRoot : barrierFolderPaths) {
            if (!FileUtil.isAncestor((String)uncrossableRoot, (String)sourceFolderPath, (boolean)false)) continue;
            return uncrossableRoot;
        }
        return sourceFolderPath;
    }

    @VisibleForTesting
    @NotNull
    public static final Set<String> findCommonAncestorsWithRespectToBarrierFolders(@NotNull Set<String> barrierFolderUrls, @NotNull Set<String> sourceFolderUrls) {
        Set<String> distinctBarrierFolderUrls = ContentRootFinderKt.findDistinctBarrierFolders(barrierFolderUrls);
        Map map2 = new LinkedHashMap();
        for (String sourceFolder : sourceFolderUrls) {
            String string;
            Map map3;
            String barrierFolder = ContentRootFinderKt.findAncestorBarrierFolder(distinctBarrierFolderUrls, sourceFolder);
            if (!map2.containsKey(barrierFolder)) {
                map3 = map2;
                string = sourceFolder;
                map3.put(barrierFolder, string);
                continue;
            }
            map3 = map2;
            File file = FileUtil.findAncestor((File)new File((String)map2.get(barrierFolder)), (File)new File(sourceFolder));
            if (file == null) {
                Intrinsics.throwNpe();
            }
            string = file.getPath();
            map3.put(barrierFolder, string);
        }
        return CollectionsKt.toSet((Iterable)map2.values());
    }
}

