/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.NdkVariant;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.project.NdkProjectInfo;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.ndk.ContentRootFinder;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.configuration.CxxResolveModuleConfigurationsKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceEventImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceFileMapper;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImplUtilKt;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackersImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleWorkspace
implements ProjectComponent {
    @NotNull
    private final Project myProject;
    private int myBatchLevel = 0;
    private boolean myUpdateNeeded = false;
    private boolean myCommitNeeded = false;

    @NotNull
    public static GradleWorkspace getInstance(@NotNull Project project) {
        GradleWorkspace instance = (GradleWorkspace)project.getComponent(GradleWorkspace.class);
        assert (instance != null);
        return instance;
    }

    public GradleWorkspace(@NotNull Project project) {
        this.myProject = project;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            OCLanguage.LANGUAGE_SUPPORT_DISABLED.set((UserDataHolder)project, (Object)true);
        }
        GradleSyncState.subscribe((Project)this.myProject, (GradleSyncListener)new GradleSyncListener(){

            public void syncSucceeded(@NotNull Project project) {
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            public void syncSkipped(@NotNull Project project) {
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }
        });
        BatchUpdateListener batchUpdateListener = new BatchUpdateListener(){

            public void onBatchUpdateFinished() {
                GradleWorkspace.this.myBatchLevel--;
                if (GradleWorkspace.this.myBatchLevel < 0) {
                    GradleWorkspace.getLog().error("Batch level lower than expected.");
                }
                GradleWorkspace.this.sendProjectUpdates();
            }

            public void onBatchUpdateStarted() {
                GradleWorkspace.this.myBatchLevel++;
            }
        };
        ModuleRootListener moduleRootListener = new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                GradleWorkspace.this.sendProjectUpdates();
            }
        };
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(BatchUpdateListener.TOPIC, (Object)batchUpdateListener);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)moduleRootListener);
        BuildVariantUpdater.getInstance((Project)project).addSelectionChangeListener(() -> this.scheduleGradleWorkspaceUpdate());
    }

    private void scheduleGradleWorkspaceUpdate() {
        this.myCommitNeeded = false;
        final OCWorkspace.ModifiableModel workspaceModel = OCWorkspace.getInstance((Project)this.myProject).getModifiableModel(true);
        new Task.Backgroundable(this.myProject, "Resolving C/C++ Configurations", false){

            public void run(@NotNull ProgressIndicator indicator) {
                GradleWorkspace.this.updateGradleWorkspace(indicator, workspaceModel);
            }

            public void onFinished() {
                super.onFinished();
                workspaceModel.dispose();
            }

            public void onSuccess() {
                super.onSuccess();
                if (GradleWorkspace.this.myCommitNeeded) {
                    workspaceModel.commit();
                }
            }
        }.queue();
    }

    private void updateGradleWorkspace(@NotNull ProgressIndicator indicator, @NotNull OCWorkspace.ModifiableModel workspaceModel) {
        boolean newDisableLanguageSupport;
        boolean isValidNdkProject;
        indicator.setIndeterminate(true);
        ArrayList<Module> nativeAppModules = new ArrayList<Module>();
        List<Module> modules = Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules());
        for (Module module : modules) {
            AndroidModuleModel androidModel = AndroidModuleModel.get((Module)module);
            NdkModuleModel ndkModel = NdkModuleModel.get((Module)module);
            if (ndkModel == null || androidModel == null) continue;
            nativeAppModules.add(module);
        }
        long started = System.currentTimeMillis();
        CxxResolveModuleConfigurationsKt.cxxResolveModuleConfigurations(this.myProject, indicator, modules, workspaceModel);
        workspaceModel.preCommit();
        this.myCommitNeeded = true;
        GradleWorkspace.getLog().info("Updating model took " + (double)(System.currentTimeMillis() - started) / 1000.0 + "s");
        boolean bl = isValidNdkProject = !nativeAppModules.isEmpty();
        if (isValidNdkProject) {
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_CPP_SYNC_COMPLETED), (Project)this.myProject));
        }
        boolean bl2 = newDisableLanguageSupport = !isValidNdkProject;
        if ((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)this.myProject, (Object)false) != newDisableLanguageSupport) {
            NdkHelper.disableCppLanguageSupport(this.myProject, newDisableLanguageSupport);
            if (newDisableLanguageSupport) {
                GradleWorkspace.getLog().warn("NDK support for project '" + this.myProject.getName() + "' is disabled because the project doesn't contain any valid native configurations.");
            }
        }
        NdkProjectInfo projectInfo = NdkProjectInfo.get((Project)this.myProject);
        projectInfo.setHasNdkModules(!nativeAppModules.isEmpty());
        if (projectInfo.hasNdkModules()) {
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> this.updateContentRoots());
                ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(() -> {}, false, true);
            }));
            this.myUpdateNeeded = true;
            if (this.myBatchLevel == 0) {
                this.sendProjectUpdates();
            }
        }
    }

    private void sendProjectUpdates() {
        if (this.myBatchLevel != 0 || !this.myUpdateNeeded) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            OCWorkspaceModificationTrackersImpl trackers = (OCWorkspaceModificationTrackersImpl)OCWorkspace.getInstance((Project)this.myProject).getModificationTrackers();
            trackers.fireWorkspaceChanged((OCWorkspaceListener.OCWorkspaceEvent)new OCWorkspaceEventImpl(true, true, true));
        }), ModalityState.NON_MODAL);
        this.myUpdateNeeded = false;
    }

    private void updateContentRoots() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        OCWorkspaceFileMapper fileMapper = OCWorkspaceImplUtilKt.createFileMapper();
        for (Module module : moduleManager.getModules()) {
            NdkModuleModel ndkModel = NdkModuleModel.get((Module)module);
            if (ndkModel == null) continue;
            ContentRootFinder rootFinder = new ContentRootFinder(new String[0]);
            rootFinder.addBarrierFolder(ProjectUtil.guessProjectDir((Project)this.myProject));
            rootFinder.addParentAsBarrierFolder(module.getModuleFile());
            for (File buildFile : ndkModel.getAndroidProject().getBuildFiles()) {
                rootFinder.addParentAsBarrierFolder(buildFile);
            }
            for (NdkVariant variant : ndkModel.getVariants()) {
                for (NativeArtifact artifact : variant.getArtifacts()) {
                    for (NativeFile nativeFile : artifact.getSourceFiles()) {
                        rootFinder.addParentAsSourceFolder(nativeFile.getFilePath());
                    }
                }
            }
            for (String rootUrl : rootFinder.roots()) {
                VirtualFile virtualFile = fileMapper.map(new File(rootUrl));
                if (virtualFile == null) continue;
                ModuleRootModificationUtil.updateModel((Module)module, model -> {
                    VirtualFile contentRootForFile = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(virtualFile);
                    ContentEntry entry = null;
                    if (contentRootForFile != null) {
                        for (ContentEntry contentEntry : model.getContentEntries()) {
                            if (!contentEntry.getUrl().equals(contentRootForFile.getUrl())) continue;
                            entry = contentEntry;
                            break;
                        }
                        if (entry == null) {
                            for (ContentEntry contentEntry : model.getContentRoots()) {
                                if (!FileUtil.isAncestor((String)contentEntry.getUrl(), (String)contentRootForFile.getUrl(), (boolean)true)) continue;
                                entry = model.addContentEntry((VirtualFile)contentEntry);
                                break;
                            }
                        }
                    }
                    if (entry != null) {
                        GradleWorkspace.getLog().debug("Adding " + virtualFile.toString() + " as a source folder of " + entry.getUrl());
                        entry.addSourceFolder(virtualFile, false);
                    } else {
                        entry = model.addContentEntry(virtualFile);
                        entry.addSourceFolder(virtualFile, false);
                        GradleWorkspace.getLog().debug("Could not find content root for " + virtualFile.toString() + " to add it as a source folder.  Creating content root instead.");
                    }
                });
            }
        }
    }

    public boolean isNativeModule(@NotNull Module module) {
        AndroidModuleModel androidModel = AndroidModuleModel.get((Module)module);
        NdkModuleModel ndkModel = NdkModuleModel.get((Module)module);
        if (ndkModel != null) {
            return androidModel != null;
        }
        return false;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(GradleWorkspace.class);
    }
}

