/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.sdklib.devices.Abi;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulePathManager {
    private static final Map<Abi, Abi> ABI_MAPPINGS = Collections.singletonMap(Abi.ARMEABI_V7A, Abi.ARMEABI);

    @NotNull
    public static File getLldbCommonFile(@NotNull String relativePath) {
        if (PluginManagerCore.isRunningFromSources()) {
            return Paths.get(PathManager.getHomePath(), "../../prebuilts/tools/common/lldb", relativePath).toFile();
        }
        return new File(ModulePathManager.getShippedLldbDirectory(), relativePath);
    }

    private static File getShippedLldbDirectory() {
        return Paths.get(PathManager.getBinPath(), "lldb").toFile();
    }

    private static File getDevLldbOsDirectory() {
        String os;
        if (SystemInfo.isLinux) {
            os = "linux-x86_64";
        } else if (SystemInfo.isMac) {
            os = "darwin-x86_64";
        } else if (SystemInfo.isWindows) {
            os = "windows-x86_64";
        } else {
            throw new IllegalStateException("Unknown operating system");
        }
        return Paths.get(PathManager.getHomePath(), "../../prebuilts/tools", os, "lldb").toFile();
    }

    @NotNull
    public static File getLldbHostDir() {
        if (PluginManagerCore.isRunningFromSources()) {
            return ModulePathManager.getDevLldbOsDirectory();
        }
        return ModulePathManager.getShippedLldbDirectory();
    }

    @NotNull
    public static File getLldbHostFile(@NotNull String relativePath) {
        return new File(ModulePathManager.getLldbHostDir(), relativePath);
    }

    @NotNull
    public static File getLldbPythonHome() {
        String pythonOsDir;
        if (SystemInfo.isLinux) {
            pythonOsDir = "linux-x86";
        } else if (SystemInfo.isWindows) {
            pythonOsDir = "windows-x86";
        } else {
            throw new IllegalStateException("getLldbPythonHome should not be called for darwin");
        }
        if (PluginManagerCore.isRunningFromSources()) {
            return Paths.get(PathManager.getHomePath(), "../../prebuilts/python", pythonOsDir).toFile();
        }
        return ModulePathManager.getShippedLldbDirectory();
    }

    @NotNull
    public static File getLldbAndroidFile(@NotNull String relativePath) {
        return new File(ModulePathManager.getLldbCommonFile("android"), relativePath);
    }

    @NotNull
    public static File getLldbSharedFile(@NotNull String relativePath) {
        return new File(ModulePathManager.getLldbCommonFile("shared"), relativePath);
    }

    @Nullable
    public static File findLLDBServer(@NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull List<Abi> abis) {
        File foundServerFile = null;
        for (Abi abi : abis) {
            File serverFile = ModulePathManager.getServerFileByAbi(abi);
            if (serverFile != null) {
                foundServerFile = serverFile;
            }
            if (AndroidNativeAppDebugProcess.getSymbolsDir(facet, debuggerState, Collections.singletonList(abi)).isEmpty()) continue;
            return serverFile;
        }
        return foundServerFile;
    }

    @Nullable
    private static File getServerFileByAbi(@NotNull Abi abi) {
        File lldbServerFile = ModulePathManager.getAndroidLldbBinFile(abi);
        if (lldbServerFile.exists()) {
            return lldbServerFile;
        }
        Abi mappedAbi = ABI_MAPPINGS.get(abi);
        if (mappedAbi != null && (lldbServerFile = ModulePathManager.getAndroidLldbBinFile(mappedAbi)).exists()) {
            return lldbServerFile;
        }
        return null;
    }

    @NotNull
    private static File getAndroidLldbBinFile(Abi abi) {
        return ModulePathManager.getLldbAndroidFile(new File(abi.toString(), "lldb-server").getPath());
    }

    @NotNull
    public static File getRepoLLDBStlPrintersFolder() {
        return ModulePathManager.getLldbSharedFile("stl_printers");
    }

    @NotNull
    public static File getRepoLLDBStlPrintersBinFile(@NotNull String relativePath) {
        return new File(ModulePathManager.getRepoLLDBStlPrintersFolder(), relativePath);
    }

    @NotNull
    public static File getRepoLLDBPrettyPrinterScriptsFolder() {
        return ModulePathManager.getLldbSharedFile("jobject_printers");
    }
}

