/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.jni.JniInspectionTool;
import com.android.tools.ndk.jni.JniLocalQuickFix;
import com.android.tools.ndk.jni.MethodInfo;
import com.android.tools.ndk.jni.NativeMethodInfo;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/ndk/jni/JniFunctionExternInspection;", "Lcom/android/tools/ndk/jni/JniInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "android-ndk"})
public final class JniFunctionExternInspection
extends JniInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new PsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@Nullable PsiElement element) {
                MethodInfo methodInfo = MethodInfo.Companion.fromPsiElement(element, false);
                if (!(methodInfo instanceof NativeMethodInfo)) {
                    methodInfo = null;
                }
                NativeMethodInfo nativeMethodInfo = (NativeMethodInfo)methodInfo;
                if (nativeMethodInfo == null) {
                    return;
                }
                NativeMethodInfo nativeMethodInfo2 = nativeMethodInfo;
                if (nativeMethodInfo2.isCpp() && Intrinsics.areEqual((Object)nativeMethodInfo2.getPsiElement().getNode().getTreeParent().getElementType(), (Object)OCElementTypes.CPP_LINKAGE_SPECIFICATION) ^ true) {
                    PsiElement psiElement = nativeMethodInfo2.getPsiElement().getNameIdentifier();
                    if (psiElement == null) {
                        psiElement = (PsiElement)nativeMethodInfo2.getPsiElement();
                    }
                    this.$holder.registerProblem(psiElement, "This JNI function call may be using an incorrect linkage.", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new JniLocalQuickFix(JniInspectionEvent.JniInspectionType.EXTERN_C_INSPECTION_EVENT){

                        @NotNull
                        public String getFamilyName() {
                            return "Add extern \"C\"";
                        }

                        public boolean apply(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                            OCFunctionDeclaration oCFunctionDeclaration = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), OCFunctionDeclaration.class);
                            if (oCFunctionDeclaration == null) {
                                return false;
                            }
                            PsiElement elementToFix = (PsiElement)oCFunctionDeclaration;
                            if (elementToFix.getPrevSibling() instanceof OCMacroCall) {
                                elementToFix = elementToFix.getPrevSibling();
                            }
                            OCChangeUtil.changeText((Project)project, (PsiFile)elementToFix.getContainingFile(), (int)elementToFix.getTextRange().getStartOffset(), (int)0, (String)" extern \"C\" ", (boolean)true);
                            return true;
                        }
                    }});
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

