/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.jni.JniInspectionTool;
import com.android.tools.ndk.jni.JniLocalQuickFix;
import com.android.tools.ndk.jni.JniMethodResolver;
import com.android.tools.ndk.jni.JvmMethodInfo;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.PsiNavigateUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelperUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniMissingFunctionInspection
extends JniInspectionTool {
    private static final String REGISTER_NATIVES = "RegisterNatives";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (!NdkHelper.isNdkProject(holder.getProject())) {
            return super.buildVisitor(holder, isOnTheFly, session);
        }
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                if (!method.hasModifierProperty("native") || OCGlobalProjectSymbolsCache.getAllSymbolNames((Project)method.getProject()).isEmpty()) {
                    return;
                }
                JvmMethodInfo jvmMethodInfo = JvmMethodInfo.fromJavaMethod(method);
                if (jvmMethodInfo == null) {
                    return;
                }
                if (JniMethodResolver.getInstance(method.getProject()).resolveJavaOrKotlinMethod(jvmMethodInfo).stream().anyMatch(it -> it.isDefinition())) {
                    return;
                }
                Project project = holder.getProject();
                if (JniMissingFunctionInspection.projectUsesRegisterNatives(project)) {
                    return;
                }
                String jniMethodName = jvmMethodInfo.toNativeMethodId().toJniMethodName();
                String message = String.format("Cannot resolve corresponding JNI function %1$s", jniMethodName);
                LocalQuickFix[] fixes = new LocalQuickFix[]{new CreateJniFunctionFix(jvmMethodInfo)};
                holder.registerProblem((PsiElement)(method.getNameIdentifier() != null ? method.getNameIdentifier() : method), message, ProblemHighlightType.ERROR, fixes);
            }
        };
    }

    private static boolean projectUsesRegisterNatives(Project project) {
        Ref registersNatives = new Ref((Object)false);
        OCGlobalProjectSymbolsCache.processByQualifiedName((Project)project, symbol -> {
            PsiElement definition;
            if (symbol.getKind() == OCSymbolKind.STRUCT_FIELD) {
                PsiElement definition2;
                OCFile containingOCFile = symbol.getContainingOCFile(project);
                if (containingOCFile != null && (symbol = containingOCFile.findSymbol(REGISTER_NATIVES, OCSymbolWithQualifiedName.class)) != null && (definition2 = symbol.locateDefinition(project)) != null) {
                    GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)definition2.getProject());
                    Collection all = ReferencesSearch.search((PsiElement)definition2.getParent(), (SearchScope)scope).findAll();
                    if (!all.isEmpty()) {
                        registersNatives.set((Object)true);
                    }
                }
            } else if ((symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol.getKind() == OCSymbolKind.FUNCTION_PREDECLARATION) && (definition = symbol.locateDefinition(project)) != null) {
                GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)definition.getProject());
                Collection all = ReferencesSearch.search((PsiElement)definition.getParent(), (SearchScope)scope).findAll();
                if (!all.isEmpty()) {
                    registersNatives.set((Object)true);
                }
            }
            return true;
        }, (String)REGISTER_NATIVES);
        return (Boolean)registersNatives.get();
    }

    static class CreateJniFunctionFix
    extends JniLocalQuickFix {
        private final JvmMethodInfo myJvmMethodInfo;

        CreateJniFunctionFix(JvmMethodInfo jvmMethodInfo) {
            super(JniInspectionEvent.JniInspectionType.MISSING_FUNCTION_INSPECTION_EVENT);
            this.myJvmMethodInfo = jvmMethodInfo;
        }

        @NotNull
        public String getName() {
            return String.format("Create JNI function for %1$s", this.myJvmMethodInfo.getMethodName());
        }

        @NotNull
        public String getFamilyName() {
            return "Create JNI function";
        }

        @Override
        public boolean apply(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            OCFile file = this.findJniTargetFile(project);
            if (file == null) {
                Logger.getInstance(JniMissingFunctionInspection.class).warn("Can't create JNI file");
                return false;
            }
            OCLanguageKind kind = OCLanguageKindCalculator.calculateLanguageKind((OCFile)file);
            this.createMethod(project, file, kind == CLanguageKind.CPP);
            return true;
        }

        private void createMethod(@NotNull Project project, @NotNull OCFile file, boolean cpp) {
            String text = this.myJvmMethodInfo.generateNativeMethod(cpp);
            PsiElement declaration = OCElementFactory.topLevelDeclarationFromText((String)text, (PsiElement)file, (boolean)true);
            PsiElement added = OCChangeUtil.add((PsiElement)file, (PsiElement)declaration);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.doPostponedOperationsAndUnblockDocument(documentManager.getDocument((PsiFile)file));
            OCChangeUtil.reformatTextIfNotInjected((PsiFile)file, (int)added.getTextOffset(), (int)(added.getTextOffset() + added.getTextLength()));
            Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)added, PsiComment.class);
            if (!comments.isEmpty()) {
                PsiComment firstComment = (PsiComment)comments.iterator().next();
                PsiNavigateUtil.navigate((PsiElement)firstComment);
                TextRange textRange = firstComment.getTextRange();
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                if (editor != null) {
                    editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                }
            } else {
                Collection functions = PsiTreeUtil.findChildrenOfType((PsiElement)added, OCFunctionDeclaration.class);
                if (!functions.isEmpty()) {
                    OCFunctionDeclaration first = (OCFunctionDeclaration)functions.iterator().next();
                    PsiNavigateUtil.navigate((PsiElement)first);
                } else {
                    PsiNavigateUtil.navigate((PsiElement)added);
                }
            }
        }

        @Nullable
        private OCFile findJniTargetFile(Project project) {
            OCFile existing = CreateJniFunctionFix.findFileWithJniFunctions(project);
            if (existing != null) {
                return existing;
            }
            return this.createNewTargetFile(project);
        }

        @Nullable
        private AndroidFacet pickModule() {
            AndroidFacet facet;
            Module module = AndroidPsiUtils.getModuleSafely((PsiElement)this.myJvmMethodInfo.getPsiElement());
            if (module != null && (facet = AndroidFacet.getInstance((Module)module)) != null) {
                return facet;
            }
            for (Module m : ModuleManager.getInstance((Project)this.myJvmMethodInfo.getPsiElement().getProject()).getModules()) {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)m);
                if (facet2 == null) continue;
                return facet2;
            }
            return null;
        }

        @Nullable
        private OCFile createNewTargetFile(@NotNull Project project) {
            PsiFile file;
            AndroidFacet facet = this.pickModule();
            if (facet == null) {
                return null;
            }
            VirtualFile dir = null;
            PsiDirectory psiDirectory = null;
            if (((AndroidFacetConfiguration)facet.getConfiguration()).getModel() != null) {
                File dirFile;
                SourceProvider provider = facet.getMainSourceProvider();
                File file2 = provider.getCppDirectories().iterator().hasNext() ? (File)provider.getCppDirectories().iterator().next() : (dirFile = provider.getCDirectories().iterator().hasNext() ? (File)provider.getCDirectories().iterator().next() : null);
                if (dirFile != null) {
                    dir = LocalFileSystem.getInstance().findFileByIoFile(dirFile);
                    if (dir == null) {
                        psiDirectory = DirectoryUtil.mkdirs((PsiManager)PsiManager.getInstance((Project)project), (String)FileUtil.toSystemIndependentName((String)dirFile.getPath()));
                        if (psiDirectory != null) {
                            dir = psiDirectory.getVirtualFile();
                        }
                    } else {
                        psiDirectory = PsiManager.getInstance((Project)project).findDirectory(dir);
                    }
                }
            }
            if (dir == null || psiDirectory == null) {
                return null;
            }
            String fileName = this.pickFilename();
            VirtualFile newFile = dir.findChild(fileName);
            if (newFile == null) {
                OCNewFileHelperUtil.addCreatedFiles((PsiDirectory)psiDirectory, (String[])new String[]{fileName}, (PsiFile[])new PsiFile[]{null}, (Project)project, (Function)Function.NULL);
                newFile = dir.findChild(fileName);
                if (newFile == null) {
                    return null;
                }
                try {
                    VfsUtil.saveText((VirtualFile)newFile, (String)"#include <jni.h>\n");
                }
                catch (IOException ioe) {
                    Logger.getInstance(JniMissingFunctionInspection.class).error((Throwable)ioe);
                    return null;
                }
            }
            if ((file = PsiManager.getInstance((Project)project).findFile(newFile)) instanceof OCFile) {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                Document document = documentManager.getDocument(file);
                if (document != null) {
                    documentManager.commitDocument(document);
                }
                return (OCFile)file;
            }
            return null;
        }

        @NotNull
        private String pickFilename() {
            PsiFile containingFile = this.myJvmMethodInfo.getPsiElement().getContainingFile();
            if (containingFile != null) {
                for (PsiMethodCallExpression expression : PsiTreeUtil.findChildrenOfType((PsiElement)containingFile, PsiMethodCallExpression.class)) {
                    PsiLiteralExpression literal;
                    Object value;
                    PsiExpression[] argumentList;
                    String qualifiedName;
                    PsiMethod method;
                    PsiClass cls;
                    PsiElement resolved;
                    PsiReferenceExpression methodExpression = expression.getMethodExpression();
                    String referenceName = methodExpression.getReferenceName();
                    if (!"loadLibrary".equals(referenceName) || (resolved = methodExpression.resolve()) instanceof PsiMethod && (cls = (method = (PsiMethod)resolved).getContainingClass()) != null && (qualifiedName = cls.getQualifiedName()) != null && !qualifiedName.equals("java.lang.System") || (argumentList = expression.getArgumentList().getExpressions()).length != 1 || !(argumentList[0] instanceof PsiLiteralExpression) || !((value = (literal = (PsiLiteralExpression)argumentList[0]).getValue()) instanceof String)) continue;
                    String name = (String)value;
                    StringBuilder sb = new StringBuilder();
                    int n = name.length();
                    for (int i = 0; i < n; ++i) {
                        char c = name.charAt(i);
                        if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_' && c != '-') continue;
                        sb.append(c);
                    }
                    if (sb.length() <= 0) continue;
                    sb.append(".c");
                    return sb.toString();
                }
            }
            return this.myJvmMethodInfo.getClassName().getShortName().toLowerCase(Locale.US) + ".c";
        }

        @Nullable
        private static OCFile findFileWithJniFunctions(@NotNull Project project) {
            Ref ref = new Ref();
            for (String symbol : OCGlobalProjectSymbolsCache.getAllSymbolNames((Project)project)) {
                if (!symbol.startsWith("Java_")) continue;
                Processor processor = symbol1 -> {
                    OCFile containing;
                    if ((symbol1.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol1.getKind() == OCSymbolKind.FUNCTION_PREDECLARATION) && (containing = symbol1.getContainingOCFile(project)) != null) {
                        ref.set((Object)containing);
                        return false;
                    }
                    return true;
                };
                OCGlobalProjectSymbolsCache.processTopLevelSymbols((Project)project, (Processor)processor, (String)symbol);
                OCFile file = (OCFile)ref.get();
                if (file == null) continue;
                return file;
            }
            return null;
        }
    }
}

