/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.jni.JniInspectionTool;
import com.android.tools.ndk.jni.JniLocalQuickFix;
import com.android.tools.ndk.jni.JniOnloadInspection;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/ndk/jni/JniOnloadInspection;", "Lcom/android/tools/ndk/jni/JniInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectDeclaration", "", "declarator", "Lcom/jetbrains/cidr/lang/psi/OCFunctionDeclaration;", "returnTypeName", "", "android-ndk"})
public final class JniOnloadInspection
extends JniInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ JniOnloadInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@Nullable PsiElement element) {
                PsiElement psiElement = element;
                if (!(psiElement instanceof OCFunctionDeclaration)) {
                    psiElement = null;
                }
                OCFunctionDeclaration oCFunctionDeclaration = (OCFunctionDeclaration)psiElement;
                if (oCFunctionDeclaration == null) {
                    return;
                }
                OCFunctionDeclaration declarator = oCFunctionDeclaration;
                String string = declarator.getName();
                if (string != null) {
                    switch (string) {
                        case "JNI_OnLoad": {
                            JniOnloadInspection.access$inspectDeclaration(this.this$0, declarator, this.$holder, "jint");
                            break;
                        }
                        case "JNI_OnUnload": {
                            JniOnloadInspection.access$inspectDeclaration(this.this$0, declarator, this.$holder, "void");
                        }
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final void inspectDeclaration(OCFunctionDeclaration declarator, ProblemsHolder holder, String returnTypeName) {
        Integer n;
        if (!declarator.getReturnType().equalsAfterResolving(returnTypeName, OCResolveContext.forPsi((PsiElement)((PsiElement)declarator)))) {
            OCTypeElement oCTypeElement = declarator.getReturnTypeElement();
            OCElement elementToShow = oCTypeElement != null ? (OCElement)oCTypeElement : (OCElement)declarator;
            holder.registerProblem((PsiElement)elementToShow, "Wrong type", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new JniLocalQuickFix(returnTypeName, declarator, JniInspectionEvent.JniInspectionType.ONLOAD_INSPECTION_EVENT){
                final /* synthetic */ String $returnTypeName;
                final /* synthetic */ OCFunctionDeclaration $declarator;

                @NotNull
                public String getFamilyName() {
                    return "Fix type";
                }

                @NotNull
                public String getName() {
                    return "Change return type to '" + this.$returnTypeName + '\'';
                }

                public boolean apply(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (this.$declarator.getReturnTypeElement() != null) {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(this, project){
                            final /* synthetic */ inspectDeclaration.1 this$0;
                            final /* synthetic */ Project $project;

                            public final void run() {
                                OCTypeElement oCTypeElement = this.this$0.$declarator.getReturnTypeElement();
                                if (oCTypeElement == null) {
                                    return;
                                }
                                OCTypeElement elementToChange = oCTypeElement;
                                OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.this$0.$declarator.getContainingFile(), (int)elementToChange.getTextOffset(), (int)elementToChange.getTextLength(), (String)this.this$0.$returnTypeName, (boolean)true);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$project = project;
                            }
                        });
                        return true;
                    }
                    return false;
                }
                {
                    this.$returnTypeName = $captured_local_variable$0;
                    this.$declarator = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            }});
        }
        List list = declarator.getParameters();
        Integer n2 = n = list != null ? Integer.valueOf(list.size()) : null;
        if (n2 != null && n2 == 0) {
            holder.registerProblem((PsiElement)declarator, "Not enough parameters", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new JniLocalQuickFix(declarator, JniInspectionEvent.JniInspectionType.ONLOAD_INSPECTION_EVENT){
                final /* synthetic */ OCFunctionDeclaration $declarator;

                @NotNull
                public String getName() {
                    return "Add parameters";
                }

                @NotNull
                public String getFamilyName() {
                    return "Add parameters";
                }

                public boolean apply(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(this, project){
                        final /* synthetic */ inspectDeclaration.2 this$0;
                        final /* synthetic */ Project $project;

                        public final void run() {
                            OCParameterList oCParameterList = this.this$0.$declarator.getParameterList();
                            if (oCParameterList == null) {
                                return;
                            }
                            int textOffset = oCParameterList.getTextOffset();
                            OCParameterList oCParameterList2 = this.this$0.$declarator.getParameterList();
                            if (oCParameterList2 == null) {
                                return;
                            }
                            int textLength = oCParameterList2.getTextLength();
                            OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.this$0.$declarator.getContainingFile(), (int)textOffset, (int)textLength, (String)"(JavaVM* vm, void* unused)", (boolean)true);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$project = project;
                        }
                    });
                    return true;
                }
                {
                    this.$declarator = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }});
        } else {
            Integer n3 = n;
            if (n3 != null && n3 == 1) {
                OCParameterList oCParameterList = declarator.getParameterList();
                if (oCParameterList == null) {
                    return;
                }
                OCParameterList parameterList = oCParameterList;
                holder.registerProblem((PsiElement)parameterList, "Not enough parameters", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new JniLocalQuickFix(parameterList, declarator, JniInspectionEvent.JniInspectionType.ONLOAD_INSPECTION_EVENT){
                    final /* synthetic */ OCParameterList $parameterList;
                    final /* synthetic */ OCFunctionDeclaration $declarator;

                    @NotNull
                    public String getName() {
                        return "Add parameters";
                    }

                    @NotNull
                    public String getFamilyName() {
                        return "Add parameters";
                    }

                    public boolean apply(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(this, project){
                            final /* synthetic */ inspectDeclaration.3 this$0;
                            final /* synthetic */ Project $project;

                            public final void run() {
                                int textOffset = this.this$0.$parameterList.getTextOffset();
                                int textLength = this.this$0.$parameterList.getTextLength();
                                Object object = this.this$0.$declarator.getParameters();
                                if (object == null || (object = (OCDeclarator)object.get(0)) == null || (object = object.getName()) == null) {
                                    object = "vm";
                                }
                                Object parameterName = object;
                                OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.this$0.$declarator.getContainingFile(), (int)textOffset, (int)textLength, (String)("(JavaVM * " + (String)parameterName + ", void* unused)"), (boolean)true);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$project = project;
                            }
                        });
                        return true;
                    }
                    {
                        this.$parameterList = $captured_local_variable$0;
                        this.$declarator = $captured_local_variable$1;
                        super($super_call_param$2);
                    }
                }});
            } else {
                Integer n4 = n;
                if (n4 != null && n4 == 2) {
                    List list2;
                    List typeNameElement;
                    List list3 = declarator.getParameters();
                    if (list3 != null && (list3 = (OCDeclarator)list3.get(0)) != null && (list3 = list3.getType()) != null) {
                        if (!list3.equalsAfterResolving("JavaVM *", OCResolveContext.forPsi((PsiElement)((PsiElement)declarator)))) {
                            List list4 = declarator.getParameters();
                            if (list4 == null || (list4 = (OCDeclarator)list4.get(0)) == null) {
                                return;
                            }
                            typeNameElement = list4;
                            holder.registerProblem((PsiElement)typeNameElement, "Wrong type", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{new JniLocalQuickFix((OCDeclarator)typeNameElement, JniInspectionEvent.JniInspectionType.ONLOAD_INSPECTION_EVENT){
                                final /* synthetic */ OCDeclarator $typeNameElement;

                                @NotNull
                                public String getName() {
                                    return "Change type to JavaVM *";
                                }

                                @NotNull
                                public String getFamilyName() {
                                    return "Change type";
                                }

                                public boolean apply(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                    ApplicationManager.getApplication().runWriteAction(new Runnable(this, project){
                                        final /* synthetic */ inspectDeclaration.4 this$0;
                                        final /* synthetic */ Project $project;

                                        public final void run() {
                                            String varName = this.this$0.$typeNameElement.getName();
                                            OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.this$0.$typeNameElement.getContainingFile(), (int)this.this$0.$typeNameElement.getParent().getTextOffset(), (int)this.this$0.$typeNameElement.getParent().getTextLength(), (String)("JavaVM *" + varName), (boolean)true);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            this.$project = project;
                                        }
                                    });
                                    return true;
                                }
                                {
                                    this.$typeNameElement = $captured_local_variable$0;
                                    super($super_call_param$1);
                                }
                            }});
                        }
                    }
                    if ((list2 = declarator.getParameters()) != null && (list2 = (OCDeclarator)list2.get(1)) != null && (list2 = list2.getType()) != null) {
                        if (!list2.equalsAfterResolving("void *", OCResolveContext.forPsi((PsiElement)((PsiElement)declarator)))) {
                            List list5 = declarator.getParameters();
                            if (list5 == null || (list5 = (OCDeclarator)list5.get(1)) == null) {
                                return;
                            }
                            typeNameElement = list5;
                            holder.registerProblem((PsiElement)typeNameElement, "Wrong type", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{new JniLocalQuickFix((OCDeclarator)typeNameElement, JniInspectionEvent.JniInspectionType.ONLOAD_INSPECTION_EVENT){
                                final /* synthetic */ OCDeclarator $typeNameElement;

                                @NotNull
                                public String getName() {
                                    return "Change type to void *";
                                }

                                @NotNull
                                public String getFamilyName() {
                                    return "Change type";
                                }

                                public boolean apply(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                    ApplicationManager.getApplication().runWriteAction(new Runnable(this, project){
                                        final /* synthetic */ inspectDeclaration.5 this$0;
                                        final /* synthetic */ Project $project;

                                        public final void run() {
                                            String varName = this.this$0.$typeNameElement.getName();
                                            OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.this$0.$typeNameElement.getContainingFile(), (int)this.this$0.$typeNameElement.getParent().getTextOffset(), (int)this.this$0.$typeNameElement.getParent().getTextLength(), (String)("void *" + varName), (boolean)true);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            this.$project = project;
                                        }
                                    });
                                    return true;
                                }
                                {
                                    this.$typeNameElement = $captured_local_variable$0;
                                    super($super_call_param$1);
                                }
                            }});
                        }
                    }
                } else if (n != null) {
                    Object object;
                    Object parameter1Name;
                    Object object2 = declarator.getParameters();
                    if (object2 == null || (object2 = (OCDeclarator)object2.get(0)) == null || (object2 = object2.getName()) == null) {
                        object2 = parameter1Name = "vm";
                    }
                    if ((object = declarator.getParameters()) == null || (object = (OCDeclarator)object.get(1)) == null || (object = object.getName()) == null) {
                        object = "unused";
                    }
                    Object parameter2Name = object;
                    OCParameterList oCParameterList = declarator.getParameterList();
                    if (oCParameterList == null) {
                        return;
                    }
                    OCParameterList parameterList = oCParameterList;
                    holder.registerProblem(parameterList.getNavigationElement(), "Too many parameters", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{new JniLocalQuickFix(parameterList, declarator, (String)parameter1Name, (String)parameter2Name, JniInspectionEvent.JniInspectionType.ONLOAD_INSPECTION_EVENT){
                        final /* synthetic */ OCParameterList $parameterList;
                        final /* synthetic */ OCFunctionDeclaration $declarator;
                        final /* synthetic */ String $parameter1Name;
                        final /* synthetic */ String $parameter2Name;

                        @NotNull
                        public String getName() {
                            return "Reduce parameter list length";
                        }

                        @NotNull
                        public String getFamilyName() {
                            return "Reduce parameter list length";
                        }

                        public boolean apply(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                            ApplicationManager.getApplication().runWriteAction(new Runnable(this, project){
                                final /* synthetic */ inspectDeclaration.6 this$0;
                                final /* synthetic */ Project $project;

                                public final void run() {
                                    int textOffset = this.this$0.$parameterList.getTextOffset();
                                    int textLength = this.this$0.$parameterList.getTextLength();
                                    OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.this$0.$declarator.getContainingFile(), (int)textOffset, (int)textLength, (String)("(JavaVM* " + this.this$0.$parameter1Name + ", void *" + this.this$0.$parameter2Name + ')'), (boolean)true);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$project = project;
                                }
                            });
                            return true;
                        }
                        {
                            this.$parameterList = $captured_local_variable$0;
                            this.$declarator = $captured_local_variable$1;
                            this.$parameter1Name = $captured_local_variable$2;
                            this.$parameter2Name = $captured_local_variable$3;
                            super($super_call_param$4);
                        }
                    }});
                }
            }
        }
    }

    public static final /* synthetic */ void access$inspectDeclaration(JniOnloadInspection $this, OCFunctionDeclaration declarator, ProblemsHolder holder, String returnTypeName) {
        $this.inspectDeclaration(declarator, holder, returnTypeName);
    }
}

