/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.jni.FullyQualifiedClassName;
import com.android.tools.ndk.jni.JniMethodResolver;
import com.android.tools.ndk.jni.JniRenameProcessor;
import com.android.tools.ndk.jni.JniUtilsKt;
import com.android.tools.ndk.jni.JvmMethodInfo;
import com.android.tools.ndk.jni.MethodInfo;
import com.android.tools.ndk.jni.NativeMethodId;
import com.android.tools.ndk.jni.NativeMethodInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\fH\u0016J.\u0010\r\u001a\u00020\b*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J<\u0010\u0013\u001a\u00020\b*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J0\u0010\u0018\u001a\u00020\b*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J0\u0010\u001c\u001a\u00020\b*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/ndk/jni/JniRenameProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "prepareRenaming", "", "newName", "", "elementsToRename", "", "collectConflictingMethodsDueToOverloading", "jniMethodResolver", "Lcom/android/tools/ndk/jni/JniMethodResolver;", "conflictingJvmMethodInfos", "", "Lcom/android/tools/ndk/jni/JvmMethodInfo;", "collectElements", "jvmMethodInfo", "nativeMethodIdManipulator", "Lkotlin/Function1;", "Lcom/android/tools/ndk/jni/NativeMethodId;", "collectElementsRelatedToClass", "Lcom/intellij/psi/PsiClass;", "newClassName", "Lcom/android/tools/ndk/jni/FullyQualifiedClassName;", "collectElementsRelatedToMethod", "android-ndk"})
public final class JniRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        return NdkHelper.isNdkProject(element.getProject()) && (element instanceof PsiMethod || element instanceof PsiClass || element instanceof KtFunction);
    }

    /*
     * WARNING - void declaration
     */
    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> elementsToRename) {
        JniMethodResolver jniMethodResolver = JniMethodResolver.Companion.getInstance(element.getProject());
        PsiElement psiElement = element;
        if (psiElement instanceof PsiMethod || psiElement instanceof KtFunction) {
            this.collectElementsRelatedToMethod(elementsToRename, jniMethodResolver, element, newName);
        } else if (psiElement instanceof PsiClass) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            FullyQualifiedClassName fullyQualifiedClassName = FullyQualifiedClassName.Companion.fromJavaClass((PsiClass)element);
            if (fullyQualifiedClassName == null) {
                return;
            }
            FullyQualifiedClassName outerClassName = fullyQualifiedClassName;
            FullyQualifiedClassName newOuterClassName = FullyQualifiedClassName.copy$default(outerClassName, null, CollectionsKt.plus((Collection)CollectionsKt.dropLast(outerClassName.getClasses(), (int)1), (Object)newName), 1, null);
            this.collectElementsRelatedToClass(elementsToRename, jniMethodResolver, (PsiClass)element, newOuterClassName);
            PsiClass[] psiClassArray = ((PsiClass)element).getInnerClasses();
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void var11_11 = $receiver$iv$iv;
            int n = ((void)var11_11).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var11_11[i];
                boolean bl = false;
                Iterable list$iv$iv = JniUtilsKt.generateRecursively(it, prepareRenaming.1.1.INSTANCE);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                FullyQualifiedClassName innerClassName;
                PsiClass psiClass = (PsiClass)element$iv;
                boolean bl = false;
                if (FullyQualifiedClassName.Companion.fromJavaClass(psiClass) == null) {
                    continue;
                }
                List innerClassNameParts = CollectionsKt.drop((Iterable)innerClassName.getClasses(), (int)outerClassName.getClasses().size());
                FullyQualifiedClassName newInnerClassName = FullyQualifiedClassName.copy$default(innerClassName, null, CollectionsKt.plus((Collection)newOuterClassName.getClasses(), (Iterable)innerClassNameParts), 1, null);
                this.collectElementsRelatedToClass(elementsToRename, jniMethodResolver, psiClass, newInnerClassName);
            }
        }
    }

    private final void collectElementsRelatedToClass(@NotNull Map<PsiElement, String> $receiver, JniMethodResolver jniMethodResolver, PsiClass element, FullyQualifiedClassName newClassName) {
        PsiMethod[] $receiver$iv;
        PsiMethod[] psiMethodArray = $receiver$iv = element.getMethods();
        int n = psiMethodArray.length;
        for (int i = 0; i < n; ++i) {
            PsiMethod element$iv;
            PsiMethod psiMethod = element$iv = psiMethodArray[i];
            boolean bl = false;
            JvmMethodInfo jvmMethodInfo = JvmMethodInfo.Companion.fromJavaMethod(psiMethod);
            if (jvmMethodInfo == null) {
                return;
            }
            this.collectElements($receiver, jniMethodResolver, jvmMethodInfo, (Function1<? super NativeMethodId, NativeMethodId>)((Function1)new Function1<NativeMethodId, NativeMethodId>(this, $receiver, jniMethodResolver, newClassName){
                final /* synthetic */ JniRenameProcessor this$0;
                final /* synthetic */ Map $this_collectElementsRelatedToClass$inlined;
                final /* synthetic */ JniMethodResolver $jniMethodResolver$inlined;
                final /* synthetic */ FullyQualifiedClassName $newClassName$inlined;
                {
                    this.this$0 = jniRenameProcessor;
                    this.$this_collectElementsRelatedToClass$inlined = map2;
                    this.$jniMethodResolver$inlined = jniMethodResolver;
                    this.$newClassName$inlined = fullyQualifiedClassName;
                    super(1);
                }

                @NotNull
                public final NativeMethodId invoke(@NotNull NativeMethodId oldNativeMethodId) {
                    return NativeMethodId.copy$default(oldNativeMethodId, this.$newClassName$inlined, null, null, 6, null);
                }
            }));
        }
    }

    private final void collectElementsRelatedToMethod(@NotNull Map<PsiElement, String> $receiver, JniMethodResolver jniMethodResolver, PsiElement element, String newName) {
        MethodInfo methodInfo = MethodInfo.Companion.fromPsiElement$default(MethodInfo.Companion, element, false, 2, null);
        if (!(methodInfo instanceof JvmMethodInfo)) {
            methodInfo = null;
        }
        JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)methodInfo;
        if (jvmMethodInfo == null) {
            return;
        }
        JvmMethodInfo jvmMethodInfo2 = jvmMethodInfo;
        this.collectElements($receiver, jniMethodResolver, jvmMethodInfo2, (Function1<? super NativeMethodId, NativeMethodId>)((Function1)new Function1<NativeMethodId, NativeMethodId>(newName){
            final /* synthetic */ String $newName;

            @NotNull
            public final NativeMethodId invoke(@NotNull NativeMethodId oldNativeMethodId) {
                return NativeMethodId.copy$default(oldNativeMethodId, null, this.$newName, null, 5, null);
            }
            {
                this.$newName = string;
                super(1);
            }
        }));
    }

    private final void collectElements(@NotNull Map<PsiElement, String> $receiver, JniMethodResolver jniMethodResolver, JvmMethodInfo jvmMethodInfo, Function1<? super NativeMethodId, NativeMethodId> nativeMethodIdManipulator) {
        String string;
        NativeMethodId newNativeMethodId = (NativeMethodId)nativeMethodIdManipulator.invoke((Object)jvmMethodInfo.toNativeMethodId(false));
        NativeMethodId newNativeMethodIdWithoutArgs = NativeMethodId.copy$default(newNativeMethodId, null, null, null, 3, null);
        List<JvmMethodInfo> matchedJvmMethodInfos = jniMethodResolver.resolveNativeMethod(newNativeMethodIdWithoutArgs);
        Collection collection = matchedJvmMethodInfos;
        if (!collection.isEmpty()) {
            this.collectConflictingMethodsDueToOverloading($receiver, jniMethodResolver, matchedJvmMethodInfos);
            string = newNativeMethodId.toJniMethodName();
        } else {
            string = newNativeMethodIdWithoutArgs.toJniMethodName();
        }
        String newNativeFunctionName = string;
        for (NativeMethodInfo nativeMethodInfo : jniMethodResolver.resolveJavaOrKotlinMethod(jvmMethodInfo)) {
            OCDeclarator declarator;
            if (nativeMethodInfo.getPsiElement().getDeclarator() == null) {
                continue;
            }
            $receiver.put((PsiElement)declarator, newNativeFunctionName);
        }
    }

    private final void collectConflictingMethodsDueToOverloading(@NotNull Map<PsiElement, String> $receiver, JniMethodResolver jniMethodResolver, List<JvmMethodInfo> conflictingJvmMethodInfos) {
        for (JvmMethodInfo conflictingJvmMethodInfo : conflictingJvmMethodInfos) {
            for (NativeMethodInfo conflictingNativeMethodId : jniMethodResolver.resolveJavaOrKotlinMethod(conflictingJvmMethodInfo)) {
                OCDeclarator declarator;
                if (conflictingNativeMethodId.getNativeMethodId().getArgTypes() != null) continue;
                if (conflictingNativeMethodId.getPsiElement().getDeclarator() == null) {
                    continue;
                }
                $receiver.put((PsiElement)declarator, conflictingJvmMethodInfo.toNativeMethodId(false).toJniMethodName());
            }
        }
    }
}

