/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\u001a5\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\u0004\b\u0000\u0010\u0011*\u0002H\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u0002H\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00140\u0013\u00a2\u0006\u0002\u0010\u0015\u001a?\u0010\u0016\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u0011*\u0002H\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00192\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u0002H\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00140\u0013H\u0002\u00a2\u0006\u0002\u0010\u001a\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0003*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\"\u0015\u0010\t\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\"\u0015\u0010\n\u001a\u00020\u0003*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\"\u0015\u0010\n\u001a\u00020\u0003*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000e\u00a8\u0006\u001b"}, d2={"END_WITH_NUMBER_PATTERN", "Lkotlin/text/Regex;", "isNative", "", "Lcom/intellij/lang/jvm/JvmMethod;", "(Lcom/intellij/lang/jvm/JvmMethod;)Z", "isOverloadedNativeMethod", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/psi/PsiMethod;)Z", "isStatic", "isThrowable", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)Z", "Lcom/intellij/psi/PsiType;", "(Lcom/intellij/psi/PsiType;)Z", "generateRecursively", "", "T", "generator", "Lkotlin/Function1;", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/util/Set;", "generateRecursivelyHelper", "", "accumulator", "", "(Ljava/lang/Object;Ljava/util/Set;Lkotlin/jvm/functions/Function1;)V", "android-ndk"})
public final class JniUtilsKt {
    private static final Regex END_WITH_NUMBER_PATTERN = new Regex("(.*)_(\\d+)");

    public static final boolean isThrowable(@NotNull PsiType $receiver) {
        return InheritanceUtil.isInheritor((PsiType)$receiver, (String)"java.lang.Throwable");
    }

    public static final boolean isThrowable(@NotNull PsiClass $receiver) {
        return InheritanceUtil.isInheritor((PsiClass)$receiver, (String)"java.lang.Throwable");
    }

    public static final boolean isStatic(@NotNull JvmMethod $receiver) {
        return $receiver.hasModifier(JvmModifier.STATIC);
    }

    public static final boolean isNative(@NotNull JvmMethod $receiver) {
        return $receiver.hasModifier(JvmModifier.NATIVE);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isOverloadedNativeMethod(@NotNull PsiMethod $receiver) {
        int n;
        JvmMethod[] jvmMethodArray = $receiver.getContainingClass();
        if (jvmMethodArray != null && (jvmMethodArray = jvmMethodArray.findMethodsByName($receiver.getName())) != null) {
            void var3_3;
            void $receiver$iv$iv;
            JvmMethod[] $receiver$iv;
            JvmMethod[] jvmMethodArray2 = $receiver$iv = jvmMethodArray;
            Collection destination$iv$iv = new ArrayList();
            void var4_4 = $receiver$iv$iv;
            int n2 = ((void)var4_4).length;
            for (int i = 0; i < n2; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var4_4[i];
                boolean bl = false;
                if (!JniUtilsKt.isNative((JvmMethod)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            n = ((List)var3_3).size();
        } else {
            n = 0;
        }
        return n > 1;
    }

    @NotNull
    public static final <T> Set<T> generateRecursively(T $receiver, @NotNull Function1<? super T, ? extends Iterable<? extends T>> generator) {
        Set accumulator = new LinkedHashSet();
        JniUtilsKt.generateRecursivelyHelper($receiver, accumulator, generator);
        return accumulator;
    }

    private static final <T> void generateRecursivelyHelper(T $receiver, Set<T> accumulator, Function1<? super T, ? extends Iterable<? extends T>> generator) {
        if (accumulator.add($receiver)) {
            Iterable $receiver$iv = (Iterable)generator.invoke($receiver);
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                JniUtilsKt.generateRecursivelyHelper(it, accumulator, generator);
            }
        }
    }

    public static final /* synthetic */ Regex access$getEND_WITH_NUMBER_PATTERN$p() {
        return END_WITH_NUMBER_PATTERN;
    }
}

