/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.ndk.jni.FullyQualifiedClassName;
import com.android.tools.ndk.jni.JniUtilsKt;
import com.android.tools.ndk.jni.JvmMethodInfo;
import com.android.tools.ndk.jni.JvmType;
import com.android.tools.ndk.jni.MethodInfo;
import com.android.tools.ndk.jni.NameGenerator;
import com.android.tools.ndk.jni.NativeMethodId;
import com.android.tools.ndk.jni.SimpleParameterDeclaration;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 :2\u00020\u0001:\u0001:BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\u001b\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b0\u0007H\u00c6\u0003J\t\u0010'\u001a\u00020\tH\u00c6\u0003J\t\u0010(\u001a\u00020\fH\u00c6\u0003J\t\u0010)\u001a\u00020\fH\u00c6\u0003J\t\u0010*\u001a\u00020\fH\u00c6\u0003J\t\u0010+\u001a\u00020\u0010H\u00c6\u0003Jk\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b0\u00072\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u00c6\u0001J\u0013\u0010-\u001a\u00020\f2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\u001a\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\f2\b\b\u0002\u00102\u001a\u00020\fH\u0007J\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0007J\t\u00105\u001a\u000206H\u00d6\u0001J\u0012\u00107\u001a\u0002082\b\b\u0002\u00102\u001a\u00020\fH\u0007J\t\u00109\u001a\u00020\u0005H\u00d6\u0001R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u001aR\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0018R\u0014\u0010\u001e\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006;"}, d2={"Lcom/android/tools/ndk/jni/JvmMethodInfo;", "Lcom/android/tools/ndk/jni/MethodInfo;", "className", "Lcom/android/tools/ndk/jni/FullyQualifiedClassName;", "methodName", "", "args", "", "Lkotlin/Pair;", "Lcom/android/tools/ndk/jni/JvmType;", "returnType", "isStatic", "", "isOverloadedNativeMethod", "isNative", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/android/tools/ndk/jni/FullyQualifiedClassName;Ljava/lang/String;Ljava/util/List;Lcom/android/tools/ndk/jni/JvmType;ZZZLcom/intellij/psi/PsiElement;)V", "getArgs", "()Ljava/util/List;", "getClassName", "()Lcom/android/tools/ndk/jni/FullyQualifiedClassName;", "description", "getDescription", "()Ljava/lang/String;", "isKotlin", "()Z", "getMethodName", "methodType", "getMethodType", "nameIdentifier", "getNameIdentifier", "()Lcom/intellij/psi/PsiElement;", "getPsiElement", "getReturnType", "()Lcom/android/tools/ndk/jni/JvmType;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "", "generateNativeMethod", "cpp", "eraseArgs", "generateNativeParameterDeclarations", "Lcom/android/tools/ndk/jni/SimpleParameterDeclaration;", "hashCode", "", "toNativeMethodId", "Lcom/android/tools/ndk/jni/NativeMethodId;", "toString", "Companion", "android-ndk"})
public final class JvmMethodInfo
extends MethodInfo {
    @NotNull
    private final FullyQualifiedClassName className;
    @NotNull
    private final String methodName;
    @NotNull
    private final List<Pair<String, JvmType>> args;
    @NotNull
    private final JvmType returnType;
    private final boolean isStatic;
    private final boolean isOverloadedNativeMethod;
    private final boolean isNative;
    @NotNull
    private final PsiElement psiElement;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public PsiElement getNameIdentifier() {
        PsiIdentifier psiIdentifier;
        PsiElement psiElement = this.getPsiElement();
        if (psiElement instanceof PsiMethod) {
            psiIdentifier = ((PsiMethod)this.getPsiElement()).getNameIdentifier();
            if (psiIdentifier == null) {
                Intrinsics.throwNpe();
            }
        } else {
            if (psiElement instanceof KtFunction) {
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            throw (Throwable)((Object)new AssertionError((Object)"impossible by constructor check"));
        }
        return (PsiElement)psiIdentifier;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final NativeMethodId toNativeMethodId(boolean eraseArgs) {
        NativeMethodId nativeMethodId;
        if (eraseArgs) {
            nativeMethodId = new NativeMethodId(this.className, this.methodName, null);
        } else {
            Collection<JvmType> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = this.args;
            String string = this.methodName;
            FullyQualifiedClassName fullyQualifiedClassName = this.className;
            void var3_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                JvmType jvmType = (JvmType)it.getSecond();
                collection.add(jvmType);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            String string2 = string;
            FullyQualifiedClassName fullyQualifiedClassName2 = fullyQualifiedClassName;
            nativeMethodId = new NativeMethodId(fullyQualifiedClassName2, string2, list);
        }
        return nativeMethodId;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ NativeMethodId toNativeMethodId$default(JvmMethodInfo jvmMethodInfo, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = !jvmMethodInfo.isOverloadedNativeMethod;
        }
        return jvmMethodInfo.toNativeMethodId(bl);
    }

    @JvmOverloads
    @NotNull
    public final NativeMethodId toNativeMethodId() {
        return JvmMethodInfo.toNativeMethodId$default(this, false, 1, null);
    }

    @NotNull
    public final String getMethodType() {
        return '(' + CollectionsKt.joinToString$default((Iterable)this.args, (CharSequence)"", null, null, (int)0, null, (Function1)methodType.1.INSTANCE, (int)30, null) + ')' + this.returnType.toJvmType();
    }

    public final boolean isKotlin() {
        return this.getPsiElement() instanceof KtElement;
    }

    @NotNull
    public final String getDescription() {
        return this.methodName + '(' + CollectionsKt.joinToString$default((Iterable)this.args, null, null, null, (int)0, null, (Function1)description.1.INSTANCE, (int)31, null) + ')';
    }

    @JvmOverloads
    @NotNull
    public final String generateNativeMethod(boolean cpp, boolean eraseArgs) {
        String externDeclaration = cpp ? "extern \"C\"\n" : "";
        List<SimpleParameterDeclaration> otherArgs = this.generateNativeParameterDeclarations();
        return externDeclaration + StringsKt.trimIndent((String)("\n        JNIEXPORT " + this.returnType.toJniType() + " JNICALL\n        " + this.toNativeMethodId(eraseArgs).toJniMethodName() + '(' + CollectionsKt.joinToString$default((Iterable)otherArgs, null, null, null, (int)0, null, null, (int)63, null) + ") {\n            // TODO: implement " + this.methodName + "()\n        }\n      "));
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ String generateNativeMethod$default(JvmMethodInfo jvmMethodInfo, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = !jvmMethodInfo.isOverloadedNativeMethod;
        }
        return jvmMethodInfo.generateNativeMethod(bl, bl2);
    }

    @JvmOverloads
    @NotNull
    public final String generateNativeMethod(boolean cpp) {
        return JvmMethodInfo.generateNativeMethod$default(this, cpp, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SimpleParameterDeclaration> generateNativeParameterDeclarations() {
        Pair $name_type;
        Object object;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        NameGenerator nameGenerator = new NameGenerator("env", this.isStatic ? "clazz" : "thiz");
        Iterable iterable = this.args;
        Collection collection = CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)"JNIEnv *", (Object)"env"), this.isStatic ? TuplesKt.to((Object)"jclass", (Object)"clazz") : TuplesKt.to((Object)"jobject", (Object)"thiz")});
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String name = (String)$name_type.component1();
            JvmType type = (JvmType)$name_type.component2();
            Pair pair2 = TuplesKt.to((Object)type.toJniType(), (Object)nameGenerator.generateUniqueName(SdkVersionInfo.camelCaseToUnderlines((String)name)));
            object.add(pair2);
        }
        object = (List)destination$iv$iv;
        $receiver$iv = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            $name_type = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new SimpleParameterDeclaration((Pair<String, String>)it);
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final FullyQualifiedClassName getClassName() {
        return this.className;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @NotNull
    public final List<Pair<String, JvmType>> getArgs() {
        return this.args;
    }

    @NotNull
    public final JvmType getReturnType() {
        return this.returnType;
    }

    public final boolean isStatic() {
        return this.isStatic;
    }

    public final boolean isOverloadedNativeMethod() {
        return this.isOverloadedNativeMethod;
    }

    public final boolean isNative() {
        return this.isNative;
    }

    @Override
    @NotNull
    public PsiElement getPsiElement() {
        return this.psiElement;
    }

    public JvmMethodInfo(@NotNull FullyQualifiedClassName className, @NotNull String methodName, @NotNull List<? extends Pair<String, ? extends JvmType>> args, @NotNull JvmType returnType, boolean isStatic, boolean isOverloadedNativeMethod, boolean isNative, @NotNull PsiElement psiElement) {
        super(null);
        boolean bl;
        this.className = className;
        this.methodName = methodName;
        this.args = args;
        this.returnType = returnType;
        this.isStatic = isStatic;
        this.isOverloadedNativeMethod = isOverloadedNativeMethod;
        this.isNative = isNative;
        this.psiElement = psiElement;
        boolean bl2 = bl = this.getPsiElement() instanceof PsiMethod || this.getPsiElement() instanceof KtFunction;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "JvmMethodInfo must be created from a valid PsiMethod or KtFunction";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @NotNull
    public final FullyQualifiedClassName component1() {
        return this.className;
    }

    @NotNull
    public final String component2() {
        return this.methodName;
    }

    @NotNull
    public final List<Pair<String, JvmType>> component3() {
        return this.args;
    }

    @NotNull
    public final JvmType component4() {
        return this.returnType;
    }

    public final boolean component5() {
        return this.isStatic;
    }

    public final boolean component6() {
        return this.isOverloadedNativeMethod;
    }

    public final boolean component7() {
        return this.isNative;
    }

    @NotNull
    public final PsiElement component8() {
        return this.getPsiElement();
    }

    @NotNull
    public final JvmMethodInfo copy(@NotNull FullyQualifiedClassName className, @NotNull String methodName, @NotNull List<? extends Pair<String, ? extends JvmType>> args, @NotNull JvmType returnType, boolean isStatic, boolean isOverloadedNativeMethod, boolean isNative, @NotNull PsiElement psiElement) {
        return new JvmMethodInfo(className, methodName, args, returnType, isStatic, isOverloadedNativeMethod, isNative, psiElement);
    }

    @NotNull
    public static /* synthetic */ JvmMethodInfo copy$default(JvmMethodInfo jvmMethodInfo, FullyQualifiedClassName fullyQualifiedClassName, String string, List list, JvmType jvmType, boolean bl, boolean bl2, boolean bl3, PsiElement psiElement, int n, Object object) {
        if ((n & 1) != 0) {
            fullyQualifiedClassName = jvmMethodInfo.className;
        }
        if ((n & 2) != 0) {
            string = jvmMethodInfo.methodName;
        }
        if ((n & 4) != 0) {
            list = jvmMethodInfo.args;
        }
        if ((n & 8) != 0) {
            jvmType = jvmMethodInfo.returnType;
        }
        if ((n & 0x10) != 0) {
            bl = jvmMethodInfo.isStatic;
        }
        if ((n & 0x20) != 0) {
            bl2 = jvmMethodInfo.isOverloadedNativeMethod;
        }
        if ((n & 0x40) != 0) {
            bl3 = jvmMethodInfo.isNative;
        }
        if ((n & 0x80) != 0) {
            psiElement = jvmMethodInfo.getPsiElement();
        }
        return jvmMethodInfo.copy(fullyQualifiedClassName, string, list, jvmType, bl, bl2, bl3, psiElement);
    }

    @NotNull
    public String toString() {
        return "JvmMethodInfo(className=" + this.className + ", methodName=" + this.methodName + ", args=" + this.args + ", returnType=" + this.returnType + ", isStatic=" + this.isStatic + ", isOverloadedNativeMethod=" + this.isOverloadedNativeMethod + ", isNative=" + this.isNative + ", psiElement=" + this.getPsiElement() + ")";
    }

    public int hashCode() {
        FullyQualifiedClassName fullyQualifiedClassName = this.className;
        String string = this.methodName;
        List<Pair<String, JvmType>> list = this.args;
        JvmType jvmType = this.returnType;
        int n = ((((fullyQualifiedClassName != null ? ((Object)fullyQualifiedClassName).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (jvmType != null ? jvmType.hashCode() : 0)) * 31;
        int n2 = this.isStatic ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        int n3 = (n + n2) * 31;
        int n4 = this.isOverloadedNativeMethod ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        int n5 = (n3 + n4) * 31;
        int n6 = this.isNative ? 1 : 0;
        if (n6 != 0) {
            n6 = 1;
        }
        PsiElement psiElement = this.getPsiElement();
        return (n5 + n6) * 31 + (psiElement != null ? psiElement.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JvmMethodInfo)) break block3;
                JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)object;
                if (!Intrinsics.areEqual((Object)this.className, (Object)jvmMethodInfo.className) || !Intrinsics.areEqual((Object)this.methodName, (Object)jvmMethodInfo.methodName) || !Intrinsics.areEqual(this.args, jvmMethodInfo.args) || !Intrinsics.areEqual((Object)this.returnType, (Object)jvmMethodInfo.returnType) || !(this.isStatic == jvmMethodInfo.isStatic) || !(this.isOverloadedNativeMethod == jvmMethodInfo.isOverloadedNativeMethod) || !(this.isNative == jvmMethodInfo.isNative) || !Intrinsics.areEqual((Object)this.getPsiElement(), (Object)jvmMethodInfo.getPsiElement())) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @Nullable
    public static final JvmMethodInfo fromJavaMethod(@NotNull PsiMethod method) {
        return Companion.fromJavaMethod(method);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/ndk/jni/JvmMethodInfo$Companion;", "", "()V", "fromJavaMethod", "Lcom/android/tools/ndk/jni/JvmMethodInfo;", "method", "Lcom/intellij/psi/PsiMethod;", "android-ndk"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final JvmMethodInfo fromJavaMethod(@NotNull PsiMethod method) {
            void $receiver$iv$iv;
            PsiParameter[] $receiver$iv;
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            FullyQualifiedClassName fullyQualifiedClassName = FullyQualifiedClassName.Companion.fromJavaClass(psiClass);
            if (fullyQualifiedClassName == null) {
                return null;
            }
            FullyQualifiedClassName className = fullyQualifiedClassName;
            PsiType psiType = method.getReturnType();
            if (psiType == null) {
                return null;
            }
            JvmType jvmType = JvmType.Companion.fromJavaType(psiType);
            if (jvmType == null) {
                return null;
            }
            JvmType returnType = jvmType;
            PsiParameter[] psiParameterArray = $receiver$iv = method.getParameterList().getParameters();
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            void var8_7 = $receiver$iv$iv;
            int n = ((void)var8_7).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var12_11 = item$iv$iv = var8_7[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                if (string == null) {
                    return null;
                }
                JvmType jvmType2 = JvmType.Companion.fromJavaType(it.getType());
                if (jvmType2 == null) {
                    return null;
                }
                Pair pair = new Pair((Object)string, (Object)jvmType2);
                collection.add(pair);
            }
            List args = (List)destination$iv$iv;
            return new JvmMethodInfo(className, method.getName(), args, returnType, JniUtilsKt.isStatic((JvmMethod)method), JniUtilsKt.isOverloadedNativeMethod(method), JniUtilsKt.isNative((JvmMethod)method), (PsiElement)method);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

