/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ProcessNameReader {
    public static boolean hasGlobalProcess(@NotNull AndroidFacet facet, @NotNull String name) {
        return ProcessNameReader.readGlobalProcessNames(facet).stream().anyMatch(globalProcessName -> name.equals(globalProcessName));
    }

    @NotNull
    private static List<String> readGlobalProcessNames(@NotNull AndroidFacet facet) {
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return Collections.EMPTY_LIST;
        }
        XmlElement xmlElement = manifest.getXmlElement();
        if (xmlElement == null) {
            return Collections.EMPTY_LIST;
        }
        final LinkedList<String> result = new LinkedList<String>();
        xmlElement.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                String value;
                if ("process".equals(attribute.getLocalName()) && (value = attribute.getValue()) != null && !value.startsWith(":")) {
                    result.add(value.toLowerCase());
                }
            }
        });
        return result;
    }
}

