/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.hybrid;

import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointType;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;

public class StepIntoNativeBreakpointHandler
extends CidrCodePointHandlerBase<XBreakpoint<StepIntoNativeBreakpointType.Properties>> {
    private static final Logger LOG = Logger.getInstance(StepIntoNativeBreakpointHandler.class);

    public StepIntoNativeBreakpointHandler(CidrDebugProcess process, @NotNull Class<? extends XBreakpointType<XBreakpoint<StepIntoNativeBreakpointType.Properties>, ?>> type) {
        super(process, type);
    }

    public void registerBreakpoint(final @NotNull XBreakpoint<StepIntoNativeBreakpointType.Properties> breakpoint) {
        final long threadId = this.myProcess.getCurrentThreadId();
        final int frameIndex = this.myProcess.getCurrentFrameIndex();
        final CountDownLatch latch = new CountDownLatch(1);
        this.myProcess.postCommand(new CidrDebugProcess.VoidDebuggerCommand(){

            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                StepIntoNativeBreakpointHandler.this.doRegisterBreakpoint(driver, breakpoint, threadId, frameIndex);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    protected Collection<LLCodepoint> doAddCodepoints(@NotNull DebuggerDriver driver, @NotNull XBreakpoint<StepIntoNativeBreakpointType.Properties> breakpoint, long threadId, int frameNumber) throws ExecutionException {
        String condition = this.convertCondition(breakpoint);
        StepIntoNativeBreakpointType.Properties properties = (StepIntoNativeBreakpointType.Properties)breakpoint.getProperties();
        if (properties == null || properties.getSymbolPattern() == null) {
            return Collections.emptyList();
        }
        try {
            DebuggerDriver.SymbolicBreakpoint symBreakpoint = new DebuggerDriver.SymbolicBreakpoint();
            symBreakpoint.setPattern(properties.getSymbolPattern());
            symBreakpoint.setRegexpPattern(true);
            symBreakpoint.setCondition(condition);
            symBreakpoint.setThreadId(properties.getTid());
            return Collections.singletonList(driver.addSymbolicBreakpoint(symBreakpoint));
        }
        catch (DebuggerCommandException e) {
            return Collections.emptyList();
        }
    }
}

