/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.javaawarecpp;

import com.android.ddmlib.Client;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.hybrid.AndroidNativeHybridDebugProcessBase;
import com.android.tools.ndk.run.hybrid.MethodCollector;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaAwareNativeDebugProcess
extends AndroidNativeHybridDebugProcessBase {
    private static final Logger LOG = Logger.getInstance(AndroidJavaAwareNativeDebugProcess.class);
    private static final XBreakpointType<?, ?> JAVA_LINE_BP_TYPE = (XBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(JavaLineBreakpointType.class);
    private static final Set<String> ART_INTERNAL_FUNCTIONS = ImmutableSet.of((Object)"art_quick_to_interpreter_bridge", (Object)"art_quick_generic_jni_trampoline");
    private final CidrBreakpointHandler myJavaLineBreakpointHandler = new CidrBreakpointHandler((CidrDebugProcess)this, AndroidJavaAwareNativeDebugProcess.getJavaLineBreakpointTypeClass());
    private boolean myLastActionStepIn = false;

    public AndroidJavaAwareNativeDebugProcess(@NotNull String sessionId, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @Nullable JdwpConnector jdwpConnector, @NotNull Client client, @NotNull ProgressReporter progressReporter, boolean detachOnStop) throws com.intellij.execution.ExecutionException {
        super(sessionId, parameters, session, consoleBuilder, printer, sessionStarter, jdwpConnector, client, progressReporter, detachOnStop);
    }

    private static Class<? extends XLineBreakpointType<XBreakpointProperties>> getJavaLineBreakpointTypeClass() {
        return JAVA_LINE_BP_TYPE.getClass();
    }

    @NotNull
    public static Set<XBreakpointType<?, ?>> getJavaBreakpointTypes() {
        return Sets.newHashSet((Object[])new XBreakpointType[]{JAVA_LINE_BP_TYPE});
    }

    @Override
    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        ArrayList<CidrBreakpointHandler> handlerList = new ArrayList<CidrBreakpointHandler>();
        Collections.addAll(handlerList, super.getBreakpointHandlers());
        handlerList.add(this.myJavaLineBreakpointHandler);
        return (XBreakpointHandler[])ContainerUtil.toArray(handlerList, (Object[])new XBreakpointHandler[handlerList.size()]);
    }

    public void startPausing() {
        this.startNonStepInAction();
        super.startPausing();
    }

    public void startStepInto(XSuspendContext context) {
        this.myLastActionStepIn = true;
        this.executeConsoleCommand("step -a false");
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        this.startStepInto(context);
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.startNonStepInAction();
        super.startStepOver(context);
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.startNonStepInAction();
        super.startStepOut(context);
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        this.startNonStepInAction();
        super.runToPosition(position, context);
    }

    public void resume(@Nullable XSuspendContext context) {
        this.startNonStepInAction();
        super.resume(context);
    }

    @Override
    public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
        if (!this.myLastActionStepIn || !this.handleStepIn(stopPlace.thread.getId())) {
            super.handleInterrupted(stopPlace);
        }
    }

    private void startNonStepInAction() {
        this.myLastActionStepIn = false;
        this.removeAllStepIntoNativeBreakpoints();
    }

    private boolean handleStepIn(final long tid) {
        assert (!AndroidJavaAwareNativeDebugProcess.getApp().isDispatchThread());
        final FutureResult framesFuture = new FutureResult();
        this.postCommand(new CidrDebugProcess.VoidDebuggerCommand(){

            public void run(@NotNull DebuggerDriver driver) {
                try {
                    framesFuture.set((Object)driver.getFrames((long)tid, (int)0, (int)2).list);
                }
                catch (Throwable t) {
                    framesFuture.setException(t);
                }
            }
        });
        List frames = null;
        try {
            frames = (List)framesFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn(e.getMessage());
        }
        if (frames == null) {
            return false;
        }
        if (frames.size() < 2) {
            return false;
        }
        LLFrame frame = (LLFrame)frames.get(0);
        LLFrame callerFrame = (LLFrame)frames.get(1);
        if (callerFrame.getFile() == null || !callerFrame.getFile().endsWith(".java")) {
            return false;
        }
        HashSet methods = Sets.newHashSet();
        if (!this.getPossiblyCalledMethods(callerFrame, methods)) {
            return false;
        }
        if (ART_INTERNAL_FUNCTIONS.contains(frame.getFunction()) || methods.contains(frame.getFunction())) {
            if (this.setStepInBreakpointsAndResume(methods, tid)) {
                return true;
            }
            return this.checkedStepOut();
        }
        if (frame.getFile() == null || frame.getFile().isEmpty()) {
            return this.checkedStepOut();
        }
        return false;
    }

    private boolean getPossiblyCalledMethods(@NotNull LLFrame frame, @NotNull Set<String> methodNames) {
        if (frame.getFile() == null) {
            return false;
        }
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(frame.getFile());
        XSourcePosition pos = XDebuggerUtil.getInstance().createPosition(vFile, frame.getLine());
        if (pos == null) {
            return false;
        }
        LinkedList methods = Lists.newLinkedList();
        AndroidJavaAwareNativeDebugProcess.getApp().runReadAction(() -> {
            MethodCollector collector = new MethodCollector(this.getProject(), pos);
            methods.addAll(collector.getMethods());
        });
        if (methods.isEmpty()) {
            return false;
        }
        for (PsiMethod method : methods) {
            methodNames.add(method.getName());
        }
        return true;
    }

    private boolean setStepInBreakpointsAndResume(@NotNull Set<String> methodNames, long tid) {
        for (String method : methodNames) {
            this.registerStepIntoNativeBreakpoint(method, tid);
        }
        final FutureResult retFuture = new FutureResult();
        this.postCommand(new CidrDebugProcess.VoidDebuggerCommand(){

            public void run(@NotNull DebuggerDriver driver) {
                try {
                    retFuture.set((Object)driver.resume());
                }
                catch (Throwable t) {
                    retFuture.setException(t);
                }
            }
        });
        try {
            return (Boolean)retFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    private boolean checkedStepOut() {
        final FutureResult res = new FutureResult();
        this.postCommand(new CidrDebugProcess.VoidDebuggerCommand(){

            public void run(@NotNull DebuggerDriver driver) {
                try {
                    driver.stepOut();
                    res.set((Object)true);
                }
                catch (Throwable t) {
                    res.setException(t);
                }
            }
        });
        try {
            return (Boolean)res.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }
}

