/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.javaawarecpp;

import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaAwareNativeDebuggerTypesHelper
extends CidrDebuggerTypesHelper {
    private final CidrDebuggerTypesHelper myCppTypesHelper;

    public AndroidJavaAwareNativeDebuggerTypesHelper(@NotNull AndroidNativeAppDebugProcess process, @NotNull CidrDebuggerTypesHelper cppTypesHelper) {
        super((CidrDebugProcess)process);
        this.myCppTypesHelper = cppTypesHelper;
    }

    public XSourcePosition computeSourcePosition(@NotNull CidrMemberValue value) {
        CidrPhysicalValue parent;
        XSourcePosition position = value.getSourcePosition();
        if (position == null && (position = (parent = value.getParent()).getSourcePosition()) == null) {
            return null;
        }
        if (AndroidJavaAwareNativeDebuggerTypesHelper.isJavaSourcePosition(position)) {
            return position;
        }
        return this.myCppTypesHelper.computeSourcePosition(value);
    }

    @Nullable
    public XSourcePosition resolveProperty(@NotNull CidrMemberValue value, @Nullable String dynamicTypeName) {
        CidrPhysicalValue parent;
        XSourcePosition position = value.getSourcePosition();
        if (position == null && (position = (parent = value.getParent()).getSourcePosition()) == null) {
            return null;
        }
        if (AndroidJavaAwareNativeDebuggerTypesHelper.isJavaSourcePosition(position)) {
            return position;
        }
        return this.myCppTypesHelper.resolveProperty(value, dynamicTypeName);
    }

    public PsiElement resolveToDeclaration(XSourcePosition position, LLValue var) {
        if (AndroidJavaAwareNativeDebuggerTypesHelper.isJavaSourcePosition(position)) {
            return this.getContextElement(position);
        }
        return this.myCppTypesHelper.resolveToDeclaration(position, var);
    }

    @Nullable
    protected PsiReference createReferenceFromText(@NotNull LLValue var, @NotNull PsiElement context) {
        return null;
    }

    @Nullable
    public Boolean isImplicitContextVariable(@NotNull XSourcePosition position, @NotNull LLValue var) {
        if (!AndroidJavaAwareNativeDebuggerTypesHelper.isJavaSourcePosition(position)) {
            return this.myCppTypesHelper.isImplicitContextVariable(position, var);
        }
        return var.getName().equals("this");
    }

    private static boolean isJavaSourcePosition(@NotNull XSourcePosition position) {
        return position.getFile().getFileType().equals(StdFileTypes.JAVA);
    }
}

