/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.jdwp;

import com.android.ddmlib.Client;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.tools.idea.run.AndroidDebugState;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.jdwp.CodeInjection;
import com.android.tools.ndk.run.jdwp.CodeInjectionImpl;
import com.android.tools.ndk.run.jdwp.InstrumentationStopRequestor;
import com.android.tools.ndk.run.jdwp.NativeAwareDebugProcessHandler;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugUIEnvironment;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class JdwpConnector {
    private static final String INSTRUMENTATION_CLASS = "android.app.Instrumentation";
    private static final long ATTACH_TIMEOUT_MS = 10000L;
    private final LaunchInfo myLaunchInfo;
    private final AndroidFacet myFacet;
    private final Client myClient;
    private final ClientShellHelper myClientShellHelper;
    private final XDebugSession myNativeDebugSession;
    private final boolean myLaunchMode;
    private final List<CodeInjectionImpl> myCodeInjections = Lists.newLinkedList();
    private boolean mySessionCreated = false;
    private final List<SessionListener> mySessionListeners = Lists.newLinkedList();
    private final List<FilteredRequestor> myRequestors = Lists.newLinkedList();
    private DebuggerSession myDebuggerSession = null;
    private static final Logger LOG = Logger.getInstance(JdwpConnector.class);

    public JdwpConnector(@NotNull LaunchInfo launchInfo, @NotNull AndroidFacet facet, @NotNull Client client, @NotNull ClientShellHelper clientShellHelper, @NotNull XDebugSession nativeDebugSession, boolean launchMode) {
        this.myLaunchInfo = launchInfo;
        this.myFacet = facet;
        this.myClient = client;
        this.myClientShellHelper = clientShellHelper;
        this.myNativeDebugSession = nativeDebugSession;
        this.myLaunchMode = launchMode;
    }

    private DebuggerSession internalConnect() throws com.intellij.execution.ExecutionException {
        LOG.debug("internalConnect called");
        String debugPort = Integer.toString(this.myClient.getDebuggerListenPort());
        final Project project = this.myLaunchInfo.env.getProject();
        RemoteConnection connection = new RemoteConnection(true, "localhost", debugPort, false);
        NativeAwareDebugProcessHandler debugProcessHandler = new NativeAwareDebugProcessHandler(this.myNativeDebugSession);
        AndroidSessionInfo oldInfo = (AndroidSessionInfo)this.myNativeDebugSession.getDebugProcess().getProcessHandler().getUserData(AndroidSessionInfo.KEY);
        if (oldInfo != null) {
            AndroidSessionInfo newInfo = new AndroidSessionInfo((ProcessHandler)debugProcessHandler, oldInfo.getDescriptor(), oldInfo.getRunConfigurationId(), oldInfo.getExecutorId(), oldInfo.getExecutorActionName(), oldInfo.getExecutionTarget());
            debugProcessHandler.putUserData(AndroidSessionInfo.KEY, newInfo);
        }
        AndroidDebugState st = new AndroidDebugState(project, (ProcessHandler)debugProcessHandler, connection, this.myLaunchInfo.consoleProvider);
        ExecutionEnvironment env = new ExecutionEnvironmentBuilder(this.myLaunchInfo.env).executor(this.myLaunchInfo.env.getExecutor()).build();
        DefaultDebugUIEnvironment debugUIEnv = new DefaultDebugUIEnvironment(env, (RunProfileState)st, st.getRemoteConnection(), false);
        final DebugEnvironment modelEnvironment = debugUIEnv.getEnvironment();
        final DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx((Project)project);
        debuggerManager.getContextManager().addListener(new DebuggerContextListener((DebugUIEnvironment)debugUIEnv, debugProcessHandler){
            final /* synthetic */ DebugUIEnvironment val$debugUIEnv;
            final /* synthetic */ NativeAwareDebugProcessHandler val$debugProcessHandler;
            {
                this.val$debugUIEnv = debugUIEnvironment;
                this.val$debugProcessHandler = nativeAwareDebugProcessHandler;
            }

            public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
                DebuggerSession session = newContext.getDebuggerSession();
                if (session != null && project.equals(session.getProject()) && session.getSessionName().equals(modelEnvironment.getSessionName()) && event == DebuggerSession.Event.CONTEXT) {
                    LOG.debug("Got CONTEXT event in JdwpConnector");
                    debuggerManager.getContextManager().removeListener((DebuggerContextListener)this);
                    if (!JdwpConnector.this.myCodeInjections.isEmpty()) {
                        session.getProcess().addDebugProcessListener((DebugProcessListener)new DebugProcessAdapterImplEx());
                    }
                    JdwpConnector.this.runSessionCreatedListeners(session, this.val$debugUIEnv);
                    if (!this.val$debugProcessHandler.isStartNotified()) {
                        this.val$debugProcessHandler.startNotify();
                    }
                }
            }
        });
        DebuggerSession debuggerSession = debuggerManager.attachVirtualMachine(modelEnvironment);
        if (debuggerSession == null) {
            throw new com.intellij.execution.ExecutionException("Debugger session could not attach");
        }
        debugProcessHandler.addDetachListener((DebugProcess)debuggerSession.getProcess());
        DebugProcessImpl debugProcess = debuggerSession.getProcess();
        if (debugProcess.isDetached() || debugProcess.isDetaching()) {
            debuggerSession.dispose();
            throw new com.intellij.execution.ExecutionException("Debug process has been detached");
        }
        LOG.debug("internalConnect completed successfully");
        return debuggerSession;
    }

    private static void waitForAttach(DebugProcess process, Stopwatch stopwatch) throws InterruptedException, TimeoutException, com.intellij.execution.ExecutionException {
        WaitForAttachListener listener = new WaitForAttachListener();
        try {
            process.addDebugProcessListener((DebugProcessListener)listener);
            if (!process.isAttached() && (process.isDetached() || process.isDetaching() || !listener.waitForJdwpAttach(stopwatch))) {
                throw new com.intellij.execution.ExecutionException("Java debugger detached or detaching");
            }
        }
        finally {
            process.removeDebugProcessListener((DebugProcessListener)listener);
        }
    }

    public void Connect() throws com.intellij.execution.ExecutionException {
        LOG.debug("Connecting");
        FutureResult connectResult = new FutureResult();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                connectResult.set((Object)this.internalConnect());
            }
            catch (com.intellij.execution.ExecutionException e) {
                connectResult.setException((Throwable)e);
            }
        }, ModalityState.any());
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.myDebuggerSession = (DebuggerSession)connectResult.get(10000L, TimeUnit.MILLISECONDS);
            JdwpConnector.waitForAttach((DebugProcess)this.myDebuggerSession.getProcess(), stopwatch);
        }
        catch (TimeoutException e) {
            LOG.info("Timed out waiting for java debugger attach", (Throwable)e);
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while waiting for java debugger attach", (Throwable)e);
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.info("ExecutionException waiting for internalConnect result", (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof com.intellij.execution.ExecutionException) {
                throw (com.intellij.execution.ExecutionException)cause;
            }
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
    }

    public CodeInjection injectCodeFragment(@NotNull String codeFragment) {
        CodeInjectionImpl codeInjection = new CodeInjectionImpl(codeFragment);
        this.myCodeInjections.add(codeInjection);
        return codeInjection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCodeInjections(SuspendContextImpl suspendContext) {
        DebugProcessImpl dbgProcess = suspendContext.getDebugProcess();
        ThreadReferenceProxyImpl threadRefProxy = suspendContext.getThread();
        assert (threadRefProxy != null);
        for (CodeInjectionImpl codeInjection : this.myCodeInjections) {
            FutureResult<Void> resultFuture = codeInjection.getResultFuture();
            LOG.info("Evaluating expression: " + codeInjection.getCodeFragment());
            Date startTime = new Date();
            XExpressionImpl expr = XExpressionImpl.fromText((String)codeInjection.getCodeFragment(), (EvaluationMode)EvaluationMode.CODE_FRAGMENT);
            TextWithImports text = TextWithImportsImpl.fromXExpression((XExpression)expr);
            WatchItemDescriptor descriptor = new WatchItemDescriptor(dbgProcess.getProject(), text);
            try {
                StackFrameProxyImpl stackFrameProxy = threadRefProxy.frame(0);
                EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, stackFrameProxy);
                descriptor.setContext(evaluationContext);
                LOG.info("Evaluation took " + (new Date().getTime() - startTime.getTime()) + " ms");
                EvaluateException exception = descriptor.getEvaluateException();
                if (exception != null && descriptor.getValue() == null) {
                    resultFuture.setException((Throwable)exception);
                    LOG.error("Failed to evaluate expression: " + exception.getMessage());
                    continue;
                }
                resultFuture.set(null);
            }
            catch (EvaluateException e) {
                resultFuture.setException((Throwable)e);
                LOG.error((Throwable)e);
            }
            finally {
                codeInjection.waitForResume();
            }
        }
    }

    public void dispose() {
        if (this.myDebuggerSession != null) {
            Disposer.dispose((Disposable)this.myDebuggerSession.getProcess().getExecutionResult().getExecutionConsole());
            this.myDebuggerSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSessionCreatedListeners(DebuggerSession debuggerSession, DebugUIEnvironment debugUIEnv) {
        List<SessionListener> list = this.mySessionListeners;
        synchronized (list) {
            assert (!this.mySessionCreated);
            for (SessionListener listener : this.mySessionListeners) {
                listener.sessionCreated(debuggerSession, debugUIEnv);
            }
            this.mySessionListeners.clear();
            this.mySessionCreated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(@NotNull SessionListener sessionListener) {
        List<SessionListener> list = this.mySessionListeners;
        synchronized (list) {
            assert (!this.mySessionCreated);
            this.mySessionListeners.add(sessionListener);
        }
    }

    private static class WaitForAttachListener
    implements DebugProcessListener {
        private final Object myLock = new Object();
        private boolean myAttached = false;
        private boolean myDetached = false;

        private WaitForAttachListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForJdwpAttach(Stopwatch stopwatch) throws InterruptedException, TimeoutException {
            Object object = this.myLock;
            synchronized (object) {
                while (!this.myAttached && !this.myDetached) {
                    long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                    if (10000L > elapsed) {
                        this.myLock.wait(10000L - elapsed);
                        continue;
                    }
                    throw new TimeoutException("Timed out waiting for java debugger to attach");
                }
                return !this.myDetached;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processAttached(DebugProcess process) {
            Object object = this.myLock;
            synchronized (object) {
                this.myAttached = true;
                this.myLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processDetached(DebugProcess process, boolean closedByUser) {
            Object object = this.myLock;
            synchronized (object) {
                this.myDetached = true;
                this.myLock.notifyAll();
            }
        }
    }

    private class DebugProcessAdapterImplEx
    extends DebugProcessAdapterImpl {
        private DebugProcessAdapterImplEx() {
        }

        public void paused(SuspendContextImpl suspendContext) {
            LOG.info("Process is paused");
            DebugProcessImpl dbgProcess = suspendContext.getDebugProcess();
            dbgProcess.removeDebugProcessListener((DebugProcessListener)this);
            JdwpConnector.this.runCodeInjections(suspendContext);
            RequestManagerImpl requestManager = dbgProcess.getRequestsManager();
            for (FilteredRequestor requestor : JdwpConnector.this.myRequestors) {
                requestManager.deleteRequest((Requestor)requestor);
            }
            dbgProcess.getManagerThread().schedule((DebuggerCommandImpl)dbgProcess.createResumeCommand(suspendContext));
        }

        public void processAttached(DebugProcessImpl process) {
            LOG.info("Attached to process");
            try {
                if (JdwpConnector.this.myLaunchMode) {
                    this.setLaunchHooks(process);
                } else {
                    this.setAttachHooks(process);
                }
            }
            catch (com.intellij.execution.ExecutionException e) {
                this.fail(e.getMessage());
                LOG.warn((Throwable)e);
            }
        }

        private void setLaunchHooks(@NotNull DebugProcessImpl process) throws com.intellij.execution.ExecutionException {
            List refs = process.getVirtualMachineProxy().classesByName(JdwpConnector.INSTRUMENTATION_CLASS);
            if (refs.isEmpty()) {
                throw new com.intellij.execution.ExecutionException("Failed to find Instrumentation class in VM");
            }
            ClassType classClassType = (ClassType)refs.get(0);
            Method ctor = DebuggerUtils.findMethod((ReferenceType)classClassType, (String)"<init>", (String)"()V");
            if (ctor == null) {
                throw new com.intellij.execution.ExecutionException("Failed to find Instrumentation default constructor");
            }
            this.setMethodBreakpoint(process.getRequestsManager(), ctor);
        }

        private void setAttachHooks(@NotNull DebugProcessImpl process) throws com.intellij.execution.ExecutionException {
            LinkedList activities = Lists.newLinkedList();
            LinkedList services = Lists.newLinkedList();
            ApplicationManager.getApplication().runReadAction(() -> {
                Manifest manifest = JdwpConnector.this.myFacet.getManifest();
                assert (manifest != null);
                Application app = manifest.getApplication();
                for (Activity activity : app.getActivities()) {
                    PsiClass activityClass = (PsiClass)activity.getActivityClass().getValue();
                    if (activityClass == null) continue;
                    activities.add(activityClass.getQualifiedName());
                }
                for (Service service : app.getServices()) {
                    PsiClass serviceClass = (PsiClass)service.getServiceClass().getValue();
                    if (serviceClass == null) continue;
                    services.add(serviceClass.getQualifiedName());
                }
            });
            RequestManagerImpl requestManager = process.getRequestsManager();
            boolean activitiesSet = this.setDumpBreakpoints(process, requestManager, activities);
            if (!activitiesSet && !this.setDumpBreakpoints(process, requestManager, services)) {
                throw new com.intellij.execution.ExecutionException("Failed to set dump breakpoints");
            }
            try {
                String cmd = activitiesSet ? "dumpsys activity" : "dumpsys activity service";
                String packageName = JdwpConnector.this.myClientShellHelper.getPackageName();
                JdwpConnector.this.myClient.getDevice().executeShellCommand(String.format("%s %s", cmd, packageName), (IShellOutputReceiver)new NullOutputReceiver());
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                throw new com.intellij.execution.ExecutionException("dumpsys failed", (Throwable)e);
            }
        }

        private void setMethodBreakpoint(@NotNull RequestManagerImpl requestManager, @NotNull Method method) {
            String className = method.location().declaringType().name();
            InstrumentationStopRequestor requestor = new InstrumentationStopRequestor(className);
            BreakpointRequest br = requestManager.createBreakpointRequest((FilteredRequestor)requestor, method.location());
            requestManager.enableRequest((EventRequest)br);
            JdwpConnector.this.myRequestors.add(requestor);
        }

        private boolean setDumpBreakpoints(@NotNull DebugProcessImpl process, @NotNull RequestManagerImpl requestManager, @NotNull List<String> classNames) {
            boolean result = false;
            HashSet methods = Sets.newHashSet();
            for (String className : classNames) {
                List activityRefs = process.getVirtualMachineProxy().classesByName(className);
                if (activityRefs.isEmpty()) {
                    LOG.info("Did not find any classes with name : " + className);
                    continue;
                }
                ClassType activityClassType = (ClassType)activityRefs.get(0);
                Method dump = DebuggerUtils.findMethod((ReferenceType)activityClassType, (String)"dump", null);
                if (dump == null) {
                    LOG.info("Did not find 'dump' method in class '" + className + "'");
                    continue;
                }
                if (methods.contains(dump)) continue;
                this.setMethodBreakpoint(requestManager, dump);
                methods.add(dump);
                result = true;
            }
            return result;
        }

        private void fail(@NotNull String errorMessage) {
            com.intellij.execution.ExecutionException e = new com.intellij.execution.ExecutionException(errorMessage);
            for (CodeInjectionImpl codeInjection : JdwpConnector.this.myCodeInjections) {
                FutureResult<Void> resultFuture = codeInjection.getResultFuture();
                resultFuture.setException((Throwable)e);
            }
        }
    }

    public static interface SessionListener {
        public void sessionCreated(@NotNull DebuggerSession var1, @NotNull DebugUIEnvironment var2);
    }
}

