/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.lldb.AddressBreakpointType;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddressBreakpointHandler
extends CidrCodePointHandlerBase<XLineBreakpoint<AddressBreakpointType.Properties>> {
    private static final Logger LOG = Logger.getInstance(AddressBreakpointHandler.class);
    private static final Pattern BREAKPOINT_RESPONSE_PATTERN = Pattern.compile("^Breakpoint\\s+([0-9]+):");

    public AddressBreakpointHandler(AndroidNativeAppDebugProcess process) {
        super((CidrDebugProcess)process, AddressBreakpointType.class);
    }

    protected Collection<LLCodepoint> doAddCodepoints(DebuggerDriver baseDriver, XLineBreakpoint<AddressBreakpointType.Properties> breakpoint, long threadId, int frameIndex) throws ExecutionException {
        AndroidLLDBDriver driver = (AndroidLLDBDriver)baseDriver;
        XBreakpointProperties properties = breakpoint.getProperties();
        if (properties == null) {
            LOG.warn("null properties for address breakpoint, assuming it is obsolete and removing it");
            XBreakpointManager manager = XDebuggerManager.getInstance((Project)this.myProcess.getProject()).getBreakpointManager();
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> manager.removeBreakpoint((XBreakpoint)breakpoint)));
            return Collections.emptyList();
        }
        Pair<String, Boolean> result = driver.executeConsoleCommandWithOutput(threadId, frameIndex, "breakpoint set --address " + ((AddressBreakpointType.Properties)breakpoint.getProperties()).getAddress());
        if (!((Boolean)result.getSecond()).booleanValue()) {
            throw new ExecutionException("Failed to set address breakpoint : " + (String)result.getFirst());
        }
        ((AddressBreakpointType.Properties)breakpoint.getProperties()).setProcess((AndroidNativeAppDebugProcess)this.myProcess);
        Matcher m = BREAKPOINT_RESPONSE_PATTERN.matcher((CharSequence)result.getFirst());
        if (m.lookingAt()) {
            try {
                return Collections.singletonList(new LLCodepoint(Integer.parseInt(m.group(1))));
            }
            catch (NumberFormatException e) {
                LOG.warn("Failed to parse breakpoint id \"" + m.group(1) + "\".  Address breakpoint for address " + ((AddressBreakpointType.Properties)breakpoint.getProperties()).getAddress() + " is probably broken.");
            }
        } else {
            LOG.warn("Failed to parse output for address breakpoint at " + ((AddressBreakpointType.Properties)breakpoint.getProperties()).getAddress() + ". It may be set, but we won't be able to disable or remove it, except by restarting the debug session.  The output was: \"" + (String)result.getFirst());
        }
        return Collections.emptyList();
    }

    public void cleanup() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProcess.getProject().isDisposed()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                XBreakpointManager manager = XDebuggerManager.getInstance((Project)this.myProcess.getProject()).getBreakpointManager();
                for (XBreakpoint breakpoint : manager.getBreakpoints(this.getBreakpointTypeClass())) {
                    AddressBreakpointType.Properties properties = (AddressBreakpointType.Properties)breakpoint.getProperties();
                    if (properties == null || properties.getProcess() != this.myProcess) continue;
                    manager.removeBreakpoint(breakpoint);
                }
            });
        });
    }
}

