/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddressBreakpointType
extends XLineBreakpointType<Properties> {
    private static final Logger LOG = Logger.getInstance(AddressBreakpointType.class);
    public static final String TYPE_ID = "com.android.tools.ndk.run.lldb.AddressBreakpointType";

    public AddressBreakpointType() {
        super(TYPE_ID, "Address breakpoints");
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Document doc = (Document)file.getUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY);
        if (doc == null) {
            return false;
        }
        return false;
    }

    @Nullable
    public Properties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        Document doc = (Document)file.getUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY);
        if (doc == null) {
            throw new IllegalStateException("Unexpected null document");
        }
        String lineContent = doc.getText(new TextRange(doc.getLineStartOffset(line), doc.getLineEndOffset(line)));
        String addressString = lineContent.substring(lineContent.lastIndexOf(33) + 2);
        return new Properties(Address.parseHexString((String)addressString));
    }

    public String getDisplayText(XLineBreakpoint<Properties> breakpoint) {
        Properties props = (Properties)breakpoint.getProperties();
        if (props == null) {
            return null;
        }
        return ((Properties)breakpoint.getProperties()).getAddress().toString();
    }

    public String getShortText(XLineBreakpoint<Properties> breakpoint) {
        return this.getDisplayText(breakpoint);
    }

    public static class Properties
    extends XBreakpointProperties<Properties> {
        private long myAddress;
        private AndroidNativeAppDebugProcess myProcess;

        Properties() {
        }

        Properties(@NotNull Address address) {
            this.myAddress = address.getUnsignedLongValue();
        }

        public Address getAddress() {
            return Address.fromUnsignedLong((long)this.myAddress);
        }

        public AndroidNativeAppDebugProcess getProcess() {
            return this.myProcess;
        }

        public void setProcess(AndroidNativeAppDebugProcess process) {
            this.myProcess = process;
        }

        @Nullable
        public Properties getState() {
            return new Properties();
        }

        public void loadState(@NotNull Properties state) {
        }
    }
}

