/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.DeviceHelper;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.LibStdCppTypeNameFormatters;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.GeneratedMessage;
import com.google.wireless.android.sdk.stats.LldbPercentileEstimator;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLLDBDriver
extends LLDBDriver {
    private static final String PLATFORM_NAME = "remote-android";
    private static final String ENV_VAR_PREFIX = "ANDROIDSTUDIO_LLDB_EXTRA_CMD_";
    private static final String[] STARTUP_SCRIPTS = new String[]{ModulePathManager.getRepoLLDBStlPrintersBinFile("load_script").getPath()};
    private static final int CONNECT_PLATFORM_NUM_ATTEMPTS = 10;
    private static final int CONNECT_PLATFORM_TIMEOUT_MSECS = 500;
    private final Collection<File> mySymDirs;
    private final SessionStarter mySessionStarter;
    private String myPlatformConnectURL;
    @NotNull
    private final List<String> myStartupCommands;
    @NotNull
    private final List<String> myPostAttachCommands;
    private boolean myCrashed = false;
    private final boolean myDeviceSupportsWatchpoints;
    private static final Set<String> WATCHPOINT_WHITELISTED_MODELS = Sets.newHashSet((Object[])new String[]{"Nexus 9"});
    private static final Set<Abi> WATCHPOINT_WHITELISTED_ABIS = ImmutableSet.of((Object)Abi.X86, (Object)Abi.X86_64);
    private boolean myReportedWatchpointsUsage = false;
    private Stopwatch attachStopwatch = Stopwatch.createStarted();
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDriver.class);

    public AndroidLLDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AndroidLLDBDriverConfiguration configuration2, @NotNull ConsolePrinter printer) throws ExecutionException {
        super(handler, (LLDBDriverConfiguration)configuration2);
        AndroidLLDBBreakpadIntegration.monitorForCrashes(this);
        IDevice device = configuration2.getDevice();
        this.mySessionStarter = configuration2.getSessionStarter();
        this.myStartupCommands = configuration2.getStartupCommands();
        this.myPostAttachCommands = configuration2.getPostAttachCommands();
        this.mySymDirs = AndroidNativeAppDebugProcess.getSymbolsDir(facet, debuggerState, configuration2.getClientABIs());
        if (this.mySymDirs.isEmpty()) {
            LOG.warn("No symbol directories found");
            printer.stderr("Attention! No symbol directories found - please check your native debug configuration");
        }
        this.myDeviceSupportsWatchpoints = AndroidLLDBDriver.deviceSupportsWatchpoints(device);
    }

    private static boolean deviceSupportsWatchpoints(@NotNull IDevice device) {
        String model = device.getProperty("ro.product.model");
        if (WATCHPOINT_WHITELISTED_MODELS.contains(model)) {
            return true;
        }
        for (String abiStr : device.getAbis()) {
            Abi abi = Abi.getEnum((String)abiStr);
            if (abi == null || !WATCHPOINT_WHITELISTED_ABIS.contains(abi)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String getWatchpointWhitelist() {
        return String.format("%s based devices/emulators, %s", WATCHPOINT_WHITELISTED_ABIS, WATCHPOINT_WHITELISTED_MODELS);
    }

    public void commonLoad() throws ExecutionException {
        LOG.info("Loading driver");
        LOG.debug("Load startup scripts");
        this.executeConsoleCommand("settings set target.process.thread.step-out-avoid-nodebug false");
        this.loadStartupScripts();
        this.loadJObjectPrettyPrinterScripts();
        LOG.debug("run console commands from environment");
        this.runEnvCommands();
        this.runStartupCommands();
        LOG.debug("connectPlatform");
        int attempts = 0;
        while (true) {
            ++attempts;
            try {
                this.connectPlatform();
                break;
            }
            catch (LLDBDriverException e) {
                if (attempts >= 10) {
                    LOG.warn("Giving up making LLDB connection after 10 attempts");
                    throw e;
                }
                LOG.warn("Failed to connect platform (attempt " + attempts + " of " + 10 + ") - retrying.  Error was: " + e.getMessage());
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new ExecutionException("Interrupted");
                }
            }
        }
    }

    private void setSymbols() throws ExecutionException {
        if (!this.mySymDirs.isEmpty()) {
            ArrayList searchPaths = Lists.newArrayListWithExpectedSize((int)this.mySymDirs.size());
            for (File symDir : this.mySymDirs) {
                searchPaths.add("\"" + symDir.getAbsolutePath() + "\"");
            }
            String searchPathsStr = StringUtil.join((Collection)searchPaths, (String)" ");
            LOG.info("Append target.exec-search-paths: " + searchPathsStr);
            this.executeConsoleCommand("settings append target.exec-search-paths " + searchPathsStr);
        }
    }

    protected void sendCreateTargetRequest(@NotNull Protocol.CompositeRequest createTargetRequest) throws ExecutionException {
        if (!createTargetRequest.getCreateTarget().getExePath().isEmpty()) {
            throw new IllegalStateException("Creating a target based on an executable path is not supported on Android");
        }
        super.sendCreateTargetRequest(createTargetRequest);
    }

    @NotNull
    public DebuggerDriver.Inferior loadForLaunch(@NotNull Installer installer, @Nullable String architectureId) throws ExecutionException {
        throw new IllegalStateException("loadForLaunch is not supported on Android");
    }

    @NotNull
    public DebuggerDriver.Inferior loadForAttach(int pid, final @NotNull ThrowableRunnable<ExecutionException> preAttach, final @NotNull ThrowableRunnable<ExecutionException> postAttach) throws ExecutionException {
        this.commonLoad();
        final DebuggerDriver.Inferior delegate = super.loadForAttach(pid);
        this.setSymbols();
        return new DebuggerDriver.Inferior(0){

            protected long startImpl() throws ExecutionException {
                preAttach.run();
                long ret = delegate.start();
                AndroidLLDBDriver.this.runPostAttachCommands();
                postAttach.run();
                return ret;
            }

            protected void detachImpl() throws ExecutionException {
                delegate.detach();
            }

            protected boolean destroyImpl() throws ExecutionException {
                return delegate.destroy();
            }
        };
    }

    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
        super.setValuesFilteringEnabled(true);
    }

    private void runCommands(@NotNull String name, @NotNull List<String> commands) throws ExecutionException {
        for (String cmd : commands) {
            String trimmed_cmd = cmd.trim();
            if (trimmed_cmd.isEmpty()) continue;
            LOG.info(String.format("%s command: \"%s\"", name, trimmed_cmd));
            this.executeConsoleCommand(trimmed_cmd);
        }
    }

    private void runStartupCommands() throws ExecutionException {
        this.runCommands("Startup", this.myStartupCommands);
    }

    private void runPostAttachCommands() throws ExecutionException {
        this.runCommands("Post attach", this.myPostAttachCommands);
    }

    public boolean supportsWatchpoints() {
        return true;
    }

    private void runEnvCommands() throws ExecutionException {
        String envCommand;
        int i = 0;
        while ((envCommand = System.getenv(ENV_VAR_PREFIX + i)) != null) {
            LOG.info("Environment command: " + envCommand);
            this.executeConsoleCommand(envCommand);
            ++i;
        }
    }

    private void loadStartupScripts() throws ExecutionException {
        for (String script : STARTUP_SCRIPTS) {
            LOG.info("Loading startup script: " + script);
            this.executeConsoleCommand("command source \"" + script + "\"");
        }
    }

    private void loadJObjectPrettyPrinterScripts() throws ExecutionException {
        int deviceApiLevel = this.mySessionStarter.getDevice().getVersion().getApiLevel();
        String isDalvik = DeviceHelper.RuntimeVersion.DALVIK.equals((Object)DeviceHelper.getRuntime(this.mySessionStarter.getDevice())) ? "True" : "False";
        File scriptPath = new File(ModulePathManager.getRepoLLDBPrettyPrinterScriptsFolder(), "jstring_reader.py");
        LOG.info("Loading startup script: " + scriptPath);
        this.executeConsoleCommand("command script import \"" + scriptPath + "\"");
        this.executeConsoleCommand(String.format("script jstring_reader.register(%d, %s)", deviceApiLevel, isDalvik));
    }

    private void connectPlatform() throws ExecutionException {
        if (this.myPlatformConnectURL == null) {
            this.myPlatformConnectURL = this.mySessionStarter.startServer();
        }
        LOG.info("Connecting to LLDB server: " + this.myPlatformConnectURL);
        LLDBDriver.ThrowIfNotValid responseHandler = new LLDBDriver.ThrowIfNotValid("Couldn't connect platform");
        Protocol.CompositeRequest connectPlatformReq = ProtobufMessageFactory.connectPlatform((String)PLATFORM_NAME, (String)this.myPlatformConnectURL);
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)connectPlatformReq, Protocol.ConnectPlatform_Res.class, (Consumer)responseHandler);
        responseHandler.throwIfNeeded();
    }

    public boolean isCrashed() {
        return this.myCrashed;
    }

    public void setCrashed() {
        this.myCrashed = true;
    }

    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameNumber, LLValue value, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        if (!this.myDeviceSupportsWatchpoints) {
            throw new DebuggerCommandException("You are debugging on a device that is not known to support watchpoints - supported devices include " + AndroidLLDBDriver.getWatchpointWhitelist());
        }
        if (!this.myReportedWatchpointsUsage) {
            this.myReportedWatchpointsUsage = true;
            LLDBUsageTracker.sessionUsedWatchpoints();
        }
        return super.addWatchpoint(threadId, frameNumber, value, expr, lifetime, accessType);
    }

    protected void handleExited(int code) {
        super.handleExited(code);
        LLDBUsageTracker.frontendExited(code);
    }

    protected void handleAttached(int pid) {
        if (this.attachStopwatch.isRunning()) {
            this.attachStopwatch.stop();
            LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.ATTACH_TIME_MICROS, this.attachStopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
        super.handleAttached(pid);
    }

    @NotNull
    public List<LLBreakpoint> addBreakpoint(String path, int line, @Nullable String condition) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        List ret = super.addBreakpoint(path, line, condition);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.ADD_BREAKPOINT_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        LLSymbolicBreakpoint ret = super.addSymbolicBreakpoint(symBreakpoint);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.ADD_SYMBOLIC_BREAKPOINT_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        DebuggerDriver.ResultList ret = super.getFrames(threadId, from, count, untilFirstLineWithCode);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.GET_FRAMES_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        List ret = super.getVariables(threadId, frameIndex);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.GET_VARIABLES_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        DebuggerDriver.ResultList ret = super.getVariableChildren(value, from, count);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.GET_VARIABLE_CHILDREN_RANGE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    public void stepOver(@Nullable Boolean stepByInstruction) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        super.stepOver(stepByInstruction);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
    }

    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo, @Nullable Boolean stepByInstruction) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        super.stepInto(forceStepIntoFramesWithNoDebugInfo, stepByInstruction);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
    }

    public void stepOut() throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        super.stepOut();
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
    }

    public boolean resume() throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        boolean ret = super.resume();
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    public Pair<String, Boolean> executeConsoleCommandWithOutput(long threadId, int frameIndex, String command) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleConsoleCommand((long)threadId, (int)frameIndex, (String)command);
        Ref result = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)request, Protocol.HandleConsoleCommand_Res.class, res -> {
            if (res.hasOut()) {
                result.set((Object)Pair.create((Object)res.getOut(), (Object)true));
            }
            if (res.hasErr()) {
                result.set((Object)Pair.create((Object)res.getErr(), (Object)false));
            }
        });
        return (Pair)result.get();
    }

    public boolean supportsDisasm() {
        return (Boolean)StudioFlags.LLDB_ASSEMBLY_DEBUGGING.get();
    }

    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws ExecutionException {
        String command = "disassemble --start-address " + range.getStart().toString() + " --end-address " + range.getEndInclusive();
        Pair<String, Boolean> output = this.executeConsoleCommandWithOutput(-1L, -1, command);
        if (!((Boolean)output.getSecond()).booleanValue()) {
            throw new ExecutionException("failed to disassemble range " + range + " : " + (String)output.getFirst());
        }
        return AndroidLLDBDriver.parseLldbDisassembleOutput((String)output.getFirst());
    }

    public static List<LLInstruction> parseLldbDisassembleOutput(String raw) {
        ArrayList<LLInstruction> res = new ArrayList<LLInstruction>();
        Pattern linePattern = Pattern.compile("^\\s*(0x[a-fA-F0-9]+)\\s*<\\+([0-9]+)>:\\s*([^;]*)");
        String currentFunction = null;
        for (String line : raw.split("\n")) {
            int groupCount;
            if (line.isEmpty()) continue;
            if (line.startsWith("->")) {
                line = line.substring(2);
            } else if (line.charAt(0) != ' ') {
                currentFunction = line.substring(0, line.length() - 1);
                continue;
            }
            Matcher matcher = linePattern.matcher(line);
            if (!matcher.lookingAt() || (groupCount = matcher.groupCount()) != 3) continue;
            try {
                Address addr = Address.parseHexString((String)matcher.group(1));
            }
            catch (NumberFormatException e) {
                LOG.warn("Could not determine address for disassembled instruction", (Throwable)e);
                continue;
            }
            try {
                int functionOffset = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException e) {
                LOG.warn("Could not determine function offset for disassembled instruction", (Throwable)e);
                int n = -1;
            }
        }
        return res;
    }

    static {
        LibStdCppTypeNameFormatters.register();
    }
}

