/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidLLDBDriverConfiguration
extends LLDBDriverConfiguration {
    @NotNull
    private final NativeAndroidDebuggerState myDebuggerState;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final List<Abi> myClientABIs;
    @NotNull
    private final SessionStarter mySessionStarter;
    @NotNull
    private final List<String> myStartupCommands;
    @NotNull
    private final List<String> myPostAttachCommands;
    @NotNull
    private final File myFrameworkFile;
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDriverConfiguration.class);
    private final AndroidFacet myFacet;
    private final ConsolePrinter myPrinter;

    public AndroidLLDBDriverConfiguration(@NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull ConsolePrinter consolePrinter, @NotNull IDevice device, @NotNull List<Abi> clientABIs, @NotNull SessionStarter sessionStarter, @NotNull List<String> startupCommands, @NotNull List<String> postAttachCommands) {
        this.myFacet = facet;
        this.myDebuggerState = debuggerState;
        this.myPrinter = consolePrinter;
        this.myDevice = device;
        this.myClientABIs = clientABIs;
        this.mySessionStarter = sessionStarter;
        this.myStartupCommands = startupCommands;
        this.myPostAttachCommands = postAttachCommands;
        this.myFrameworkFile = this.findFrameworkFile();
        LOG.info("LLDB framework file: " + this.myFrameworkFile.getAbsolutePath());
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    public IDevice getDevice() {
        return this.myDevice;
    }

    @NotNull
    public List<Abi> getClientABIs() {
        return this.myClientABIs;
    }

    @NotNull
    public SessionStarter getSessionStarter() {
        return this.mySessionStarter;
    }

    @NotNull
    public List<String> getStartupCommands() {
        return this.myStartupCommands;
    }

    @NotNull
    public List<String> getPostAttachCommands() {
        return this.myPostAttachCommands;
    }

    @NotNull
    public DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler handler) throws ExecutionException {
        return new AndroidLLDBDriver(handler, this.myFacet, this.myDebuggerState, this, this.myPrinter);
    }

    @NotNull
    private static File getLLDBHostFile(@NotNull String relativePath) {
        return ModulePathManager.getLldbHostFile(relativePath);
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        return AndroidLLDBDriverConfiguration.getLLDBHostFile(new File("bin", relativePath).getPath());
    }

    @NotNull
    private static File getLLDBLibDir() {
        return AndroidLLDBDriverConfiguration.getLLDBHostFile(new File("lib").getPath());
    }

    @NotNull
    private File findFrameworkFile() {
        if (SystemInfo.isWindows) {
            return this.getLLDBBinFile("liblldb.dll");
        }
        File[] libFiles = AndroidLLDBDriverConfiguration.getLLDBLibDir().listFiles(pathname -> pathname.getName().startsWith("liblldb."));
        if (libFiles == null || libFiles.length != 1) {
            throw new RuntimeException("Found broken LLDB configuration");
        }
        return libFiles[0];
    }

    @NotNull
    protected File getLLDBFrameworkFile() {
        return this.myFrameworkFile;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result) {
        File libStdCxxPrinterPath;
        File ndkPath;
        Project project;
        String workingDir = this.myDebuggerState.getWorkingDir();
        if (!workingDir.isEmpty()) {
            result.withWorkDirectory(workingDir);
        }
        if (!GradleProjectInfo.getInstance((Project)(project = this.myFacet.getModule().getProject())).isBuildWithGradle()) {
            return;
        }
        Map environment = result.getEnvironment();
        File galaPath = ModulePathManager.getRepoLLDBStlPrintersFolder();
        if (galaPath.exists()) {
            environment.put("AS_GALA_PATH", galaPath.getAbsolutePath());
        }
        if ((ndkPath = IdeSdks.getInstance().getAndroidNdkPath()) != null && (libStdCxxPrinterPath = NdkHelper.getLibStdCxxPrintersPath(ndkPath, "4.9")).exists()) {
            environment.put("AS_LIBSTDCXX_PRINTER_PATH", libStdCxxPrinterPath.getAbsolutePath());
        }
    }

    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver) throws ExecutionException {
        File lldbFrameworkFile = this.getLLDBFrameworkFile();
        if (!lldbFrameworkFile.exists()) {
            throw new ExecutionException(lldbFrameworkFile + " not found");
        }
        File frontendExecutable = this.getLLDBBinFile(SystemInfo.isWindows ? "LLDBFrontend.exe" : "LLDBFrontend");
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(frontendExecutable.getAbsolutePath() + " not found");
        }
        GeneralCommandLine result = new GeneralCommandLine();
        result.setExePath(frontendExecutable.getAbsolutePath());
        result.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        AndroidLLDBDriverConfiguration.setupCommonParameters((GeneralCommandLine)result);
        Map env = result.getEnvironment();
        if (SystemInfo.isLinux) {
            env.put("LD_LIBRARY_PATH", AndroidLLDBDriverConfiguration.getLLDBLibDir().getAbsolutePath());
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
            File pythonBinDir = CidrDebuggerPathManager.getOSXSystemPythonBinDir();
            if (pythonBinDir != null) {
                env.put("PATH", pythonBinDir.getAbsolutePath());
            }
        }
        if (!SystemInfo.isMac) {
            env.put("PYTHONHOME", ModulePathManager.getLldbPythonHome().getAbsolutePath());
            String lldbPythonLibs = ModulePathManager.getLldbHostFile("lib/python").getAbsolutePath();
            Map<String, String> parentEnv = System.getenv();
            String parentPythonPath = parentEnv.get("PYTHONPATH");
            if (parentPythonPath != null) {
                env.put("PYTHONPATH", parentPythonPath + File.pathSeparator + lldbPythonLibs);
            } else {
                env.put("PYTHONPATH", lldbPythonLibs);
            }
            env.put("PYTHONDONTWRITEBYTECODE", "1");
        }
        AndroidLLDBBreakpadIntegration.setUpRunEnvironment(env);
        this.configureDriverCommandLine(result);
        return result;
    }

    public boolean isStaticVarsLoadingEnabled() {
        return this.myDebuggerState.showStaticVars();
    }

    public boolean isOptimizedWarningEnabled() {
        return this.myDebuggerState.showOptimizedWarning();
    }

    public void disableOptimizedWarning() {
        this.myDebuggerState.setShowOptimizedWarning(false);
    }
}

