/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.execution.debugger.memory.disasm.DisasmFileType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocatableLightVfs
extends DeprecatedVirtualFileSystem
implements NonPhysicalFileSystem {
    private static final Logger LOG = Logger.getInstance(LocatableLightVfs.class);
    private final Map<String, LocatableLightVirtualFile> myFileMap = new HashMap<String, LocatableLightVirtualFile>();
    private static final String PROTOCOL = "locatable_light";

    public static LocatableLightVfs getInstance() {
        return (LocatableLightVfs)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    public static LocatableLightVirtualFile create(@NotNull String name) {
        return LocatableLightVfs.getInstance().createFile(name);
    }

    @Nullable
    private synchronized LocatableLightVirtualFile createFile(@NotNull String name) {
        if (name.isEmpty()) {
            LOG.warn("Attempt to create a file with empty name");
            return null;
        }
        String keyName = '/' + name;
        if (this.myFileMap.containsKey(keyName)) {
            for (int counter = 2; counter < 1000; ++counter) {
                String dedupKeyName = keyName + " (" + counter + ')';
                if (this.myFileMap.containsKey(dedupKeyName)) continue;
                LocatableLightVirtualFile res = new LocatableLightVirtualFile(name + " (" + counter + ')');
                this.myFileMap.put(dedupKeyName, res);
                return res;
            }
            LOG.warn("Giving up creating locatable light virtual file with name \"" + name + '\"');
            return null;
        }
        LocatableLightVirtualFile res = new LocatableLightVirtualFile(name);
        this.myFileMap.put(keyName, res);
        return res;
    }

    @Nullable
    public synchronized VirtualFile findFileByPath(@NotNull String path) {
        return (VirtualFile)this.myFileMap.get(path);
    }

    public synchronized void deleteFile(Object requestor, @NotNull VirtualFile file) {
        this.myFileMap.remove(file.getPath());
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return this.findFileByPath(path);
    }

    public static class LocatableLightVirtualFile
    extends LightVirtualFile {
        private LocatableLightVirtualFile(String name) {
            super(name, (FileType)DisasmFileType.INSTANCE, (CharSequence)"");
        }

        @NotNull
        public LocatableLightVfs getFileSystem() {
            return LocatableLightVfs.getInstance();
        }

        public void delete(Object requestor) {
            LocatableLightVfs.getInstance().deleteFile(requestor, (VirtualFile)this);
        }
    }
}

