/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.AndroidNativeDeviceException;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.ShellSessionStarterImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class RunAsSessionStarterImpl
extends ShellSessionStarterImpl {
    private static final Logger LOG = Logger.getInstance(RunAsSessionStarterImpl.class);
    private final ClientShellHelper myClientShellHelper;

    public RunAsSessionStarterImpl(@NotNull Client client, @NotNull ClientShellHelper clientShellHelper, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull ProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        super(client, clientShellHelper, localServerFile, localStartScriptFile, debuggerState, progressReporter, launchStatus, printer);
        this.myClientShellHelper = clientShellHelper;
    }

    @Override
    @NotNull
    protected String executeCommand(@NotNull String command, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, AndroidNativeDeviceException {
        String output = super.executeCommand(command, maxTimeToOutputResponse, maxTimeUnits);
        String runAsBrokenMessage = String.format("run-as: Package '%s' is unknown", this.myClientShellHelper.getPackageName());
        if (output.startsWith(runAsBrokenMessage)) {
            String errorMessage = "run-as is broken (please see http://b.android.com/187955 for details)";
            LOG.error("run-as is broken (please see http://b.android.com/187955 for details)");
            throw new AndroidNativeDeviceException("run-as is broken (please see http://b.android.com/187955 for details)");
        }
        return output;
    }

    @Override
    @NotNull
    protected String getClientCommand(@NotNull String command) {
        return this.myClientShellHelper.getRunAsCommand(command);
    }
}

