/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell.protocol;

import com.intellij.execution.jshell.protocol.Endpoint;
import com.intellij.execution.jshell.protocol.Message;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Base64;

public class MessageWriter<T extends Message>
extends Endpoint {
    private final BufferedWriter myOut;

    public MessageWriter(OutputStream output) {
        this.myOut = new BufferedWriter(new OutputStreamWriter(output));
    }

    public void send(T message) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(buffer);){
            oos.writeObject(message);
        }
        String data = Base64.getEncoder().encodeToString(buffer.toByteArray());
        this.myOut.newLine();
        this.myOut.write("__#begin#__");
        this.myOut.newLine();
        this.myOut.write(data);
        this.myOut.newLine();
        this.myOut.write("__#end#__");
        this.myOut.newLine();
        this.myOut.flush();
    }
}

