/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import gnu.trove.THashSet;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.ReadOnlySourceManager;
import org.jetbrains.settingsRepository.ReadonlySource;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryClientImpl;
import org.jetbrains.settingsRepository.git.Pull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\r\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\bJ\u001a\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/settingsRepository/ReadOnlySourceManager;", "", "icsManager", "Lorg/jetbrains/settingsRepository/IcsManager;", "rootDir", "Ljava/nio/file/Path;", "(Lorg/jetbrains/settingsRepository/IcsManager;Ljava/nio/file/Path;)V", "repositories", "", "Lorg/eclipse/jgit/lib/Repository;", "getRepositories", "()Ljava/util/List;", "repositoryList", "org/jetbrains/settingsRepository/ReadOnlySourceManager$repositoryList$1", "Lorg/jetbrains/settingsRepository/ReadOnlySourceManager$repositoryList$1;", "getRootDir", "()Ljava/nio/file/Path;", "setSources", "", "sources", "Lorg/jetbrains/settingsRepository/ReadonlySource;", "update", "", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.settingsRepository"})
public final class ReadOnlySourceManager {
    private final repositoryList.1 repositoryList;
    private final IcsManager icsManager;
    @NotNull
    private final Path rootDir;

    @NotNull
    public final List<Repository> getRepositories() {
        return (List)this.repositoryList.getValue();
    }

    public final void setSources(@NotNull List<ReadonlySource> sources) {
        this.icsManager.getSettings().setReadOnlySources(sources);
        this.repositoryList.drop();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Set<String> update(@Nullable ProgressIndicator indicator) {
        void changedRootDirs;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Function1<String, Unit> addChangedPath$ = new Function1<String, Unit>((Ref.ObjectRef)changedRootDirs){
            final /* synthetic */ Ref.ObjectRef $changedRootDirs;

            public final void invoke(@Nullable String path) {
                if (path == null || Intrinsics.areEqual((Object)path, (Object)"/dev/null")) {
                    return;
                }
                int firstSlash = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
                if (firstSlash < 0) {
                    firstSlash = StringsKt.indexOf$default((CharSequence)path, (char)'\\', (int)0, (boolean)false, (int)6, null);
                }
                if (firstSlash > 0) {
                    if ((Set)this.$changedRootDirs.element == null) {
                        this.$changedRootDirs.element = (Set)new THashSet();
                    }
                    Set set = (Set)this.$changedRootDirs.element;
                    if (set == null) {
                        Intrinsics.throwNpe();
                    }
                    String string = path;
                    int n = 0;
                    Set set2 = set;
                    String string2 = string.substring(n, firstSlash);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string3 = string2;
                    set2.add(string3);
                }
            }
            {
                this.$changedRootDirs = objectRef;
                super(1);
            }
        };
        for (Repository repo : this.getRepositories()) {
            ProgressIndicator progressIndicator = indicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            Logger $receiver$iv = IcsManagerKt.getLOG();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                boolean bl = false;
                String string = "Pull changes from read-only repo " + GitExKt.getUpstream(repo);
                logger.debug(string, (Throwable)e$iv);
            }
            Pull.fetch$default(new Pull(new GitRepositoryClientImpl(repo, this.icsManager.getCredentialsStore()), indicator, null, 4, null), null, (Function1)new Function1<TrackingRefUpdate, Unit>(repo, addChangedPath$){
                final /* synthetic */ Repository $repo;
                final /* synthetic */ update.1 $addChangedPath$1;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull TrackingRefUpdate refUpdate) {
                    DiffFormatter diffFormatter = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
                    diffFormatter.setRepository(this.$repo);
                    AutoCloseable $receiver$iv = (AutoCloseable)diffFormatter;
                    boolean $i$f$use = false;
                    boolean closed$iv = false;
                    try {
                        DiffFormatter it = (DiffFormatter)$receiver$iv;
                        boolean bl = false;
                        List result = diffFormatter.scan((AnyObjectId)refUpdate.getOldObjectId(), (AnyObjectId)refUpdate.getNewObjectId());
                        for (DiffEntry e : result) {
                            if (e.getChangeType() == DiffEntry.ChangeType.DELETE) {
                                this.$addChangedPath$1.invoke(e.getOldPath());
                                continue;
                            }
                            this.$addChangedPath$1.invoke(e.getOldPath());
                            this.$addChangedPath$1.invoke(e.getNewPath());
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Exception e$iv) {
                        try {
                            closed$iv = true;
                            try {
                                $receiver$iv.close();
                            }
                            catch (Exception closeException$iv) {
                                Exception exception = e$iv;
                                if (exception == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                                }
                                ((Throwable)exception).addSuppressed(closeException$iv);
                            }
                            throw (Throwable)e$iv;
                        }
                        catch (Throwable throwable) {
                            if (!closed$iv) {
                                $receiver$iv.close();
                            }
                            throw throwable;
                        }
                    }
                    $receiver$iv.close();
                }
                {
                    this.$repo = repository2;
                    this.$addChangedPath$1 = var2_2;
                    super(1);
                }
            }, 1, null);
        }
        return (Set)changedRootDirs.element;
    }

    @Nullable
    public static /* synthetic */ Set update$default(ReadOnlySourceManager readOnlySourceManager, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 1) != 0) {
            progressIndicator = null;
        }
        return readOnlySourceManager.update(progressIndicator);
    }

    @NotNull
    public final Path getRootDir() {
        return this.rootDir;
    }

    public ReadOnlySourceManager(@NotNull IcsManager icsManager2, @NotNull Path rootDir) {
        this.icsManager = icsManager2;
        this.rootDir = rootDir;
        this.repositoryList = new AtomicClearableLazyValue<List<? extends Repository>>(this){
            final /* synthetic */ ReadOnlySourceManager this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected List<Repository> compute() {
                List list;
                if (ReadOnlySourceManager.access$getIcsManager$p(this.this$0).getSettings().getReadOnlySources().isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                Collection $receiver$iv = ReadOnlySourceManager.access$getIcsManager$p(this.this$0).getSettings().getReadOnlySources();
                boolean $i$f$mapSmartNotNull = false;
                int size$iv = $receiver$iv.size();
                if (size$iv == 1) {
                    Repository repository2;
                    block18: {
                        Object v2;
                        ReadonlySource source = (ReadonlySource)CollectionsKt.first((Iterable)$receiver$iv);
                        boolean bl = false;
                        Logger $receiver$iv2 = IcsManagerKt.getLOG();
                        boolean $i$f$runAndLogException = false;
                        try {
                            boolean bl2 = false;
                            if (!source.getActive()) {
                                repository2 = null;
                                break block18;
                            }
                            String string = source.getPath();
                            if (string == null) {
                                repository2 = null;
                                break block18;
                            }
                            String path = string;
                            Path dir = this.this$0.getRootDir().resolve(path);
                            if (PathKt.exists((Path)dir)) {
                                repository2 = GitExKt.buildBareRepository(dir);
                                break block18;
                            }
                            IcsManagerKt.getLOG().warn("Skip read-only source " + source.getUrl() + " because dir doesn't exist");
                            v2 = null;
                        }
                        catch (ProcessCanceledException e$iv) {
                            throw (Throwable)e$iv;
                        }
                        catch (Throwable e$iv) {
                            $receiver$iv2.error(e$iv);
                            v2 = null;
                        }
                        repository2 = v2;
                    }
                    if (repository2 != null) {
                        Repository repository3;
                        Repository it$iv = repository3 = repository2;
                        boolean bl = false;
                        list = (List)new SmartList((Object)it$iv);
                    } else {
                        list = (List)new SmartList();
                    }
                } else {
                    void $receiver$iv$iv;
                    Iterable iterable = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>(size$iv);
                    void $receiver$iv$iv$iv = $receiver$iv$iv;
                    Iterator<T> iterator = $receiver$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Repository repository4;
                        Repository repository5;
                        block19: {
                            Object v5;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            ReadonlySource source = (ReadonlySource)element$iv$iv;
                            boolean bl = false;
                            Logger $receiver$iv3 = IcsManagerKt.getLOG();
                            boolean $i$f$runAndLogException = false;
                            try {
                                String path;
                                boolean bl3 = false;
                                if (!source.getActive()) {
                                    repository5 = null;
                                    break block19;
                                }
                                if (source.getPath() == null) {
                                    repository5 = null;
                                    break block19;
                                }
                                Path dir = this.this$0.getRootDir().resolve(path);
                                if (PathKt.exists((Path)dir)) {
                                    repository5 = GitExKt.buildBareRepository(dir);
                                    break block19;
                                }
                                IcsManagerKt.getLOG().warn("Skip read-only source " + source.getUrl() + " because dir doesn't exist");
                                v5 = null;
                            }
                            catch (ProcessCanceledException e$iv) {
                                throw (Throwable)e$iv;
                            }
                            catch (Throwable e$iv) {
                                $receiver$iv3.error(e$iv);
                                v5 = null;
                            }
                            repository5 = v5;
                        }
                        if (repository5 == null) continue;
                        Repository it$iv$iv = repository4 = repository5;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                }
                return list;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ IcsManager access$getIcsManager$p(ReadOnlySourceManager $this) {
        return $this.icsManager;
    }
}

