/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.git.AddFile;
import org.jetbrains.settingsRepository.git.CommitMessageFormatter;
import org.jetbrains.settingsRepository.git.DirCacheEditorKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a0\u0010\f\u001a\u00020\r*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0001H\u0002\u001a&\u0010\u0014\u001a\u00020\r*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002\u00a8\u0006\u0015"}, d2={"commit", "", "repository", "Lorg/eclipse/jgit/lib/Repository;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "commitMessageFormatter", "Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;", "indexDiffToString", "", "diff", "Lorg/eclipse/jgit/lib/IndexDiff;", "addList", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "name", "list", "", "compact", "appendCompactList", "intellij.settingsRepository"})
public final class CommitKt {
    public static final boolean commit(@NotNull Repository repository2, @Nullable ProgressIndicator indicator, @NotNull CommitMessageFormatter commitMessageFormatter) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        IndexDiff diff = GitExKt.computeIndexDiff(repository2);
        ProgressIndicator progressIndicator2 = indicator;
        boolean changed = diff.diff((ProgressMonitor)(progressIndicator2 != null ? JGitProgressMonitorKt.asProgressMonitor(progressIndicator2) : null), 0, 0, "Commit");
        if (!changed || diff.getAdded().isEmpty() && diff.getChanged().isEmpty() && diff.getRemoved().isEmpty()) {
            if (diff.getModified().isEmpty() && diff.getMissing().isEmpty()) {
                IcsManagerKt.getLOG().debug("Nothing to commit");
                return false;
            }
            List edits = null;
            for (String path : diff.getModified()) {
                if (StringsKt.startsWith$default((String)path, (String)"_projects/", (boolean)false, (int)2, null)) continue;
                if (edits == null) {
                    edits = (List)new SmartList();
                }
                edits.add(new AddFile(path));
            }
            for (String path : diff.getMissing()) {
                if (edits == null) {
                    edits = (List)new SmartList();
                }
                edits.add(DirCacheEditorKt.DeleteFile(path));
            }
            if (edits != null) {
                DirCacheEditorKt.edit(repository2, edits);
            }
        }
        Logger $receiver$iv = IcsManagerKt.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            boolean bl = false;
            String string = CommitKt.indexDiffToString(diff);
            logger.debug(string, (Throwable)e$iv);
        }
        ProgressIndicator progressIndicator3 = indicator;
        if (progressIndicator3 != null) {
            progressIndicator3.checkCanceled();
        }
        StringBuilder builder = CommitMessageFormatter.DefaultImpls.prependMessage$default(commitMessageFormatter, null, 1, null);
        CommitKt.appendCompactList(builder, "Update", diff.getChanged());
        CommitKt.appendCompactList(builder, "Create", diff.getAdded());
        CommitKt.appendCompactList(builder, "Delete", diff.getRemoved());
        GitExKt.commit$default(repository2, builder.toString(), null, null, null, 14, null);
        return true;
    }

    public static /* synthetic */ boolean commit$default(Repository repository2, ProgressIndicator progressIndicator, CommitMessageFormatter commitMessageFormatter, int n, Object object) {
        if ((n & 4) != 0) {
            commitMessageFormatter = new IdeaCommitMessageFormatter();
        }
        return CommitKt.commit(repository2, progressIndicator, commitMessageFormatter);
    }

    private static final String indexDiffToString(IndexDiff diff) {
        StringBuilder builder = new StringBuilder();
        builder.append("To commit:");
        CommitKt.addList$default(builder, "Added", diff.getAdded(), false, 4, null);
        CommitKt.addList$default(builder, "Changed", diff.getChanged(), false, 4, null);
        CommitKt.addList$default(builder, "Deleted", diff.getRemoved(), false, 4, null);
        CommitKt.addList$default(builder, "Modified on disk relative to the index", diff.getModified(), false, 4, null);
        CommitKt.addList$default(builder, "Untracked files", diff.getUntracked(), false, 4, null);
        CommitKt.addList$default(builder, "Untracked folders", diff.getUntrackedFolders(), false, 4, null);
        CommitKt.addList$default(builder, "Missing", diff.getMissing(), false, 4, null);
        return builder.toString();
    }

    private static final void appendCompactList(@NotNull StringBuilder $receiver, String name, Collection<String> list) {
        CommitKt.addList($receiver, name, list, true);
    }

    private static final void addList(@NotNull StringBuilder $receiver, String name, Collection<String> list, boolean compact) {
        if (list.isEmpty()) {
            return;
        }
        if (compact) {
            if ($receiver.length() != 0 && $receiver.charAt($receiver.length() - 1) != ' ') {
                $receiver.append('\t');
            }
            $receiver.append(name);
        } else {
            $receiver.append('\t').append(name).append(':');
        }
        $receiver.append(' ');
        boolean isNotFirst = false;
        for (String path : list) {
            if (isNotFirst) {
                $receiver.append(',').append(' ');
            } else {
                isNotFirst = true;
            }
            $receiver.append(compact ? PathUtilRt.getFileName((String)path) : path);
        }
    }

    static /* synthetic */ void addList$default(StringBuilder stringBuilder, String string, Collection collection, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        CommitKt.addList(stringBuilder, string, collection, bl);
    }
}

