/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.credentialStore.Credentials;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsManagerKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"canUseGitExe", "", "getCredentialsUsingGit", "Lcom/intellij/credentialStore/Credentials;", "uri", "Lorg/eclipse/jgit/transport/URIish;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "intellij.settingsRepository"})
public final class GitCredentialKt {
    private static boolean canUseGitExe = true;

    @Nullable
    public static final Credentials getCredentialsUsingGit(@NotNull URIish uri, @NotNull Repository repository2) {
        if (!canUseGitExe || repository2.getConfig().getSubsections("credential").isEmpty()) {
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"git", "credential", "fill"});
        Process process = null;
        try {
            process = commandLine.createProcess();
        }
        catch (ProcessNotCreatedException e) {
            canUseGitExe = false;
            return null;
        }
        OutputStream outputStream = process.getOutputStream();
        Object object = Charsets.UTF_8;
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, (Charset)object);
        writer.write("url=");
        writer.write(uri.toPrivateString());
        writer.write("\n\n");
        writer.close();
        object = process.getInputStream();
        Charset charset = Charsets.UTF_8;
        Object object2 = object;
        object2 = new InputStreamReader((InputStream)object2, charset);
        int n = 8192;
        BufferedReader reader = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        Object username = null;
        Object password = null;
        while (true) {
            String line;
            String string;
            String string2 = reader.readLine();
            if (string2 != null) {
                Object object3 = object2 = string2;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
            } else {
                string = line = null;
            }
            if (line == null || (object2 = (CharSequence)line).length() == 0) break;
            Function0<String> readValue$ = new Function0<String>(line){
                final /* synthetic */ String $line;

                @NotNull
                public final String invoke() {
                    String string = this.$line;
                    int n = StringsKt.indexOf$default((CharSequence)this.$line, (char)'=', (int)0, (boolean)false, (int)6, null) + 1;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    String string4 = string = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    return ((Object)StringsKt.trim((CharSequence)string4)).toString();
                }
                {
                    this.$line = string;
                    super(0);
                }
            };
            if (StringsKt.startsWith$default((String)line, (String)"username=", (boolean)false, (int)2, null)) {
                username = readValue$.invoke();
                continue;
            }
            if (!StringsKt.startsWith$default((String)line, (String)"password=", (boolean)false, (int)2, null)) continue;
            password = readValue$.invoke();
        }
        reader.close();
        object2 = process.getErrorStream();
        Charset charset2 = Charsets.UTF_8;
        String errorText = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)object2, charset2));
        object2 = errorText;
        if (object2.length() > 0) {
            IcsManagerKt.getLOG().warn(errorText);
        }
        return username == null && password == null ? null : new Credentials((String)username, (String)password);
    }
}

