/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.StringKt;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.IcsCredentialsStore;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.git.InputStreamWrapper;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u00ae\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a2\u0010\b\u001a\u00020\u00022\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\f\u001a\u00020\u000b\u001a2\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00072\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0007\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u001a\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 \u001a:\u0010!\u001a\u00020\"*\u00020\u00022\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010&\u001a\n\u0010(\u001a\u00020)*\u00020\u0002\u001a\n\u0010*\u001a\u00020\u0002*\u00020\u0002\u001a,\u0010+\u001a\u0004\u0018\u00010\u0019*\u00020\u00022\u0006\u0010,\u001a\u00020-2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a\n\u0010/\u001a\u000200*\u00020\u0002\u001a\n\u00101\u001a\u00020\u0001*\u000202\u001aq\u00103\u001a\u00020\u001e*\u00020\u00022\u0006\u00104\u001a\u00020\u00012%\b\u0002\u00105\u001a\u001f\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(8\u0012\u0004\u0012\u00020\u000b\u0018\u00010626\u00109\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(8\u0012\u0013\u0012\u00110;\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(<\u0012\u0004\u0012\u00020\u000b0:\u001a\u0014\u0010=\u001a\u0004\u0018\u00010;*\u00020\u00022\u0006\u00104\u001a\u00020\u0001\u001a\n\u0010>\u001a\u00020?*\u00020\u0002\u001a\u001c\u0010@\u001a\u00020A*\u00020\u00022\b\u0010B\u001a\u0004\u0018\u00010\u00012\u0006\u0010C\u001a\u00020\u0001\u001a6\u0010D\u001a\u0002HE\"\b\b\u0000\u0010F*\u00020G\"\u0004\b\u0001\u0010E*\u0002HF2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u0002HF\u0012\u0004\u0012\u0002HE06H\u0086\b\u00a2\u0006\u0002\u0010I\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006J"}, d2={"upstream", "", "Lorg/eclipse/jgit/lib/Repository;", "getUpstream", "(Lorg/eclipse/jgit/lib/Repository;)Ljava/lang/String;", "buildBareRepository", "gitDir", "Ljava/nio/file/Path;", "buildRepository", "workTree", "bare", "", "mustExists", "cloneBare", "uri", "dir", "credentialsStore", "Lkotlin/Lazy;", "Lorg/jetbrains/settingsRepository/IcsCredentialsStore;", "progressMonitor", "Lorg/eclipse/jgit/lib/ProgressMonitor;", "createBareRepository", "findBranchToCheckout", "Lorg/eclipse/jgit/lib/Ref;", "result", "Lorg/eclipse/jgit/transport/FetchResult;", "getDefaultBranch", "credentialsProvider", "Lorg/jetbrains/settingsRepository/git/JGitCredentialsProvider;", "wrapIfNeedAndReThrow", "", "e", "Lorg/eclipse/jgit/errors/TransportException;", "commit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "message", "reflogComment", "author", "Lorg/eclipse/jgit/lib/PersonIdent;", "committer", "computeIndexDiff", "Lorg/eclipse/jgit/lib/IndexDiff;", "disableAutoCrLf", "fetch", "remoteConfig", "Lorg/eclipse/jgit/transport/RemoteConfig;", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "getAheadCommitsCount", "", "getRemoteBranchFullName", "Lorg/eclipse/jgit/lib/Config;", "processChildren", "path", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function2;", "Ljava/io/InputStream;", "inputStream", "read", "resetHard", "Lorg/eclipse/jgit/dircache/DirCacheCheckout;", "setUpstream", "Lorg/eclipse/jgit/lib/StoredConfig;", "url", "remoteBranchName", "use", "R", "T", "Ljava/lang/AutoCloseable;", "block", "(Ljava/lang/AutoCloseable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.settingsRepository"})
public final class GitExKt {
    public static final void wrapIfNeedAndReThrow(@NotNull TransportException e) {
        if (e instanceof org.eclipse.jgit.errors.NoRemoteRepositoryException || e.getStatus() == TransportException.Status.CANNOT_RESOLVE_REPO) {
            throw (Throwable)new NoRemoteRepositoryException(e);
        }
        String string = e.getMessage();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String message = string;
        if (e.getStatus() == TransportException.Status.NOT_AUTHORIZED || e.getStatus() == TransportException.Status.NOT_PERMITTED || StringsKt.contains$default((CharSequence)message, (CharSequence)JGitText.get().notAuthorized, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"Auth cancel", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"Auth fail", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)": reject HostKey:", (boolean)false, (int)2, null)) {
            throw (Throwable)new AuthenticationException(e);
        }
        if (e.getStatus() == TransportException.Status.CANCELLED || Intrinsics.areEqual((Object)message, (Object)"Download cancelled")) {
            throw (Throwable)new ProcessCanceledException();
        }
        throw (Throwable)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final FetchResult fetch(@NotNull Repository $receiver, @NotNull RemoteConfig remoteConfig, @Nullable CredentialsProvider credentialsProvider2, @Nullable ProgressMonitor progressMonitor) {
        try {
            FetchResult fetchResult;
            AutoCloseable $receiver$iv = (AutoCloseable)Transport.open((Repository)$receiver, (RemoteConfig)remoteConfig);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                Transport transport = (Transport)$receiver$iv;
                boolean bl = false;
                transport.setCredentialsProvider(credentialsProvider2);
                transport.setRemoveDeletedRefs(true);
                ProgressMonitor progressMonitor2 = progressMonitor;
                if (progressMonitor2 == null) {
                    progressMonitor2 = (ProgressMonitor)NullProgressMonitor.INSTANCE;
                }
                fetchResult = transport.fetch(progressMonitor2, null);
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        $receiver$iv.close();
                    }
                    catch (Exception closeException$iv) {
                        Exception exception = e$iv;
                        if (exception == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                        }
                        ((Throwable)exception).addSuppressed(closeException$iv);
                    }
                    throw (Throwable)e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $receiver$iv.close();
                    }
                    throw throwable;
                }
            }
            $receiver$iv.close();
            return fetchResult;
        }
        catch (TransportException e) {
            String message;
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.startsWith$default((String)(message = string), (String)"Remote does not have ", (boolean)false, (int)2, null)) {
                IcsManagerKt.getLOG().warn(message);
                return null;
            }
            GitExKt.wrapIfNeedAndReThrow(e);
            return null;
        }
    }

    @Nullable
    public static /* synthetic */ FetchResult fetch$default(Repository repository2, RemoteConfig remoteConfig, CredentialsProvider credentialsProvider2, ProgressMonitor progressMonitor, int n, Object object) {
        if ((n & 2) != 0) {
            credentialsProvider2 = null;
        }
        if ((n & 4) != 0) {
            progressMonitor = null;
        }
        return GitExKt.fetch(repository2, remoteConfig, credentialsProvider2, progressMonitor);
    }

    @NotNull
    public static final Repository disableAutoCrLf(@NotNull Repository $receiver) {
        StoredConfig config = $receiver.getConfig();
        config.setString("core", null, "autocrlf", "false");
        config.save();
        return $receiver;
    }

    @NotNull
    public static final RevCommit commit(@NotNull Repository $receiver, @Nullable String message, @Nullable String reflogComment, @Nullable PersonIdent author, @Nullable PersonIdent committer) {
        CommitCommand commitCommand = new CommitCommand($receiver).setAuthor(author).setCommitter(committer);
        if (message != null) {
            commitCommand.setMessage(message);
        }
        if (reflogComment != null) {
            commitCommand.setReflogComment(reflogComment);
        }
        return commitCommand.call();
    }

    @NotNull
    public static /* synthetic */ RevCommit commit$default(Repository repository2, String string, String string2, PersonIdent personIdent, PersonIdent personIdent2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            personIdent = null;
        }
        if ((n & 8) != 0) {
            personIdent2 = null;
        }
        return GitExKt.commit(repository2, string, string2, personIdent, personIdent2);
    }

    @NotNull
    public static final DirCacheCheckout resetHard(@NotNull Repository $receiver) {
        ResetCommand resetCommand = new ResetCommand($receiver).setMode(ResetCommand.ResetType.HARD);
        resetCommand.call();
        DirCacheCheckout dirCacheCheckout = resetCommand.getDirCacheCheckout();
        if (dirCacheCheckout == null) {
            Intrinsics.throwNpe();
        }
        return dirCacheCheckout;
    }

    @NotNull
    public static final String getRemoteBranchFullName(@NotNull Config $receiver) {
        String name = $receiver.getString("branch", "master", "merge");
        if (StringUtil.isEmpty((String)name)) {
            throw (Throwable)new IllegalStateException("branch.master.merge refspec must be specified");
        }
        String string = name;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Nullable
    public static final String getUpstream(@NotNull Repository $receiver) {
        return StringKt.nullize$default((String)$receiver.getConfig().getString("remote", "origin", "url"), (boolean)false, (int)1, null);
    }

    @NotNull
    public static final StoredConfig setUpstream(@NotNull Repository $receiver, @Nullable String url, @NotNull String remoteBranchName) {
        String localBranchName = "master";
        StoredConfig config = $receiver.getConfig();
        String remoteName = "origin";
        CharSequence charSequence = url;
        if (charSequence == null || charSequence.length() == 0) {
            IcsManagerKt.getLOG().debug("Unset remote");
            config.unsetSection("remote", remoteName);
            config.unsetSection("branch", localBranchName);
        } else {
            IcsManagerKt.getLOG().debug("Set remote " + url);
            config.setString("remote", remoteName, "url", url);
            char c = '+';
            String string = "refs/heads/";
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "fetch";
            String string3 = remoteName;
            String string4 = "remote";
            StoredConfig storedConfig = config;
            String string5 = String.valueOf(c) + string;
            storedConfig.setString(string4, string3, string2, stringBuilder.append(string5).append(remoteBranchName).append(':').append("refs/remotes/").append(remoteName).append('/').append(remoteBranchName).toString());
            config.setString("branch", localBranchName, "remote", remoteName);
            config.setString("branch", localBranchName, "merge", "refs/heads/" + remoteBranchName);
        }
        config.save();
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final IndexDiff computeIndexDiff(@NotNull Repository $receiver) {
        FileTreeIterator workingTreeIterator = new FileTreeIterator($receiver);
        try {
            IndexDiff indexDiff = new IndexDiff($receiver, "HEAD", (WorkingTreeIterator)workingTreeIterator);
            return indexDiff;
        }
        finally {
            workingTreeIterator.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Repository cloneBare(@NotNull String uri, @NotNull Path dir, @Nullable Lazy<IcsCredentialsStore> credentialsStore2, @NotNull ProgressMonitor progressMonitor) {
        RevWalk it;
        Repository repository2 = GitExKt.createBareRepository(dir);
        JGitCredentialsProvider credentialsProvider2 = credentialsStore2 == null ? null : new JGitCredentialsProvider(credentialsStore2, repository2);
        String string = GitExKt.getDefaultBranch(uri, credentialsProvider2);
        if (string == null) {
            string = "master";
        }
        StoredConfig config = GitExKt.setUpstream(repository2, uri, string);
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, "origin");
        FetchResult fetchResult = GitExKt.fetch(repository2, remoteConfig, credentialsProvider2, progressMonitor);
        if (fetchResult == null) {
            return repository2;
        }
        FetchResult result = fetchResult;
        Ref head = GitExKt.findBranchToCheckout(result);
        if (head == null) {
            Ref ref;
            String branch = "HEAD";
            Ref ref2 = result.getAdvertisedRef(branch);
            if (ref2 == null) {
                ref2 = ref = result.getAdvertisedRef("refs/heads/" + branch);
            }
            if (ref2 == null) {
                ref = head = result.getAdvertisedRef("refs/tags/" + branch);
            }
        }
        if (head == null || head.getObjectId() == null) {
            return repository2;
        }
        if (StringsKt.startsWith$default((String)head.getName(), (String)"refs/heads/", (boolean)false, (int)2, null)) {
            RefUpdate newHead = repository2.updateRef("HEAD");
            newHead.disableRefLog();
            newHead.link(head.getName());
            String branchName = Repository.shortenRefName((String)head.getName());
            config.setString("branch", branchName, "remote", "origin");
            config.setString("branch", branchName, "merge", head.getName());
            String autoSetupRebase = config.getString("branch", null, "autosetuprebase");
            if (Intrinsics.areEqual((Object)"always", (Object)autoSetupRebase) || Intrinsics.areEqual((Object)"remote", (Object)autoSetupRebase)) {
                config.setBoolean("branch", branchName, "rebase", true);
            }
            config.save();
        }
        AutoCloseable $receiver$iv = (AutoCloseable)new RevWalk(repository2);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            it = (RevWalk)$receiver$iv;
            boolean bl = false;
            it = it.parseCommit((AnyObjectId)head.getObjectId());
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    $receiver$iv.close();
                }
                catch (Exception closeException$iv) {
                    Exception exception = e$iv;
                    if (exception == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                    }
                    ((Throwable)exception).addSuppressed(closeException$iv);
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $receiver$iv.close();
                }
                throw throwable;
            }
        }
        $receiver$iv.close();
        RevWalk commit2 = it;
        RefUpdate u = repository2.updateRef("HEAD", !StringsKt.startsWith$default((String)head.getName(), (String)"refs/heads/", (boolean)false, (int)2, null));
        u.setNewObjectId((AnyObjectId)commit2.getId());
        u.forceUpdate();
        return repository2;
    }

    @NotNull
    public static /* synthetic */ Repository cloneBare$default(String string, Path path, Lazy lazy, ProgressMonitor progressMonitor, int n, Object object) {
        if ((n & 4) != 0) {
            lazy = null;
        }
        if ((n & 8) != 0) {
            progressMonitor = (ProgressMonitor)NullProgressMonitor.INSTANCE;
        }
        return GitExKt.cloneBare(string, path, (Lazy<IcsCredentialsStore>)lazy, progressMonitor);
    }

    private static final String getDefaultBranch(String uri, JGitCredentialsProvider credentialsProvider2) {
        Map remoteRefs = ((LsRemoteCommand)new LsRemoteCommand(null).setRemote(uri).setTags(false).setCredentialsProvider((CredentialsProvider)credentialsProvider2)).callAsMap();
        Ref remoteHeadRef = (Ref)remoteRefs.get("HEAD");
        if (remoteHeadRef != null) {
            Map map = remoteRefs;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                String refName = (String)entry2.getKey();
                entry2 = entry;
                Ref ref = (Ref)entry2.getValue();
                if (ref == remoteHeadRef || !Intrinsics.areEqual((Object)ref.getObjectId(), (Object)remoteHeadRef.getObjectId())) continue;
                return StringsKt.removePrefix((String)refName, (CharSequence)"refs/heads/");
            }
        }
        return null;
    }

    private static final Ref findBranchToCheckout(FetchResult result) {
        Object v1;
        block3: {
            Ref ref = result.getAdvertisedRef("HEAD");
            if (ref == null) {
                return null;
            }
            Ref idHead = ref;
            Ref master = result.getAdvertisedRef("refs/heads/master");
            if (master != null && Intrinsics.areEqual((Object)master.getObjectId(), (Object)idHead.getObjectId())) {
                return master;
            }
            Iterable $receiver$iv = result.getAdvertisedRefs();
            for (Object element$iv : $receiver$iv) {
                Ref it = (Ref)element$iv;
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it.getName(), (String)"refs/heads/", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)it.getObjectId(), (Object)idHead.getObjectId()))) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void processChildren(@NotNull Repository $receiver, @NotNull String path, @Nullable Function1<? super String, Boolean> filter, @NotNull Function2<? super String, ? super InputStream, Boolean> processor) {
        TreeWalk rootTreeWalk;
        ObjectReader reader;
        boolean closed$iv;
        AutoCloseable $receiver$iv;
        block23: {
            block21: {
                block22: {
                    ObjectId objectId = $receiver.resolve("FETCH_HEAD");
                    if (objectId == null) {
                        return;
                    }
                    ObjectId lastCommitId = objectId;
                    $receiver$iv = (AutoCloseable)$receiver.newObjectReader();
                    boolean $i$f$use = false;
                    closed$iv = false;
                    reader = (ObjectReader)$receiver$iv;
                    boolean bl = false;
                    rootTreeWalk = TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])new AnyObjectId[]{(AnyObjectId)new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId).getTree()});
                    if (rootTreeWalk != null) break block21;
                    Logger $receiver$iv2 = IcsManagerKt.getLOG();
                    Exception e$iv = null;
                    boolean $i$f$debug = false;
                    if (!$receiver$iv2.isDebugEnabled()) break block22;
                    Logger logger = $receiver$iv2;
                    boolean bl2 = false;
                    String string = path + " not found";
                    logger.debug(string, (Throwable)e$iv);
                }
                $receiver$iv.close();
                return;
            }
            if (rootTreeWalk.isSubtree()) break block23;
            IcsManagerKt.getLOG().warn("File " + path + " is not a directory");
            $receiver$iv.close();
            return;
        }
        try {
            TreeWalk treeWalk = new TreeWalk($receiver);
            treeWalk.addTree((AnyObjectId)rootTreeWalk.getObjectId(0));
            treeWalk.setRecursive(false);
            while (treeWalk.next()) {
                boolean bl;
                FileMode fileMode = treeWalk.getFileMode(0);
                if (!Intrinsics.areEqual((Object)fileMode, (Object)FileMode.REGULAR_FILE) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.SYMLINK) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.EXECUTABLE_FILE)) continue;
                String fileName = treeWalk.getNameString();
                if (filter != null && !((Boolean)filter.invoke((Object)fileName)).booleanValue()) continue;
                ObjectLoader objectLoader = reader.open((AnyObjectId)treeWalk.getObjectId(0), 3);
                if (objectLoader.getSize() == 0L) {
                    IcsManagerKt.getLOG().warn("File " + path + " skipped because empty (length 0)");
                    continue;
                }
                AutoCloseable $receiver$iv3 = (AutoCloseable)objectLoader.openStream();
                boolean $i$f$use = false;
                boolean closed$iv2 = false;
                try {
                    ObjectStream it = (ObjectStream)$receiver$iv3;
                    boolean bl3 = false;
                    bl = (Boolean)processor.invoke((Object)fileName, (Object)it);
                }
                catch (Exception e$iv) {
                    try {
                        closed$iv2 = true;
                        try {
                            $receiver$iv3.close();
                        }
                        catch (Exception closeException$iv) {
                            Exception exception = e$iv;
                            if (exception == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                            }
                            ((Throwable)exception).addSuppressed(closeException$iv);
                        }
                        throw (Throwable)e$iv;
                    }
                    catch (Throwable throwable) {
                        if (!closed$iv2) {
                            $receiver$iv3.close();
                        }
                        throw throwable;
                    }
                }
                $receiver$iv3.close();
                if (bl) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    $receiver$iv.close();
                }
                catch (Exception closeException$iv) {
                    Exception exception = e$iv;
                    if (exception == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                    }
                    ((Throwable)exception).addSuppressed(closeException$iv);
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $receiver$iv.close();
                }
                throw throwable;
            }
        }
        $receiver$iv.close();
    }

    public static /* synthetic */ void processChildren$default(Repository repository2, String string, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        GitExKt.processChildren(repository2, string, (Function1<? super String, Boolean>)function1, (Function2<? super String, ? super InputStream, Boolean>)function2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final InputStream read(@NotNull Repository $receiver, @NotNull String path) {
        ObjectStream input;
        ObjectReader reader;
        block7: {
            TreeWalk treeWalk;
            boolean releaseReader;
            block6: {
                InputStream inputStream;
                ObjectId lastCommitId = $receiver.resolve("HEAD");
                if (lastCommitId == null) {
                    IcsManagerKt.getLOG().warn("Repository " + $receiver.getDirectory().getName() + " doesn't have HEAD");
                    return null;
                }
                reader = $receiver.newObjectReader();
                releaseReader = true;
                try {
                    if (TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])new AnyObjectId[]{(AnyObjectId)new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId).getTree()}) != null) break block6;
                    inputStream = null;
                }
                catch (Throwable throwable) {
                    if (releaseReader) {
                        reader.close();
                    }
                    throw throwable;
                }
                reader.close();
                return inputStream;
            }
            TreeWalk treeWalk2 = treeWalk;
            ObjectLoader objectLoader = reader.open((AnyObjectId)treeWalk2.getObjectId(0), 3);
            input = objectLoader.openStream();
            if (!objectLoader.isLarge()) break block7;
            releaseReader = false;
            InputStream inputStream = new InputStreamWrapper((InputStream)input, reader);
            return inputStream;
        }
        InputStream inputStream = (InputStream)input;
        reader.close();
        return inputStream;
    }

    public static final int getAheadCommitsCount(@NotNull Repository $receiver) {
        RevCommit revCommit;
        StoredConfig config = $receiver.getConfig();
        String shortBranchName = Repository.shortenRefName((String)GitExKt.getRemoteBranchFullName((Config)config));
        String string = new BranchConfig((Config)config, shortBranchName).getTrackingBranch();
        if (string == null) {
            return -1;
        }
        String trackingBranch = string;
        Ref ref = $receiver.exactRef("refs/heads/" + shortBranchName);
        if (ref == null) {
            return -1;
        }
        Ref local = ref;
        RevWalk walk = new RevWalk($receiver);
        RevCommit localCommit = walk.parseCommit((AnyObjectId)local.getObjectId());
        Ref ref2 = $receiver.findRef(trackingBranch);
        if (ref2 != null) {
            Ref ref3;
            Ref it = ref3 = ref2;
            boolean bl = false;
            revCommit = walk.parseCommit((AnyObjectId)it.getObjectId());
        } else {
            revCommit = null;
        }
        RevCommit trackingCommit = revCommit;
        walk.setRevFilter(RevFilter.MERGE_BASE);
        if (trackingCommit == null) {
            walk.markStart(localCommit);
            walk.sort(RevSort.REVERSE);
        } else {
            walk.markStart(localCommit);
            walk.markStart(trackingCommit);
            RevCommit mergeBase = walk.next();
            walk.reset();
            walk.markStart(localCommit);
            walk.markUninteresting(mergeBase);
        }
        walk.setRevFilter(RevFilter.ALL);
        return CollectionsKt.count((Iterable)((Iterable)walk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends AutoCloseable, R> R use(@NotNull T $receiver, @NotNull Function1<? super T, ? extends R> block) {
        Object object;
        int $i$f$use = 0;
        boolean closed = false;
        try {
            object = block.invoke($receiver);
        }
        catch (Exception e) {
            try {
                closed = true;
                try {
                    $receiver.close();
                }
                catch (Exception closeException) {
                    Exception exception = e;
                    if (exception == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                    }
                    ((Throwable)exception).addSuppressed(closeException);
                }
                throw (Throwable)e;
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                if (!closed) {
                    $receiver.close();
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart((int)1);
        $receiver.close();
        InlineMarker.finallyEnd((int)1);
        return (R)object;
    }

    @NotNull
    public static final Repository buildRepository(@Nullable Path workTree, boolean bare, @Nullable Path gitDir, boolean mustExists) {
        Path it;
        Path path;
        BaseRepositoryBuilder baseRepositoryBuilder = new FileRepositoryBuilder().setUseSystemConfig(false);
        FileRepositoryBuilder $receiver = (FileRepositoryBuilder)baseRepositoryBuilder;
        boolean bl = false;
        if (bare) {
            $receiver.setBare();
        } else {
            Path path2 = workTree;
            if (path2 != null) {
                it = path = path2;
                boolean bl2 = false;
                FileRepositoryBuilder cfr_ignored_0 = (FileRepositoryBuilder)$receiver.setWorkTree(it.toFile());
            }
        }
        Path path3 = gitDir;
        if (path3 != null) {
            it = path = path3;
            boolean bl3 = false;
            FileRepositoryBuilder cfr_ignored_1 = (FileRepositoryBuilder)$receiver.setGitDir(gitDir.toFile());
        }
        $receiver.setMustExist(mustExists);
        return $receiver.build();
    }

    @NotNull
    public static /* synthetic */ Repository buildRepository$default(Path path, boolean bl, Path path2, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            path = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            path2 = null;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return GitExKt.buildRepository(path, bl, path2, bl2);
    }

    @NotNull
    public static final Repository buildBareRepository(@NotNull Path gitDir) {
        return GitExKt.buildRepository$default(null, true, gitDir, false, 9, null);
    }

    @NotNull
    public static final Repository createBareRepository(@NotNull Path dir) {
        Repository repository2 = GitExKt.buildRepository$default(null, true, dir, false, 9, null);
        repository2.create(true);
        return repository2;
    }
}

