/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AdditionalPageAtBottomEditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.pattern.EntityUtil;
import com.maddyhome.idea.copyright.pattern.VelocityHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CopyrightConfigurable
extends NamedConfigurable<CopyrightProfile> {
    private final CopyrightProfile myCopyrightProfile;
    private JPanel myWholePanel;
    private final Project myProject;
    private boolean myModified;
    private String myDisplayName;
    private final EditorTextField myEditor;
    private JButton myValidateButton;
    private JTextField myKeywordTf;
    private JTextField myAllowReplaceTextField;
    private JPanel myEditorPanel;

    public CopyrightConfigurable(@NotNull Project project, CopyrightProfile copyrightProfile, Runnable updater) {
        super(true, updater);
        this.myProject = project;
        this.myCopyrightProfile = copyrightProfile;
        this.$$$setupUI$$$();
        this.myDisplayName = this.myCopyrightProfile.getName();
        HashSet<Object> features = new HashSet<Object>();
        ContainerUtil.addIfNotNull(features, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
        features.add(SoftWrapsEditorCustomization.ENABLED);
        features.add(AdditionalPageAtBottomEditorCustomization.DISABLED);
        this.myEditor = EditorTextFieldProvider.getInstance().getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project, features);
        this.myEditorPanel.add((Component)this.myEditor.getComponent(), "Center");
    }

    public void setDisplayName(String s) {
        this.myCopyrightProfile.setName(s);
    }

    public CopyrightProfile getEditableObject() {
        return this.myCopyrightProfile;
    }

    public String getBannerSlogan() {
        return this.myCopyrightProfile.getName();
    }

    public JComponent createOptionsPanel() {
        this.myValidateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    VelocityHelper.verify(CopyrightConfigurable.this.myEditor.getDocument().getText());
                    Messages.showInfoMessage((Project)CopyrightConfigurable.this.myProject, (String)"Velocity template is valid.", (String)"Validation");
                }
                catch (Exception e1) {
                    Messages.showInfoMessage((Project)CopyrightConfigurable.this.myProject, (String)("Velocity template contains error:\n" + e1.getMessage()), (String)"Validation");
                }
            }
        });
        return this.myWholePanel;
    }

    @Nls
    public String getDisplayName() {
        return this.myCopyrightProfile.getName();
    }

    public boolean isModified() {
        return this.myModified || !Comparing.strEqual((String)EntityUtil.encode(this.myEditor.getDocument().getText()), (String)this.myCopyrightProfile.getNotice()) || !Comparing.strEqual((String)this.myKeywordTf.getText().trim(), (String)this.myCopyrightProfile.getKeyword()) || !Comparing.strEqual((String)this.myAllowReplaceTextField.getText().trim(), (String)this.myCopyrightProfile.getAllowReplaceRegexp()) || !Comparing.strEqual((String)this.myDisplayName, (String)this.myCopyrightProfile.getName());
    }

    public void apply() throws ConfigurationException {
        this.myCopyrightProfile.setNotice(EntityUtil.encode(this.myEditor.getDocument().getText()));
        this.myCopyrightProfile.setKeyword(CopyrightConfigurable.validateRegexpAndGet(this.myKeywordTf.getText().trim(), "Detect copyright regexp is incorrect: "));
        this.myCopyrightProfile.setAllowReplaceRegexp(CopyrightConfigurable.validateRegexpAndGet(this.myAllowReplaceTextField.getText().trim(), "Replace copyright regexp is incorrect: "));
        CopyrightManager.getInstance(this.myProject).replaceCopyright(this.myDisplayName, this.myCopyrightProfile);
        this.myDisplayName = this.myCopyrightProfile.getName();
        this.myModified = false;
    }

    @NotNull
    private static String validateRegexpAndGet(String regexp, String message) throws ConfigurationException {
        try {
            if (!StringUtil.isEmptyOrSpaces((String)regexp)) {
                Pattern.compile(regexp);
            }
        }
        catch (PatternSyntaxException e) {
            throw new ConfigurationException(message + e.getMessage());
        }
        return regexp;
    }

    public void reset() {
        this.myDisplayName = this.myCopyrightProfile.getName();
        SwingUtilities.invokeLater(() -> DocumentUtil.writeInRunUndoTransparentAction(() -> this.myEditor.getDocument().setText((CharSequence)EntityUtil.decode(this.myCopyrightProfile.getNotice()))));
        this.myKeywordTf.setText(this.myCopyrightProfile.getKeyword());
        this.myAllowReplaceTextField.setText(this.myCopyrightProfile.getAllowReplaceRegexp());
    }

    public void setModified(boolean modified) {
        this.myModified = modified;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JButton jButton;
        JTextField jTextField2;
        JPanel jPanel2;
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(5, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Regexp to detect copyright in comments:");
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeywordTf = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myValidateButton = jButton = new JButton();
        jButton.setText("Validate");
        jPanel2.add((Component)jButton, new GridConstraints(2, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Allow replacing copyright if old copyright matches:");
        jPanel2.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAllowReplaceTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Copyright text (may contain Velocity templates):");
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myEditorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

