/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiNamespaceInspection
extends EndpointInspectionBase {
    private static final String API_NAMESPACE_DOMAIN_ATTRIBUTE = "ownerDomain";
    private static final String API_NAMESPACE_NAME_ATTRIBUTE = "ownerName";
    private static final String API_NAMESPACE_PACKAGE_PATH_ATTRIBUTE = "packagePath";

    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("api.namespace.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return EndpointBundle.message("api.namespace.name", new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return EndpointBundle.message("api.namespace.short.name", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new EndpointPsiElementVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                boolean ownerFullySpecified;
                if (!EndpointUtilities.isEndpointClass((PsiElement)annotation)) {
                    return;
                }
                if (!annotation.getQualifiedName().equals("com.google.api.server.spi.config.ApiNamespace")) {
                    return;
                }
                PsiAnnotationMemberValue ownerDomainMember = annotation.findAttributeValue(ApiNamespaceInspection.API_NAMESPACE_DOMAIN_ATTRIBUTE);
                if (ownerDomainMember == null) {
                    return;
                }
                String ownerDomainWithQuotes = ownerDomainMember.getText();
                PsiAnnotationMemberValue ownerNameMember = annotation.findAttributeValue(ApiNamespaceInspection.API_NAMESPACE_NAME_ATTRIBUTE);
                if (ownerNameMember == null) {
                    return;
                }
                String ownerNameWithQuotes = ownerNameMember.getText();
                String ownerDomain = EndpointUtilities.removeBeginningAndEndingQuotes(ownerDomainWithQuotes);
                String ownerName = EndpointUtilities.removeBeginningAndEndingQuotes(ownerNameWithQuotes);
                String packagePath = EndpointUtilities.removeBeginningAndEndingQuotes(annotation.findAttributeValue(ApiNamespaceInspection.API_NAMESPACE_PACKAGE_PATH_ATTRIBUTE).getText());
                boolean allUnspecified = ownerDomain.isEmpty() && ownerName.isEmpty() && packagePath.isEmpty();
                boolean bl = ownerFullySpecified = !ownerDomain.isEmpty() && !ownerName.isEmpty();
                if (!allUnspecified && !ownerFullySpecified) {
                    holder.registerProblem((PsiElement)annotation, "Invalid namespace configuration. If a namespace is set, make sure to set an Owner Domain and Name. Package Path is optional.", new LocalQuickFix[]{new MyQuickFix()});
                }
            }
        };
    }

    public class MyQuickFix
    implements LocalQuickFix {
        private static final String SUGGESTED_OWNER_ATTRIBUTE = "YourCo";
        private static final String SUGGESTED_DOMAIN_ATTRIBUTE = "your-company.com";

        @NotNull
        public String getName() {
            return this.getFamilyName() + ": Add missing attributes";
        }

        @NotNull
        public String getFamilyName() {
            return ApiNamespaceInspection.this.getDisplayName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement == null) {
                return;
            }
            if (!(psiElement instanceof PsiAnnotation)) {
                return;
            }
            PsiAnnotation annotation = (PsiAnnotation)psiElement;
            if (!annotation.getQualifiedName().equals("com.google.api.server.spi.config.ApiNamespace")) {
                return;
            }
            PsiAnnotationMemberValue ownerDomainMember = annotation.findAttributeValue(ApiNamespaceInspection.API_NAMESPACE_DOMAIN_ATTRIBUTE);
            if (ownerDomainMember == null) {
                return;
            }
            String ownerDomainWithQuotes = ownerDomainMember.getText();
            PsiAnnotationMemberValue ownerNameMember = annotation.findAttributeValue(ApiNamespaceInspection.API_NAMESPACE_NAME_ATTRIBUTE);
            if (ownerNameMember == null) {
                return;
            }
            String ownerNameWithQuotes = ownerNameMember.getText();
            String ownerDomain = EndpointUtilities.removeBeginningAndEndingQuotes(ownerDomainWithQuotes);
            String ownerName = EndpointUtilities.removeBeginningAndEndingQuotes(ownerNameWithQuotes);
            if (ownerDomain.isEmpty() && ownerName.isEmpty()) {
                this.addOwnerDomainAndNameAttributes(project, annotation);
            } else if (ownerDomain.isEmpty() && !ownerName.isEmpty()) {
                this.addOwnerDomainAttribute(project, annotation);
            } else if (!ownerDomain.isEmpty() && ownerName.isEmpty()) {
                this.addOwnerNameAttribute(project, annotation);
            }
        }

        private void addOwnerDomainAttribute(final @NotNull Project project, final PsiAnnotation annotation) {
            new WriteCommandAction(project, new PsiFile[]{annotation.getContainingFile()}){

                protected void run(Result result) throws Throwable {
                    PsiAnnotationMemberValue newMemberValue = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@A(ownerDomain = \"your-company.com\")", null).findDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_DOMAIN_ATTRIBUTE);
                    annotation.setDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_DOMAIN_ATTRIBUTE, newMemberValue);
                }
            }.execute();
        }

        private void addOwnerNameAttribute(final @NotNull Project project, final PsiAnnotation annotation) {
            new WriteCommandAction(project, new PsiFile[]{annotation.getContainingFile()}){

                protected void run(Result result) throws Throwable {
                    PsiAnnotationMemberValue newMemberValue = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@A(ownerName = \"YourCo\")", null).findDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_NAME_ATTRIBUTE);
                    annotation.setDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_NAME_ATTRIBUTE, newMemberValue);
                }
            }.execute();
        }

        private void addOwnerDomainAndNameAttributes(final @NotNull Project project, final PsiAnnotation annotation) {
            new WriteCommandAction(project, new PsiFile[]{annotation.getContainingFile()}){

                protected void run(Result result) throws Throwable {
                    String annotationString = "@A(ownerName = \"YourCo\", ownerDomain = \"your-company.com\")";
                    PsiAnnotation newAnnotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(annotationString, null);
                    PsiAnnotationMemberValue newDomainMemberValue = newAnnotation.findDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_DOMAIN_ATTRIBUTE);
                    PsiAnnotationMemberValue newNameMemberValue = newAnnotation.findDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_NAME_ATTRIBUTE);
                    annotation.setDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_NAME_ATTRIBUTE, newNameMemberValue);
                    annotation.setDeclaredAttributeValue(ApiNamespaceInspection.API_NAMESPACE_DOMAIN_ATTRIBUTE, newDomainMemberValue);
                }
            }.execute();
        }
    }
}

