/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import org.jetbrains.annotations.Nullable;

public class CloudLineBreakpointProperties
extends XBreakpointProperties<CloudLineBreakpointProperties> {
    private static final String[] EMPTY_ARRAY = new String[0];
    private boolean myCreatedByServer = false;
    private boolean myDisabledByServer = false;
    private String[] myWatchExpressions;

    @Nullable
    public CloudLineBreakpointProperties getState() {
        return this;
    }

    @Tag(value="watch-expressions")
    public final String[] getWatchExpressions() {
        return this.myWatchExpressions != null ? this.myWatchExpressions : EMPTY_ARRAY;
    }

    public boolean isCreatedByServer() {
        return this.myCreatedByServer;
    }

    public void setCreatedByServer(boolean createdByServer) {
        this.myCreatedByServer = createdByServer;
    }

    public boolean isDisabledByServer() {
        return this.myDisabledByServer;
    }

    public void setDisabledByServer(boolean disabledByServer) {
        this.myDisabledByServer = disabledByServer;
    }

    public void loadState(CloudLineBreakpointProperties state) {
        this.myWatchExpressions = state.getWatchExpressions();
    }

    public final boolean setWatchExpressions(@Nullable String[] watchExpressions) {
        boolean changed = !CloudLineBreakpointProperties.arrayEqual(this.myWatchExpressions, watchExpressions);
        this.myWatchExpressions = watchExpressions;
        return changed;
    }

    private static boolean arrayEqual(@Nullable Object[] a, @Nullable Object[] b) {
        if (!(a != null && a.length != 0 || b != null && b.length != 0)) {
            return true;
        }
        return Comparing.equal((Object[])a, (Object[])b);
    }
}

