/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgProjectSettings;

public class HgExecutableManager {
    @NonNls
    private static final String[] DEFAULT_WINDOWS_PATHS = new String[]{"C:\\Program Files\\Mercurial", "C:\\Program Files (x86)\\Mercurial", "C:\\cygwin\\bin"};
    @NonNls
    private static final String[] DEFAULT_UNIX_PATHS = new String[]{"/usr/local/bin", "/usr/bin", "/opt/local/bin", "/opt/bin", "/usr/local/mercurial"};
    @NonNls
    private static final String DEFAULT_WINDOWS_HG = "hg.exe";
    @NonNls
    private static final String DEFAULT_UNIX_HG = "hg";
    @NotNull
    private final HgGlobalSettings myGlobalSettings;
    @NotNull
    private final AtomicNotNullLazyValue<String> myDetectedExecutable;

    public static HgExecutableManager getInstance() {
        return (HgExecutableManager)ServiceManager.getService(HgExecutableManager.class);
    }

    public HgExecutableManager(@NotNull HgGlobalSettings globalSettings) {
        this.myGlobalSettings = globalSettings;
        this.myDetectedExecutable = AtomicNotNullLazyValue.createValue(HgExecutableManager::identifyDefaultHgExecutable);
    }

    @NotNull
    public String getHgExecutable() {
        String path = this.myGlobalSettings.getHgExecutable();
        return path == null ? this.getDefaultExecutable() : path;
    }

    @NotNull
    public String getHgExecutable(@NotNull Project project) {
        HgProjectSettings projectSettings = HgProjectSettings.getInstance(project);
        if (!projectSettings.isHgExecutableOverridden()) {
            return this.getHgExecutable();
        }
        String path = projectSettings.getHgExecutable();
        return path == null ? this.getDefaultExecutable() : path;
    }

    @NotNull
    public String getDefaultExecutable() {
        return (String)this.myDetectedExecutable.getValue();
    }

    @NotNull
    private static String identifyDefaultHgExecutable() {
        String[] paths;
        String programName;
        if (SystemInfo.isWindows) {
            programName = DEFAULT_WINDOWS_HG;
            paths = DEFAULT_WINDOWS_PATHS;
        } else {
            programName = DEFAULT_UNIX_HG;
            paths = DEFAULT_UNIX_PATHS;
        }
        for (String p : paths) {
            Path programPath = Paths.get(p, programName);
            if (!Files.isExecutable(programPath)) continue;
            return programPath.toAbsolutePath().toString();
        }
        return programName;
    }
}

