/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.util.HgUtil;

public class HgFile {
    private final VirtualFile vcsRoot;
    private final File file;
    private String relativePath;

    public HgFile(@NotNull VirtualFile vcsRoot, File file) {
        this.vcsRoot = vcsRoot;
        this.file = file;
    }

    public HgFile(@NotNull VirtualFile vcsRoot, FilePath filePath) {
        this(vcsRoot, filePath.getIOFile());
    }

    public HgFile(@NotNull Project project, @NotNull VirtualFile file) {
        this(HgUtil.getHgRootOrNull(project, file), VcsUtil.getFilePath((String)file.getPath()));
    }

    @NotNull
    public VirtualFile getRepo() {
        return this.vcsRoot;
    }

    public File getFile() {
        return this.file;
    }

    @Nullable
    public String getRelativePath() {
        if (this.relativePath == null) {
            this.relativePath = FileUtil.getRelativePath((File)VfsUtilCore.virtualToIoFile((VirtualFile)this.vcsRoot), (File)this.file);
        }
        return this.relativePath;
    }

    @NotNull
    public FilePath toFilePath() {
        return VcsUtil.getFilePath((File)this.file);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgFile that = (HgFile)o;
        if (!this.vcsRoot.equals(that.vcsRoot)) {
            return false;
        }
        return !(this.file != null ? !FileUtil.filesEqual((File)this.file, (File)that.file) : that.file != null);
    }

    public int hashCode() {
        return Objects.hash(this.vcsRoot, this.file);
    }

    public String toString() {
        return MoreObjects.toStringHelper(HgFile.class).add("repo", (Object)this.vcsRoot).add("file", (Object)this.file).add("relativePath", (Object)this.getRelativePath()).toString();
    }
}

