/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.util.HgUtil;

public class HgFileRevision
implements VcsFileRevision {
    private final Project myProject;
    @NotNull
    private final HgFile myFile;
    @NotNull
    private final HgRevisionNumber myRevisionNumber;
    private final String myBranchName;
    private final Date myRevisionDate;
    private final String myAuthor;
    private final String myCommitMessage;
    private final Set<String> myFilesModified;
    private final Set<String> myFilesAdded;
    private final Set<String> myFilesDeleted;
    private final Map<String, String> myFilesMoved;

    public HgFileRevision(Project project, @NotNull HgFile hgFile, @NotNull HgRevisionNumber vcsRevisionNumber, String branchName, Date revisionDate, String author, String commitMessage, Set<String> filesModified, Set<String> filesAdded, Set<String> filesDeleted, Map<String, String> filesMoved) {
        this.myProject = project;
        this.myFile = hgFile;
        this.myRevisionNumber = vcsRevisionNumber;
        this.myBranchName = branchName;
        this.myRevisionDate = revisionDate;
        this.myAuthor = author;
        this.myCommitMessage = commitMessage;
        this.myFilesModified = filesModified;
        this.myFilesAdded = filesAdded;
        this.myFilesDeleted = filesDeleted;
        this.myFilesMoved = filesMoved;
    }

    @NotNull
    public HgRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }

    public String getBranchName() {
        return this.myBranchName;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public Date getRevisionDate() {
        return this.myRevisionDate;
    }

    @Nullable
    public String getAuthor() {
        return this.myAuthor;
    }

    @Nullable
    public String getCommitMessage() {
        return this.myCommitMessage;
    }

    @NotNull
    public Set<String> getModifiedFiles() {
        return this.myFilesModified;
    }

    @NotNull
    public Set<String> getAddedFiles() {
        return this.myFilesAdded;
    }

    @NotNull
    public Set<String> getDeletedFiles() {
        return this.myFilesDeleted;
    }

    @NotNull
    public Map<String, String> getMovedFiles() {
        return this.myFilesMoved;
    }

    @NotNull
    public byte[] loadContent() {
        HgFile fileToCat = HgUtil.getFileNameInTargetRevision(this.myProject, this.myRevisionNumber, this.myFile);
        return HgUtil.loadContent(this.myProject, this.myRevisionNumber, fileToCat);
    }

    public byte[] getContent() throws IOException, VcsException {
        return this.loadContent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgFileRevision revision = (HgFileRevision)o;
        if (!this.myFile.equals(revision.myFile)) {
            return false;
        }
        return this.myRevisionNumber.equals(revision.myRevisionNumber);
    }

    public int hashCode() {
        return Objects.hash(this.myFile, this.myRevisionNumber);
    }
}

