/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.PublicMethodBasedOptionDescription;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgProjectSettings;

public final class HgOptionsTopHitProvider
extends OptionsTopHitProvider {
    public String getId() {
        return "vcs";
    }

    @NotNull
    public Collection<OptionDescription> getOptions(@Nullable Project project) {
        if (project != null) {
            for (VcsDescriptor descriptor : ProjectLevelVcsManager.getInstance((Project)project).getAllVcss()) {
                if (!"Mercurial".equals(descriptor.getDisplayName())) continue;
                return Collections.unmodifiableCollection(Arrays.asList(HgOptionsTopHitProvider.option(project, "Mercurial: Check for incoming and outgoing changesets", "isCheckIncomingOutgoing", "setCheckIncomingOutgoing"), HgOptionsTopHitProvider.option(project, "Mercurial: Ignore whitespace differences in annotations", "isWhitespacesIgnoredInAnnotations", "setIgnoreWhitespacesInAnnotations")));
            }
        }
        return Collections.emptyList();
    }

    private static BooleanOptionDescription option(final Project project, String option, String getter, String setter) {
        return new PublicMethodBasedOptionDescription(option, "vcs.Mercurial", getter, setter){

            public Object getInstance() {
                return ServiceManager.getService((Project)project, HgProjectSettings.class);
            }
        };
    }
}

