/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.ui.HgConfigurationProjectPanel;

public class HgProjectConfigurable
extends ConfigurableBase<HgConfigurationProjectPanel, HgSettingsHolder> {
    public static final String DISPLAY_NAME = HgVcsMessages.message("hg4idea.mercurial", new Object[0]);
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgSettingsHolder mySettingsHolder;

    public HgProjectConfigurable(@NotNull Project project, @NotNull HgGlobalSettings globalSettings, @NotNull HgProjectSettings projectSettings) {
        super("vcs.Mercurial", DISPLAY_NAME, "project.propVCSSupport.VCSs.Mercurial");
        this.myProject = project;
        this.mySettingsHolder = new HgSettingsHolder(globalSettings, projectSettings);
    }

    @NotNull
    protected HgSettingsHolder getSettings() {
        return this.mySettingsHolder;
    }

    protected HgConfigurationProjectPanel createUi() {
        return new HgConfigurationProjectPanel(this.myProject);
    }

    public static class HgSettingsHolder {
        @NotNull
        private final HgGlobalSettings myGlobalSettings;
        @NotNull
        private final HgProjectSettings myProjectSettings;

        HgSettingsHolder(@NotNull HgGlobalSettings globalSettings, @NotNull HgProjectSettings projectSettings) {
            this.myGlobalSettings = globalSettings;
            this.myProjectSettings = projectSettings;
        }

        @NotNull
        public HgGlobalSettings getGlobalSettings() {
            return this.myGlobalSettings;
        }

        @NotNull
        public HgProjectSettings getProjectSettings() {
            return this.myProjectSettings;
        }
    }
}

