/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.branch.DvcsBranchPopup;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.RootAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.branch.HgBranchPopupActions;
import org.zmlx.hg4idea.branch.HgCommonBranchActions;
import org.zmlx.hg4idea.branch.HgMultiRootBranchConfig;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBranchPopup
extends DvcsBranchPopup<HgRepository> {
    private static final String DIMENSION_SERVICE_KEY = "Hg.Branch.Popup";
    static final String SHOW_ALL_BRANCHES_KEY = "Hg.Branch.Popup.ShowAllBranches";
    static final String SHOW_ALL_BOOKMARKS_KEY = "Hg.Branch.Popup.ShowAllBookmarks";
    static final String SHOW_ALL_REPOSITORIES = "Hg.Branch.Popup.ShowAllRepositories";

    public static HgBranchPopup getInstance(@NotNull Project project, @NotNull HgRepository currentRepository) {
        HgRepositoryManager manager = HgUtil.getRepositoryManager(project);
        HgProjectSettings hgProjectSettings = (HgProjectSettings)ServiceManager.getService((Project)project, HgProjectSettings.class);
        HgMultiRootBranchConfig hgMultiRootBranchConfig = new HgMultiRootBranchConfig(manager.getRepositories());
        return new HgBranchPopup(currentRepository, manager, hgMultiRootBranchConfig, hgProjectSettings, (Condition<AnAction>)Conditions.alwaysFalse());
    }

    private HgBranchPopup(@NotNull HgRepository currentRepository, @NotNull HgRepositoryManager repositoryManager, @NotNull HgMultiRootBranchConfig hgMultiRootBranchConfig, @NotNull HgProjectSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition) {
        super((Repository)currentRepository, (AbstractRepositoryManager)repositoryManager, (DvcsMultiRootBranchConfig)hgMultiRootBranchConfig, (DvcsSyncSettings)vcsSettings, preselectActionCondition, DIMENSION_SERVICE_KEY);
    }

    protected void fillWithCommonRepositoryActions(@NotNull LightActionGroup popupGroup, @NotNull AbstractRepositoryManager<HgRepository> repositoryManager) {
        List allRepositories = repositoryManager.getRepositories();
        popupGroup.add((AnAction)new HgBranchPopupActions.HgNewBranchAction(this.myProject, allRepositories, (HgRepository)this.myCurrentRepository));
        popupGroup.addAction((AnAction)new HgBranchPopupActions.HgNewBookmarkAction(allRepositories, (HgRepository)this.myCurrentRepository));
        popupGroup.addAction((AnAction)new HgBranchPopupActions.HgCloseBranchAction(allRepositories, (HgRepository)this.myCurrentRepository));
        popupGroup.addAction((AnAction)new HgBranchPopupActions.HgShowUnnamedHeadsForCurrentBranchAction((HgRepository)this.myCurrentRepository));
        popupGroup.addAll((ActionGroup)this.createRepositoriesActions());
        popupGroup.addSeparator("Common Branches");
        List branchActions = this.myMultiRootBranchConfig.getLocalBranchNames().stream().map(b -> this.createLocalBranchActions(allRepositories, (String)b, false)).filter(Objects::nonNull).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR).collect(Collectors.toList());
        int topShownBranches = BranchActionUtil.getNumOfTopShownBranches(branchActions);
        String commonBranch = MultiRootBranches.getCommonName((Collection)this.myRepositoryManager.getRepositories(), Repository::getCurrentBranchName);
        if (commonBranch != null) {
            branchActions.add(0, new HgBranchPopupActions.CurrentBranch(this.myProject, allRepositories, commonBranch));
            ++topShownBranches;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, branchActions, (int)topShownBranches, (String)SHOW_ALL_BRANCHES_KEY, (boolean)true);
        popupGroup.addSeparator("Common Bookmarks");
        List bookmarkActions = ((HgMultiRootBranchConfig)this.myMultiRootBranchConfig).getBookmarkNames().stream().map(bm -> this.createLocalBranchActions(allRepositories, (String)bm, true)).filter(Objects::nonNull).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR).collect(Collectors.toList());
        int topShownBookmarks = BranchActionUtil.getNumOfTopShownBranches(bookmarkActions);
        String commonBookmark = MultiRootBranches.getCommonName((Collection)repositoryManager.getRepositories(), HgRepository::getCurrentBookmark);
        if (commonBookmark != null) {
            bookmarkActions.add(0, new HgBranchPopupActions.CurrentActiveBookmark(this.myProject, allRepositories, commonBookmark));
            ++topShownBookmarks;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, bookmarkActions, (int)topShownBookmarks, (String)SHOW_ALL_BOOKMARKS_KEY, (boolean)true);
    }

    @Nullable
    private HgCommonBranchActions createLocalBranchActions(List<HgRepository> allRepositories, String name, boolean isBookmark) {
        List repositories = this.filterRepositoriesNotOnThisBranch(name, allRepositories);
        if (repositories.isEmpty()) {
            return null;
        }
        return isBookmark ? new HgBranchPopupActions.BookmarkActions(this.myProject, repositories, name) : new HgBranchPopupActions.BranchActions(this.myProject, repositories, name);
    }

    @NotNull
    protected LightActionGroup createRepositoriesActions() {
        LightActionGroup popupGroup = new LightActionGroup(false);
        popupGroup.addSeparator("Repositories");
        List rootActions = DvcsUtil.sortRepositories((Collection)this.myRepositoryManager.getRepositories()).stream().map(repo -> new RootAction((Repository)repo, new HgBranchPopupActions(repo.getProject(), (HgRepository)repo).createActions(), HgUtil.getDisplayableBranchOrBookmarkText(repo))).collect(Collectors.toList());
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, rootActions, (int)(rootActions.size() > 8 ? 5 : 8), (String)SHOW_ALL_REPOSITORIES);
        return popupGroup;
    }

    protected void fillPopupWithCurrentRepositoryActions(@NotNull LightActionGroup popupGroup, @Nullable LightActionGroup actions) {
        popupGroup.addAll(new HgBranchPopupActions(this.myProject, (HgRepository)this.myCurrentRepository).createActions(actions, this.myRepoTitleInfo, true));
    }
}

