/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCompareBranchesHelper
implements CompareBranchesHelper {
    private final Project myProject;

    public HgCompareBranchesHelper(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public RepositoryManager getRepositoryManager() {
        return HgUtil.getRepositoryManager(this.myProject);
    }

    @NotNull
    public DvcsCompareSettings getDvcsCompareSettings() {
        return HgProjectSettings.getInstance(this.myProject);
    }

    @NotNull
    public String formatLogCommand(@NotNull String firstBranch, @NotNull String secondBranch) {
        return String.format("hg log -r \"reverse(%s%%%s)\"", secondBranch, firstBranch);
    }
}

