/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgCommandExitCode;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgRemoteCommandExecutor;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgPullCommand {
    private final Project project;
    private final VirtualFile repo;
    private String source;
    private String revision;
    private boolean update;
    private boolean rebase;

    public HgPullCommand(Project project, @NotNull VirtualFile repo) {
        this.project = project;
        this.repo = repo;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public void setRebase(boolean rebase) {
        this.rebase = rebase;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public HgCommandExitCode executeInCurrentThread() {
        LinkedList<String> arguments = new LinkedList<String>();
        if (this.update) {
            arguments.add("--update");
        } else if (this.rebase) {
            arguments.add("--rebase");
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.revision)) {
            arguments.add("--rev");
            arguments.add(this.revision);
        }
        arguments.add(this.source);
        HgRemoteCommandExecutor executor = new HgRemoteCommandExecutor(this.project, this.source);
        executor.setShowOutput(true);
        HgCommandResult result = executor.executeInCurrentThread(this.repo, "pull", arguments);
        if (HgErrorUtil.isAuthorizationError(result)) {
            new HgCommandResultNotifier(this.project).notifyError(result, "Authorization required", "http authorization required for <code>" + this.source + "</code>");
            return HgCommandExitCode.ERROR;
        }
        if (HgErrorUtil.isAbort(result) || result.getExitValue() > 1) {
            new HgCommandResultNotifier(this.project).notifyError(result, "", "Pull failed");
            return HgCommandExitCode.ERROR;
        }
        if (result.getExitValue() == 1) {
            return HgCommandExitCode.UNRESOLVED;
        }
        ((HgUpdater)BackgroundTaskUtil.syncPublisher((Project)this.project, HgVcs.REMOTE_TOPIC)).update(this.project, null);
        return HgCommandExitCode.SUCCESS;
    }
}

