/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import org.jetbrains.annotations.NotNull;

public abstract class HgLineProcessListener {
    @NotNull
    private final StringBuilder myErrorOutput = new StringBuilder();
    private int myExitCode;
    @NotNull
    private byte[] myBinaryOutput = new byte[0];

    public void onLineAvailable(String line, Key outputType) {
        if (ProcessOutputTypes.STDOUT == outputType) {
            this.processOutputLine(line);
        } else if (ProcessOutputTypes.STDERR == outputType) {
            this.processErrorLine(line);
        }
    }

    protected void processErrorLine(@NotNull String line) {
        this.myErrorOutput.append(line).append("\n");
    }

    protected abstract void processOutputLine(@NotNull String var1);

    @NotNull
    public StringBuilder getErrorOutput() {
        return this.myErrorOutput;
    }

    public void finish() throws VcsException {
        if (this.myExitCode != 0 && this.myErrorOutput.length() != 0) {
            throw new VcsException(this.myErrorOutput.toString());
        }
    }

    public void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    public void setBinaryOutput(@NotNull byte[] output) {
        this.myBinaryOutput = output;
    }

    @NotNull
    public byte[] getBinaryOutput() {
        return this.myBinaryOutput;
    }
}

