/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.provider.HgChangeProvider;

public class HgCommit
extends VcsChangesLazilyParsedDetails {
    @NotNull
    private final HgRevisionNumber myRevisionNumber;

    public HgCommit(@NotNull Project project, VirtualFile root, @NotNull Hash hash, @NotNull List<Hash> parentsHashes, @NotNull HgRevisionNumber vcsRevisionNumber, @NotNull VcsUser author, long time, List<List<VcsFileStatusInfo>> reportedChanges) {
        super(hash, parentsHashes, time, root, vcsRevisionNumber.getSubject(), author, vcsRevisionNumber.getCommitMessage(), author, time);
        this.myRevisionNumber = vcsRevisionNumber;
        this.myChanges.set(reportedChanges.isEmpty() ? EMPTY_CHANGES : new UnparsedChanges(project, reportedChanges));
    }

    private class UnparsedChanges
    extends VcsChangesLazilyParsedDetails.UnparsedChanges {
        private UnparsedChanges(@NotNull Project project, List<List<VcsFileStatusInfo>> changesOutput) {
            super((VcsChangesLazilyParsedDetails)HgCommit.this, project, changesOutput);
        }

        @NotNull
        protected List<Change> parseStatusInfo(@NotNull List<VcsFileStatusInfo> changes, int parentIndex) {
            ArrayList result = ContainerUtil.newArrayList();
            for (VcsFileStatusInfo info : changes) {
                String filePath = info.getFirstPath();
                HgRevisionNumber parentRevision = HgCommit.this.myRevisionNumber.getParents().isEmpty() ? null : HgCommit.this.myRevisionNumber.getParents().get(parentIndex);
                switch (info.getType()) {
                    case MODIFICATION: {
                        result.add(HgHistoryUtil.createChange(this.myProject, HgCommit.this.getRoot(), filePath, parentRevision, filePath, HgCommit.this.myRevisionNumber, FileStatus.MODIFIED));
                        break;
                    }
                    case NEW: {
                        result.add(HgHistoryUtil.createChange(this.myProject, HgCommit.this.getRoot(), null, null, filePath, HgCommit.this.myRevisionNumber, FileStatus.ADDED));
                        break;
                    }
                    case DELETED: {
                        result.add(HgHistoryUtil.createChange(this.myProject, HgCommit.this.getRoot(), filePath, parentRevision, null, HgCommit.this.myRevisionNumber, FileStatus.DELETED));
                        break;
                    }
                    case MOVED: {
                        result.add(HgHistoryUtil.createChange(this.myProject, HgCommit.this.getRoot(), filePath, parentRevision, info.getSecondPath(), HgCommit.this.myRevisionNumber, HgChangeProvider.RENAMED));
                    }
                }
            }
            return result;
        }
    }
}

