/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Base64;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.gradle.model.artifacts.JpsGradleArtifactExtension;
import org.jetbrains.jps.gradle.model.impl.artifacts.GradleArtifactExtensionProperties;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;

public class GradleArtifactBuildTaskProvider
extends ArtifactBuildTaskProvider {
    @NotNull
    public List<? extends BuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        JpsGradleArtifactExtension extension;
        String artifactName = artifact.getName();
        if (buildPhase == ArtifactBuildTaskProvider.ArtifactBuildPhase.PRE_PROCESSING && artifactName.endsWith(" (exploded)") && artifact.getRootElement() instanceof JpsArtifactRootElement && (extension = GradleArtifactBuildTaskProvider.getArtifactExtension(artifact, buildPhase)) != null && extension.getProperties() != null) {
            return ContainerUtil.list((Object[])new GradleGenerationBuildTask[]{new GradleManifestGenerationBuildTask(artifact, extension.getProperties()), new GradleAdditionalFilesGenerationBuildTask(artifact, extension.getProperties())});
        }
        return Collections.emptyList();
    }

    @Nullable
    private static JpsGradleArtifactExtension getArtifactExtension(JpsArtifact artifact, ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        if (buildPhase == ArtifactBuildTaskProvider.ArtifactBuildPhase.PRE_PROCESSING) {
            return JpsGradleExtensionService.getArtifactExtension(artifact);
        }
        return null;
    }

    private static class GradleAdditionalFilesGenerationBuildTask
    extends GradleGenerationBuildTask {
        private static final Logger LOG = Logger.getInstance(GradleAdditionalFilesGenerationBuildTask.class);

        GradleAdditionalFilesGenerationBuildTask(@NotNull JpsArtifact artifact, @NotNull GradleArtifactExtensionProperties properties) {
            super(artifact, properties);
        }

        public void build(CompileContext context) {
            if (this.myProperties.additionalFiles != null) {
                for (Map.Entry<String, String> entry : this.myProperties.additionalFiles.entrySet()) {
                    try {
                        File output = new File(entry.getKey());
                        FileUtil.writeToFile((File)output, (byte[])Base64.decode((String)entry.getValue()));
                    }
                    catch (Exception e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
        }
    }

    private static class GradleManifestGenerationBuildTask
    extends GradleGenerationBuildTask {
        private static final Logger LOG = Logger.getInstance(GradleManifestGenerationBuildTask.class);

        GradleManifestGenerationBuildTask(@NotNull JpsArtifact artifact, @NotNull GradleArtifactExtensionProperties properties) {
            super(artifact, properties);
        }

        public void build(CompileContext context) {
            if (this.myProperties.manifest != null) {
                try {
                    File output = new File(this.myArtifact.getOutputPath(), "META-INF/MANIFEST.MF");
                    FileUtil.writeToFile((File)output, (byte[])Base64.decode((String)this.myProperties.manifest));
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
        }
    }

    private static abstract class GradleGenerationBuildTask
    extends BuildTask {
        protected final JpsArtifact myArtifact;
        protected final GradleArtifactExtensionProperties myProperties;

        GradleGenerationBuildTask(@NotNull JpsArtifact artifact, @NotNull GradleArtifactExtensionProperties properties) {
            this.myArtifact = artifact;
            this.myProperties = properties;
        }
    }
}

