/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.gradle.model.impl.GradleModuleResourceConfiguration;
import org.jetbrains.jps.gradle.model.impl.GradleProjectConfiguration;
import org.jetbrains.jps.gradle.model.impl.GradleResourceRootDescriptor;
import org.jetbrains.jps.gradle.model.impl.GradleResourcesTargetType;
import org.jetbrains.jps.gradle.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class GradleResourcesTarget
extends ModuleBasedTarget<GradleResourceRootDescriptor> {
    GradleResourcesTarget(GradleResourcesTargetType type, @NotNull JpsModule module) {
        super((ModuleBasedBuildTargetType)type, module);
    }

    public String getId() {
        return this.myModule.getName();
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        return Collections.emptyList();
    }

    public boolean isCompiledBeforeModuleLevelBuilders() {
        return true;
    }

    @NotNull
    public List<GradleResourceRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        ArrayList<GradleResourceRootDescriptor> result = new ArrayList<GradleResourceRootDescriptor>();
        GradleProjectConfiguration projectConfig = JpsGradleExtensionService.getInstance().getGradleProjectConfiguration(dataPaths);
        GradleModuleResourceConfiguration moduleConfig = projectConfig.moduleConfigurations.get(this.myModule.getName());
        if (moduleConfig == null) {
            return Collections.emptyList();
        }
        int i = 0;
        for (ResourceRootConfiguration resource : this.getRootConfigurations(moduleConfig)) {
            result.add(new GradleResourceRootDescriptor(this, resource, i++, moduleConfig.overwrite));
        }
        return result;
    }

    private Collection<ResourceRootConfiguration> getRootConfigurations(@Nullable GradleModuleResourceConfiguration moduleConfig) {
        if (moduleConfig != null) {
            return this.isTests() ? moduleConfig.testResources : moduleConfig.resources;
        }
        return Collections.emptyList();
    }

    public GradleModuleResourceConfiguration getModuleResourcesConfiguration(BuildDataPaths dataPaths) {
        GradleProjectConfiguration projectConfig = JpsGradleExtensionService.getInstance().getGradleProjectConfiguration(dataPaths);
        return projectConfig.moduleConfigurations.get(this.myModule.getName());
    }

    public boolean isTests() {
        return ((GradleResourcesTargetType)this.getTargetType()).isTests();
    }

    @Nullable
    public GradleResourceRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (GradleResourceRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        return this.getTargetType().getTypeId() + ":" + this.myModule.getName();
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        GradleModuleResourceConfiguration configuration = this.getModuleResourcesConfiguration(context.getProjectDescriptor().dataManager.getDataPaths());
        THashSet result = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        File moduleOutput = this.getModuleOutputDir();
        for (ResourceRootConfiguration resConfig : this.getRootConfigurations(configuration)) {
            File output = GradleResourcesTarget.getOutputDir(moduleOutput, resConfig, configuration.outputDirectory);
            if (output == null) continue;
            result.add(output);
        }
        return result;
    }

    @Nullable
    public File getModuleOutputDir() {
        return JpsJavaExtensionService.getInstance().getOutputDirectory(this.myModule, this.isTests());
    }

    @Nullable
    public static File getOutputDir(@Nullable File moduleOutput, ResourceRootConfiguration config, @Nullable String outputDirectory) {
        if (outputDirectory != null) {
            moduleOutput = JpsPathUtil.urlToFile((String)outputDirectory);
        }
        if (moduleOutput == null) {
            return null;
        }
        String targetPath = config.targetPath;
        if (StringUtil.isEmptyOrSpaces((String)targetPath)) {
            return moduleOutput;
        }
        File targetPathFile = new File(targetPath);
        File outputFile = targetPathFile.isAbsolute() ? targetPathFile : new File(moduleOutput, targetPath);
        return new File(FileUtil.toCanonicalPath((String)outputFile.getPath()));
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        BuildDataPaths dataPaths = pd.getTargetsState().getDataPaths();
        GradleModuleResourceConfiguration configuration = this.getModuleResourcesConfiguration(dataPaths);
        if (configuration != null) {
            out.write(Integer.toHexString(configuration.computeConfigurationHash(this.isTests())));
        }
    }
}

